/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.customPayment.CustomPaymentForm;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.OrderServiceExtension;
import com.floreantpos.main.Application;
import com.floreantpos.model.CustomPayment;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.CustomPaymentDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class PaymentOptionConfigurationView
extends ConfigurationView {
    private Terminal a;
    private JCheckBox b;
    private JCheckBox c;
    private JCheckBox d;
    private JCheckBox e;
    private JCheckBox f;
    private JCheckBox g;
    private JTable h;

    public PaymentOptionConfigurationView(Terminal terminal) {
        this.a = terminal;
        this.setLayout(new BorderLayout());
        this.b();
        this.initData();
        this.a();
    }

    public void initData() {
        OrderServiceExtension orderServiceExtension = (OrderServiceExtension)ExtensionManager.getPlugin(OrderServiceExtension.class);
        if (orderServiceExtension == null) {
            this.g.setVisible(false);
        }
        List<CustomPayment> list = CustomPaymentDAO.getInstance().findAll();
        BeanTableModel beanTableModel = (BeanTableModel)this.h.getModel();
        beanTableModel.removeAll();
        beanTableModel.addRows(list);
    }

    private void a() {
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                if (jCheckBox.isSelected()) {
                    PaymentOptionConfigurationView.this.f.setSelected(false);
                    PaymentOptionConfigurationView.this.f.setEnabled(false);
                } else {
                    PaymentOptionConfigurationView.this.f.setEnabled(true);
                }
            }
        });
    }

    private void b() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx, hidemode 3"));
        this.b = new JCheckBox(Messages.getString("PaymentOptionConfigurationView.1"));
        this.c = new JCheckBox(Messages.getString("PaymentOptionConfigurationView.2"));
        this.d = new JCheckBox(Messages.getString("PaymentOptionConfigurationView.3"));
        this.e = new JCheckBox(Messages.getString("PaymentOptionConfigurationView.4"));
        this.f = new JCheckBox(Messages.getString("PaymentOptionConfigurationView.5"));
        this.g = new JCheckBox(Messages.getString("PaymentOptionConfigurationView.6"));
        this.h = new JTable();
        JScrollPane jScrollPane = new JScrollPane(this.h);
        BeanTableModel beanTableModel = new BeanTableModel(CustomPayment.class);
        beanTableModel.addColumn(Messages.getString("CustomPaymentBrowser.0"), CustomPayment.PROP_ID);
        beanTableModel.addColumn(Messages.getString("CustomPaymentBrowser.1"), CustomPayment.PROP_NAME);
        beanTableModel.addColumn(Messages.getString("CustomPaymentBrowser.2"), CustomPayment.PROP_REF_NUMBER_FIELD_NAME);
        this.h.setModel(beanTableModel);
        this.h.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    PaymentOptionConfigurationView.this.d();
                }
            }
        });
        JPanel jPanel2 = new JPanel(new BorderLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(null, Messages.getString("PaymentOptionConfigurationView.7"), 2, 0);
        jPanel2.setBorder(titledBorder);
        jPanel2.add((Component)jScrollPane, "Center");
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("center"));
        JButton jButton = new JButton(Messages.getString("PaymentOptionConfigurationView.9"));
        JButton jButton2 = new JButton(Messages.getString("PaymentOptionConfigurationView.10"));
        JButton jButton3 = new JButton(Messages.getString("PaymentOptionConfigurationView.11"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PaymentOptionConfigurationView.this.c();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PaymentOptionConfigurationView.this.d();
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PaymentOptionConfigurationView.this.e();
            }
        });
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        jPanel3.add(jButton3);
        jPanel2.add((Component)jPanel3, "South");
        jPanel.add((Component)this.b, "wrap");
        jPanel.add((Component)this.c, "wrap");
        jPanel.add((Component)this.d, "wrap");
        jPanel.add((Component)this.g, "wrap");
        jPanel.add((Component)new JSeparator(), "grow, wrap");
        jPanel.add((Component)this.e, "wrap");
        jPanel.add((Component)this.f, "gapleft 15, wrap");
        jPanel.add((Component)jPanel2, "grow, span");
        this.add(jPanel);
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            TerminalDAO.getInstance().saveOrUpdate(this.a);
            return true;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage());
            return false;
        }
    }

    public void updateView() {
        try {
            if (this.a == null) {
                return;
            }
            boolean bl = this.a.getProperty("hideCashPayment") == null ? false : Boolean.valueOf(this.a.getProperty("hideCashPayment"));
            boolean bl2 = this.a.getProperty("hideCardPayment") == null ? false : Boolean.valueOf(this.a.getProperty("hideCardPayment"));
            boolean bl3 = this.a.getProperty("hideGiftCardPayment") == null ? false : Boolean.valueOf(this.a.getProperty("hideGiftCardPayment"));
            boolean bl4 = this.a.getProperty("hideCustomPayment") == null ? false : Boolean.valueOf(this.a.getProperty("hideCustomPayment"));
            boolean bl5 = this.a.getProperty("showIndivBtn") == null ? false : Boolean.valueOf(this.a.getProperty("showIndivBtn"));
            boolean bl6 = this.a.getProperty("hideCustBlncPayment") == null ? false : Boolean.valueOf(this.a.getProperty("hideCustBlncPayment"));
            this.b.setSelected(bl);
            this.c.setSelected(bl2);
            this.d.setSelected(bl3);
            this.e.setSelected(bl4);
            this.f.setSelected(bl5);
            this.g.setSelected(bl6);
            this.f.setEnabled(!bl4);
            this.setInitialized(true);
        }
        catch (Exception exception) {
            PosLog.error(PaymentOptionConfigurationView.class, exception);
        }
    }

    public boolean updateModel() {
        this.a = Application.getInstance().refreshAndGetTerminal();
        this.a.addProperty("hideCashPayment", String.valueOf(this.b.isSelected()));
        this.a.addProperty("hideCardPayment", String.valueOf(this.c.isSelected()));
        this.a.addProperty("hideGiftCardPayment", String.valueOf(this.d.isSelected()));
        this.a.addProperty("hideCustomPayment", String.valueOf(this.e.isSelected()));
        this.a.addProperty("showIndivBtn", String.valueOf(this.f.isSelected()));
        this.a.addProperty("hideCustBlncPayment", String.valueOf(this.g.isSelected()));
        return true;
    }

    @Override
    public void initialize() throws Exception {
        this.updateView();
    }

    @Override
    public String getName() {
        return Messages.getString("PaymentOptionConfigurationView.20");
    }

    private void c() {
        CustomPaymentForm customPaymentForm = new CustomPaymentForm();
        customPaymentForm.createNew();
        customPaymentForm.setFieldsEnable(true);
        BeanEditorDialog beanEditorDialog = new BeanEditorDialog(customPaymentForm);
        beanEditorDialog.openWithScale(500, 500);
        BeanTableModel beanTableModel = (BeanTableModel)this.h.getModel();
        if (((CustomPayment)customPaymentForm.getBean()).getId() != null && StringUtils.isNotEmpty((String)((CustomPayment)customPaymentForm.getBean()).getId())) {
            beanTableModel.addRow(customPaymentForm.getBean());
        }
    }

    private void d() {
        int n = this.h.getSelectedRow();
        if (n < 0) {
            return;
        }
        n = this.h.convertRowIndexToModel(n);
        BeanTableModel beanTableModel = (BeanTableModel)this.h.getModel();
        CustomPayment customPayment = (CustomPayment)beanTableModel.getRow(n);
        CustomPaymentForm customPaymentForm = new CustomPaymentForm(customPayment);
        customPaymentForm.setFieldsEnable(true);
        BeanEditorDialog beanEditorDialog = new BeanEditorDialog(customPaymentForm);
        beanEditorDialog.openWithScale(500, 500);
        beanTableModel.fireTableDataChanged();
    }

    private void e() {
        int n = this.h.getSelectedRow();
        if (n < 0) {
            return;
        }
        n = this.h.convertRowIndexToModel(n);
        BeanTableModel beanTableModel = (BeanTableModel)this.h.getModel();
        CustomPayment customPayment = (CustomPayment)beanTableModel.getRow(n);
        CustomPaymentForm customPaymentForm = new CustomPaymentForm(customPayment);
        int n2 = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("PaymentOptionConfigurationView.21"), Messages.getString("PaymentOptionConfigurationView.22"));
        if (n2 != 0) {
            return;
        }
        customPaymentForm.delete();
        beanTableModel.removeRow(n);
        beanTableModel.fireTableDataChanged();
    }
}

