/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.model.VirtualPrinter;
import com.floreantpos.model.dao.VirtualPrinterDAO;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class VirtualPrinterConfigDialog
extends POSDialog {
    private VirtualPrinter a;
    private FixedLengthTextField b;

    public VirtualPrinterConfigDialog() throws HeadlessException {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        this.setTitle(Messages.getString("VirtualPrinterConfigDialog.0"));
        this.init();
        this.pack();
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
    }

    public void init() {
        this.getContentPane().setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][][]"));
        JLabel jLabel = new JLabel(Messages.getString("VirtualPrinterConfigDialog.4"));
        this.getContentPane().add((Component)jLabel, "cell 0 0,alignx trailing");
        this.b = new FixedLengthTextField(60);
        this.getContentPane().add((Component)this.b, "cell 1 0,growx");
        JSeparator jSeparator = new JSeparator();
        this.getContentPane().add((Component)jSeparator, "cell 0 1 2 1,growx, gap top 50px");
        JPanel jPanel = new JPanel();
        this.getContentPane().add((Component)jPanel, "cell 0 4 2 1,grow");
        JButton jButton = new JButton(Messages.getString("VirtualPrinterConfigDialog.9"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VirtualPrinterConfigDialog.this.doAddPrinter();
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton(Messages.getString("VirtualPrinterConfigDialog.10"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VirtualPrinterConfigDialog.this.setCanceled(true);
                VirtualPrinterConfigDialog.this.dispose();
            }
        });
        jPanel.add(jButton2);
    }

    protected void doAddPrinter() {
        try {
            String string = this.b.getText();
            if (StringUtils.isEmpty((String)string)) {
                POSMessageDialog.showMessage(this, Messages.getString("VirtualPrinterConfigDialog.11"));
                return;
            }
            VirtualPrinterDAO virtualPrinterDAO = VirtualPrinterDAO.getInstance();
            if (virtualPrinterDAO.findPrinterByName(string) != null) {
                POSMessageDialog.showMessage(this, Messages.getString("VirtualPrinterConfigDialog.12"));
                return;
            }
            if (this.a == null) {
                this.a = new VirtualPrinter();
            }
            this.a.setName(string);
            virtualPrinterDAO.saveOrUpdate(this.a);
            this.setCanceled(false);
            this.dispose();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    public VirtualPrinter getPrinter() {
        return this.a;
    }

    public void setPrinter(VirtualPrinter virtualPrinter) {
        this.a = virtualPrinter;
        if (virtualPrinter != null) {
            this.b.setText(virtualPrinter.getName());
        }
    }
}

