/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.customer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.Customer;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.forms.CustomerForm;
import com.floreantpos.util.PosGuiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

public class CustomerExplorer
extends TransparentPanel {
    private JTable a;
    private BeanTableModel<Customer> b;
    private JButton c;
    private JButton d;
    private JLabel e;
    private JTextField f;

    public CustomerExplorer() {
        this.b();
        this.a();
    }

    private void a() {
        String string = this.f.getText();
        CustomerDAO.getInstance().findByPhoneOrName(string, this.b);
        int n = this.b.getCurrentRowIndex() + 1;
        int n2 = this.b.getNextRowIndex();
        int n3 = this.b.getNumRows();
        if (n2 > n3) {
            n2 = n3;
        }
        this.e.setText(String.format(Messages.getString("CustomerExplorer.0"), n, n2, n3));
        this.c.setEnabled(this.b.hasPrevious());
        this.d.setEnabled(this.b.hasNext());
    }

    private void b() {
        this.b = new BeanTableModel(Customer.class, 50);
        this.b.addColumn(Messages.getString("CustomerExplorer.1"), "name");
        this.b.addColumn(Messages.getString("CustomerExplorer.3"), "mobileNo");
        this.b.addColumn(Messages.getString("CustomerExplorer.5"), "email");
        this.b.addColumn(Messages.getString("CustomerExplorer.7"), "address");
        this.b.addColumn(Messages.getString("CustomerExplorer.9"), "city");
        this.b.addColumn(Messages.getString("CustomerExplorer.11"), "country");
        this.b.addColumn(Messages.getString("CustomerExplorer.13"), "balance");
        this.b.addColumn(Messages.getString("CustomerExplorer.15"), "creditLimit");
        this.b.addColumn(Messages.getString("CustomerExplorer.17"), "loyaltyNo");
        this.b.addColumn(Messages.getString("CustomerExplorer.19"), "vip");
        this.b.addColumn(Messages.getString("CustomerExplorer.21"), "taxExempt");
        this.a = new JTable(this.b);
        this.a.setRowHeight(PosUIManager.getSize(30));
        this.a.setDefaultRenderer(Object.class, new PosTableRenderer());
        PosGuiUtil.setColumnWidth(this.a, 0, 150);
        PosGuiUtil.setColumnWidth(this.a, 1, 150);
        PosGuiUtil.setColumnWidth(this.a, 2, 120);
        PosGuiUtil.setColumnWidth(this.a, 3, 150);
        PosGuiUtil.setColumnWidth(this.a, 4, 100);
        PosGuiUtil.setColumnWidth(this.a, 5, 100);
        PosGuiUtil.setColumnWidth(this.a, 6, 35);
        PosGuiUtil.setColumnWidth(this.a, 7, 55);
        PosGuiUtil.setColumnWidth(this.a, 8, 30);
        PosGuiUtil.setColumnWidth(this.a, 9, 20);
        PosGuiUtil.setColumnWidth(this.a, 10, 50);
        this.setLayout(new BorderLayout(5, 0));
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx, ins 10"));
        JLabel jLabel = new JLabel(Messages.getString("CustomerExplorer.24"));
        this.f = new JTextField(20);
        this.f.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomerExplorer.this.a();
            }
        });
        JButton jButton = new JButton(Messages.getString("CustomerExplorer.25"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomerExplorer.this.a();
            }
        });
        JButton jButton2 = new JButton(Messages.getString("CustomerExplorer.26"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomerExplorer.this.f.setText("");
                CustomerExplorer.this.a();
            }
        });
        jPanel.add((Component)jLabel, "split 4");
        jPanel.add((Component)this.f, "");
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.add((Component)jPanel, "North");
        this.add((Component)new JScrollPane(this.a), "Center");
        JButton jButton3 = new JButton(POSConstants.ADD);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomerExplorer.this.c();
            }
        });
        JButton jButton4 = new JButton(POSConstants.EDIT);
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomerExplorer.this.d();
            }
        });
        JButton jButton5 = new JButton(POSConstants.DELETE);
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomerExplorer.this.e();
            }
        });
        this.c = new JButton(Messages.getString("CustomerExplorer.30"));
        this.d = new JButton(Messages.getString("CustomerExplorer.31"));
        this.e = new JLabel();
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomerExplorer.this.b.setCurrentRowIndex(CustomerExplorer.this.b.getPreviousRowIndex());
                CustomerExplorer.this.a();
            }
        });
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomerExplorer.this.b.setCurrentRowIndex(CustomerExplorer.this.b.getNextRowIndex());
                CustomerExplorer.this.a();
            }
        });
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new MigLayout("fillx"));
        transparentPanel.add((Component)jButton3, "right, split 3");
        transparentPanel.add(jButton4);
        transparentPanel.add(jButton5);
        transparentPanel.add((Component)this.e, "right, split 3");
        transparentPanel.add(this.c);
        transparentPanel.add(this.d);
        this.add((Component)transparentPanel, "South");
    }

    private void c() {
        try {
            boolean bl = true;
            CustomerForm customerForm = new CustomerForm(bl);
            customerForm.enableCustomerFields(true);
            Window window = SwingUtilities.getWindowAncestor(this);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog(window, (BeanEditor)customerForm);
            beanEditorDialog.setPreferredSize(PosUIManager.getSize(960, 700));
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            Customer customer = (Customer)customerForm.getBean();
            this.b.addRow(customer);
            this.a();
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void d() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                return;
            }
            Customer customer = this.b.getRow(n);
            boolean bl = true;
            CustomerForm customerForm = new CustomerForm(bl);
            customerForm.enableCustomerFields(true);
            customerForm.setBean(customer);
            Window window = SwingUtilities.getWindowAncestor(this);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog(window, (BeanEditor)customerForm);
            beanEditorDialog.setPreferredSize(PosUIManager.getSize(960, 700));
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            this.a.repaint();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void e() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                return;
            }
            if (ConfirmDeleteDialog.showMessage(this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                Customer customer = this.b.getRow(n);
                CustomerDAO customerDAO = new CustomerDAO();
                customerDAO.delete(customer);
                this.b.removeRow(customer);
                this.a();
            }
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }
}

