/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.extension.cronjob;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.mailservices.MailService;
import com.floreantpos.model.CronJob;
import com.floreantpos.model.dao.CronJobDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.service.SalesReportService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.mail.util.ByteArrayDataSource;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class EmailSalesReportJob
extends CronJob {
    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        Date date;
        PosLog.info(this.getClass(), Messages.getString("EmailSalesReportJob.0"));
        Date date2 = date = new Date();
        Date date3 = DateUtil.startOfDay(date);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("dd MMM yyyy HH:mm");
        try {
            CronJob cronJob = CronJobDAO.getInstance().get(jobExecutionContext.getJobDetail().getKey().getName());
            Map map = (Map)new ObjectMapper().readValue(cronJob.getProperties(), (TypeReference)new TypeReference<Map<String, String>>(){});
            String string = (String)map.get(Messages.getString("EmailSalesReportJob.3"));
            String string2 = Messages.getString("EmailSalesReportJob.4") + date;
            String string3 = Messages.getString("EmailSalesReportJob.5") + simpleDateFormat2.format(date3) + Messages.getString("EmailSalesReportJob.6") + simpleDateFormat2.format(date2) + Messages.getString("EmailSalesReportJob.7");
            String string4 = "sales_report_" + simpleDateFormat.format(date3) + "_" + simpleDateFormat.format(date2) + ".pdf";
            if (MailService.sendMail(string, string2, string3, string4, new ByteArrayDataSource(JasperExportManager.exportReportToPdf((JasperPrint)new SalesReportService(date3, date2, null, null, true, false, true).createJasperPrint()), "application/pdf"))) {
                PosLog.info(this.getClass(), "Successfully send email to " + string + " ...");
            } else {
                PosLog.error(this.getClass(), "Unable to send email to " + string + " ...");
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), "Runtime error occured in sending email...", exception);
        }
    }
}

