/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseCustomer;
import com.floreantpos.model.dao.CustomerGroupDAO;
import com.floreantpos.util.AESencrp;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"deliveryAddresses", "deliveryInstructions"})
@XmlRootElement
public class Customer
extends BaseCustomer
implements TimedModel {
    private static final long serialVersionUID = 1L;
    public static final String APPETIZER_PREF = "appetizerPref";
    public static final String BILLINGSTATEMENT_PREF = "billingStatementPref";
    public static final String COCKTAIL_PREF = "cocktailPref";
    public static final String DESSERT_PREF = "dessertPref";
    public static final String ENTREE_PREF = "entreePref";
    public static final String GOLFBALL_PREF = "golfBallPref";
    public static final String MEAL_PREF = "mealPref";
    public static final String PAYMENT_PREF = "paymentPref";
    public static final String PILLOW_PREF = "pillowPref";
    public static final String ROLLAWAYCRIB_PREF = "rollawayCribPref";
    public static final String SEATING_PREF = "seatingPref";
    public static final String SMOKING_PREF = "smokingPref";
    public static final String WINE_PREF = "winePref";
    public static final String ROOM_ACCESS_PREF = "roomAccessPref";
    public static final String ROOM_LOC_PREF = "roomLocPref";
    public static final String ROOM_NUMBER_PREF = "roomNumberPref";
    public static final String REMAINING_CURRENT_QUARTER = "club62__Remaining_Current_Quarter_F_B_Spends__c";
    public static final String STATUS = "club62__Status__c";
    public static final String STREET_1 = "street_1";
    public static final String STREET_2 = "street_2";
    public static final String STREET_3 = "street_3";
    private Boolean selected;
    private transient JsonObject propertiesContainer;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    public Customer() {
    }

    public Customer(String string) {
        super(string);
    }

    @Override
    public String toString() {
        String string = this.getName();
        return string;
    }

    public ImageIcon getImage() {
        return null;
    }

    @Override
    public String getName() {
        String string = super.getFirstName();
        if (StringUtils.isNotEmpty((String)super.getLastName())) {
            string = string + " " + super.getLastName();
        }
        return string;
    }

    @Override
    public void setMobileNo(String string) {
        if (StringUtils.isNotEmpty((String)string)) {
            string = string.replaceAll("(\\+)?\\D", "$1");
        }
        super.setMobileNo(string);
    }

    @Override
    public void setWorkPhoneNo(String string) {
        if (StringUtils.isNotEmpty((String)string)) {
            string = string.replaceAll("(\\+)?\\D", "$1");
        }
        super.setWorkPhoneNo(string);
    }

    @Override
    public void setHomePhoneNo(String string) {
        if (StringUtils.isNotEmpty((String)string)) {
            string = string.replaceAll("(\\+)?\\D", "$1");
        }
        super.setHomePhoneNo(string);
    }

    public Boolean isSelected() {
        return this.selected == null ? Boolean.FALSE : this.selected;
    }

    public void setSelected(Boolean bl) {
        this.selected = bl;
    }

    public CustomerGroup getCustomerGroup() {
        if (StringUtils.isNotEmpty((String)this.getCustomerGroupId())) {
            return CustomerGroupDAO.getInstance().get(this.getCustomerGroupId());
        }
        return null;
    }

    public void setCustomerGroup(CustomerGroup customerGroup) {
        String string = null;
        if (customerGroup != null) {
            string = customerGroup.getId();
        }
        super.setCustomerGroupId(string);
    }

    public void setEncryptedSecretCode(String string) {
        try {
            this.setSecretCode(AESencrp.encrypt(string));
        }
        catch (Exception exception) {
            this.setSecretCode(string);
        }
    }

    public String getUnencryptedSecretCode() {
        String string = this.getSecretCode();
        if (StringUtils.isNotEmpty((String)string)) {
            try {
                string = AESencrp.decrypt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String string = super.getProperties();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
        return string;
    }

    @Override
    public void setProperties(String string) {
        super.setProperties(string);
        if (StringUtils.isNotEmpty((String)string)) {
            this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
        }
    }

    public void addProperty(String string, String string2) {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        if (StringUtils.isNotEmpty((String)string2)) {
            this.propertiesContainer.addProperty(string, string2);
        }
    }

    public String getProperty(String string) {
        if (this.propertiesContainer == null) {
            return null;
        }
        if (this.propertiesContainer.has(string)) {
            return this.propertiesContainer.get(string).getAsString();
        }
        return null;
    }

    public boolean hasProperty(String string) {
        return this.getProperty(string) != null;
    }

    public boolean isPropertyValueTrue(String string) {
        String string2 = this.getProperty(string);
        return POSUtil.getBoolean(string2);
    }

    public void removeProperty(String string) {
        if (this.propertiesContainer != null) {
            this.propertiesContainer.remove(string);
        }
    }

    public static enum MemberType {
        MEMBER(0, "Member"),
        GUEST(1, "Guest"),
        EMPLOYEE(2, "Employee"),
        STORE_OWNER(3, "StoreOwner");

        private int typeInt;
        private String name;

        private MemberType(int n2, String string2) {
            this.typeInt = n2;
            this.name = string2;
        }

        public int getTypeInt() {
            return this.typeInt;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static MemberType fromInt(int n) {
            MemberType[] memberTypeArray;
            for (MemberType memberType : memberTypeArray = MemberType.values()) {
                if (memberType.getTypeInt() != n) continue;
                return memberType;
            }
            return MEMBER;
        }
    }
}

