/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BaseInventoryTransaction;
import com.floreantpos.model.dao.InventoryVendorDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.NumberUtil;
import java.text.SimpleDateFormat;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class InventoryTransaction
extends BaseInventoryTransaction
implements TimedModel {
    private static final long serialVersionUID = 1L;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    public static final String PROPERTY_VENDOR = "vendor";
    public static final String PROPERTY_FROM_LOC = "fromInventoryLocation";
    public static final String PROPERTY_TO_LOC = "toInventoryLocation";
    public static final String REASON_NEW_STOCK = "NEW STOCK";
    public static final String REASON_RETURN = "RETURN";
    public static final String REASON_PURCHASE = "PURCHASE";
    public static final String REASON_DAMAGED = "DAMAGED";
    public static final String REASON_TICKET_SALES = "TICKET SALES";
    public static final String REASON_TRANSFER = "TRANSFER";
    public static final String REASON_UNIT_CONVERSION = "UNIT. CONV.";
    public static final String REASON_ADJUST = "ADJUST";
    public static final String REASON_ADJUST_IN = "ADJUST_IN";
    public static final String REASON_ADJUST_OUT = "ADJUST_OUT";
    public static final String REASON_PREPARE_IN = "PREPARE IN";
    public static final String REASON_PREPARE_OUT = "PREPARE OUT";
    public static final String REASON_VOID = "VOID";
    public static final String VENDOR_RETURN = "VENDOR RETURN";
    public static final String[] REASON_IN = new String[]{"NEW STOCK", "RETURN", "PURCHASE", "ADJUST_IN", "PREPARE IN"};
    public static final String[] REASON_OUT = new String[]{"TICKET SALES", "DAMAGED", "ADJUST_OUT", "PREPARE OUT", "VENDOR RETURN"};
    public static final String[] REASON_TRANS = new String[]{"TRANSFER"};
    public static InventoryTransactionType transactionType;
    private static final SimpleDateFormat dateFormat;
    private double openingQty;
    private double openingCost;
    private double openingTotalCost;
    private transient InventoryLocation inventoryToLocation;
    private transient InventoryLocation inventoryFromLocation;

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    public InventoryTransaction() {
    }

    public InventoryTransaction(String string) {
        super(string);
    }

    public InventoryTransactionType getTransactionType() {
        transactionType = InventoryTransactionType.fromInt(super.getType());
        return transactionType;
    }

    public void setTransactionType(InventoryTransactionType inventoryTransactionType) {
        super.setType(inventoryTransactionType.getType());
    }

    public String getTransactionDateAsString() {
        if (super.getTransactionDate() == null) {
            return "";
        }
        return dateFormat.format(super.getTransactionDate());
    }

    public void setTransactionDateAsString(String string) {
    }

    public double getOpeningQty() {
        return this.openingQty;
    }

    public void setOpeningQty(double d) {
        this.openingQty = d;
    }

    public double getOpeningCost() {
        return this.openingCost;
    }

    public void setOpeningCost(double d) {
        this.openingCost = d;
    }

    public double getOpeningTotalCost() {
        return this.openingTotalCost;
    }

    public void setOpeningTotalCost(double d) {
        this.openingTotalCost = d;
    }

    public void setUnitCostDisplay(String string) {
    }

    public String getUnitCostDisplay() {
        return NumberUtil.getCurrencyFormat(this.getUnitCost());
    }

    public void setUnitPriceDisplay(String string) {
    }

    public String getUnitPriceDisplay() {
        return NumberUtil.getCurrencyFormat(this.getUnitPrice());
    }

    public String getSku() {
        return this.getMenuItem().getSku();
    }

    public void setSku(String string) {
    }

    public String getItemName() {
        return this.getMenuItem().getName();
    }

    public void setItemName(String string) {
    }

    @XmlTransient
    public void setToInventoryLocation(InventoryLocation inventoryLocation) {
        this.inventoryToLocation = inventoryLocation;
        this.setToLocationId(inventoryLocation == null ? null : inventoryLocation.getId());
    }

    public InventoryLocation getToInventoryLocation() {
        if (this.inventoryToLocation != null) {
            return this.inventoryToLocation;
        }
        return DataProvider.get().getInventoryLocationById(this.getToLocationId());
    }

    @XmlTransient
    public void setFromInventoryLocation(InventoryLocation inventoryLocation) {
        this.inventoryFromLocation = inventoryLocation;
        this.setFromLocationId(inventoryLocation == null ? null : inventoryLocation.getId());
    }

    public InventoryLocation getFromInventoryLocation() {
        if (this.inventoryFromLocation != null) {
            return this.inventoryFromLocation;
        }
        return DataProvider.get().getInventoryLocationById(this.getFromLocationId());
    }

    public void setUser(User user) {
        this.setUserId(user == null ? null : user.getId());
    }

    public void setVendor(InventoryVendor inventoryVendor) {
        this.setVendorId(inventoryVendor == null ? null : inventoryVendor.getId());
    }

    public InventoryVendor getVendor() {
        if (this.getVendorId() == null) {
            return null;
        }
        return InventoryVendorDAO.getInstance().get(this.getVendorId());
    }

    static {
        dateFormat = new SimpleDateFormat("MMM dd, hh:mm a");
    }
}

