/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.model.base.BaseKitchenTicketItem;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.util.NumberUtil;
import org.apache.commons.lang.StringUtils;

public class KitchenTicketItem
extends BaseKitchenTicketItem {
    private static final long serialVersionUID = 1L;
    private String voidedItemId;

    public KitchenTicketItem() {
    }

    public KitchenTicketItem(String string) {
        super(string);
    }

    public boolean isInformationOnly() {
        return this.isSeat() != false || this.isCookingInstruction() != false;
    }

    public KitchenStatus getKitchenStatusValue() {
        return KitchenStatus.fromString(super.getStatus());
    }

    public void setKitchenStatusValue(KitchenStatus kitchenStatus) {
        super.setStatus(kitchenStatus.name());
    }

    @Override
    public String getMenuItemGroupName() {
        if (super.getMenuItemGroupName() == null) {
            return "";
        }
        return super.getMenuItemGroupName();
    }

    public String getVoidedItemId() {
        return this.voidedItemId;
    }

    public void setVoidedItemId(String string) {
        this.voidedItemId = string;
    }

    public String getMenuItemNameDisplay() {
        if (this.isInformationOnly()) {
            return this.getMenuItemName();
        }
        if (this.isModifierItem().booleanValue()) {
            return "*" + this.getMenuItemName();
        }
        String string = "";
        if (StringUtils.isNotEmpty((String)this.getCourseName())) {
            string = "[" + this.getCourseName() + "] ";
        }
        String string2 = this.getMenuItemName();
        if (this.getQuantity() == 1.0) {
            string = string + NumberUtil.trimDecilamIfNotNeeded(this.getQuantity()) + "x ";
        }
        string = string + string2;
        return string;
    }
}

