/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.model.IdContainer;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.RecepieItem;
import com.floreantpos.model.RecipeTable;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseRecepie;
import com.floreantpos.model.dao.RecipeTableDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.NumberUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Recepie
extends BaseRecepie
implements IdContainer,
TimedModel {
    private static final long serialVersionUID = 1L;
    private Double cost;
    private Boolean visible;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private Double cookingYield;

    public Recepie() {
    }

    public Recepie(String string) {
        super(string);
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    public void addRecepieItem(RecepieItem recepieItem) {
        List<RecepieItem> list = this.getRecepieItems();
        if (list == null) {
            list = new ArrayList<RecepieItem>(3);
            this.setRecepieItems(list);
        }
        list.add(recepieItem);
    }

    @Override
    public String toString() {
        return super.getName();
    }

    public Double getCost() {
        return this.cost == null ? 0.0 : this.cost;
    }

    public void setCost(Double d) {
        this.cost = d;
    }

    public void calculateCost() {
        double d = 0.0;
        double d2 = 0.0;
        List<RecepieItem> list = this.getRecepieItems();
        if (list != null && list.size() > 0) {
            for (RecepieItem recepieItem : list) {
                recepieItem.calculatePercentage();
                d2 += recepieItem.getCost();
            }
        }
        d = d2 * this.getPortion() / this.getYield();
        this.setCost(d);
    }

    @Override
    public Double getPortion() {
        return super.getPortion() == 0.0 ? 1.0 : super.getPortion();
    }

    @Override
    public Double getYield() {
        return super.getYield() == 0.0 ? 1.0 : super.getYield();
    }

    public void setVisible(Boolean bl) {
        this.visible = bl;
    }

    public Boolean isVisible() {
        return this.visible == null ? false : this.visible;
    }

    public void populateRecipeItemQuantity(Double d, HashMap<String, Double> hashMap, double d2) {
        List<RecepieItem> list = this.getRecepieItems();
        if (list == null || list.size() == 0) {
            return;
        }
        for (RecepieItem recepieItem : list) {
            MenuItem menuItem = recepieItem.getInventoryItem();
            if (menuItem == null || !menuItem.isInventoryItem().booleanValue()) continue;
            Double d3 = hashMap.get(menuItem.getId());
            if (d3 == null) {
                d3 = 0.0;
            }
            Double d4 = recepieItem.getPercentage() / 100.0;
            Double d5 = d3 + d2 * d4 * d;
            hashMap.put(menuItem.getId(), d5);
        }
    }

    public Double getCookingYield() {
        return this.cookingYield == null ? 1.0 : this.cookingYield;
    }

    public void setCookingYield(Double d) {
        this.cookingYield = d;
    }

    public String getMenuItemName() {
        return DataProvider.get().getRecipeMenuItemName(this);
    }

    public void setMenuItemName(String string) {
    }

    public void populateRecipeItems(HashMap<String, RecepieItem> hashMap, double d, Recepie recepie, boolean bl) {
        List<RecepieItem> list = this.getRecepieItems();
        if (list == null || list.size() == 0) {
            return;
        }
        for (RecepieItem recepieItem : list) {
            MenuItem menuItem = recepieItem.getInventoryItem();
            if (menuItem == null) continue;
            Double d2 = 0.0;
            String string = menuItem.getId();
            if (!bl) {
                string = recepie.getId() + "-" + string;
            }
            RecepieItem recepieItem2 = hashMap.get(string);
            RecipeTable recipeTable = RecipeTableDAO.getInstance().findBy(string);
            if (recipeTable != null) continue;
            if (recepieItem2 == null) {
                recepieItem2 = new RecepieItem();
                recepieItem2.setRecepie(recepie);
                recepieItem2.setInventoryItem(recepieItem.getInventoryItem());
                recepieItem2.setUnit(recepieItem.getUnit());
                recepieItem2.setUnitCode(recepieItem.getUnitCode());
                if (!bl) {
                    hashMap.put(recepie.getId() + "-" + string, recepieItem2);
                } else {
                    hashMap.put(string, recepieItem2);
                }
            }
            recepieItem2.setGroupName(recepie.getName());
            recepieItem2.setGroupId(recepie.getId());
            d2 = recepieItem.getPercentage() / 100.0;
            Double d3 = NumberUtil.roundToTwoDigit(recepieItem2.getQuantity() + d * d2);
            recepieItem2.setQuantity(d3);
        }
    }

    public int getCookingMin() {
        int n = this.getCookingTime();
        int n2 = n / 3600;
        int n3 = n - n2 * 3600;
        int n4 = n3 / 60;
        return n4;
    }
}

