/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.IconFactory;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseShopFloor;
import java.awt.Color;
import java.awt.Dimension;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonIgnoreProperties(ignoreUnknown=true, value={"foregroundColor", "backgroundColor", "floorSize", "tables"})
public class ShopFloor
extends BaseShopFloor
implements TimedModel {
    private static final long serialVersionUID = 1L;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    @XmlTransient
    private Color foregroundColor;
    @XmlTransient
    private Color backgroundColor;

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    public ShopFloor() {
    }

    public ShopFloor(String string) {
        super(string);
    }

    @XmlTransient
    public ImageIcon getImage() {
        return IconFactory.getIconFromImageResource(this.getImageId());
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public boolean hasTableWithNumber(String string) {
        Set<ShopTable> set = this.getTables();
        if (set == null) {
            return false;
        }
        for (ShopTable shopTable : set) {
            if (!shopTable.getTableNumber().equals(string)) continue;
            return true;
        }
        return false;
    }

    @XmlTransient
    public Color getForegroundColor() {
        if (this.getForegroundColorCode() == null) {
            return null;
        }
        if (this.foregroundColor != null) {
            return this.foregroundColor;
        }
        this.foregroundColor = new Color(this.getForegroundColorCode());
        return this.foregroundColor;
    }

    public void setForegroundColor(Color color) {
        this.foregroundColor = color;
        if (color != null) {
            this.setForegroundColorCode(color.getRGB());
        }
    }

    @XmlTransient
    public Color getBackgroundColor() {
        if (this.getBackgroundColorCode() == null) {
            return null;
        }
        if (this.backgroundColor != null) {
            return this.backgroundColor;
        }
        this.backgroundColor = new Color(this.getBackgroundColorCode());
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
        if (color != null) {
            this.setBackgroundColorCode(color.getRGB());
        }
    }

    public Dimension getFloorSize() {
        Integer n = this.getHeight();
        Integer n2 = this.getWidth();
        if (n2 <= 0) {
            n2 = 850;
        }
        if (n <= 0) {
            n = 500;
        }
        return new Dimension(n2, n);
    }
}

