/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import java.awt.Color;

public enum TableStatus {
    Serving(1, Color.RED, Color.WHITE),
    Booked(2, Color.YELLOW, Color.WHITE, false),
    Dirty(3),
    Disable(4),
    Available(5),
    Seat(6, Color.ORANGE, Color.WHITE);

    private final int value;
    private Color bgColor;
    private Color textColor;
    private Boolean enabled;

    private TableStatus(int n2) {
        this.value = n2;
    }

    private TableStatus(int n2, Color color, Color color2) {
        this.value = n2;
        this.bgColor = color;
        this.textColor = color2;
    }

    private TableStatus(int n2, Color color, Color color2, Boolean bl) {
        this.value = n2;
        this.bgColor = color;
        this.textColor = color2;
        this.enabled = bl;
    }

    public int getValue() {
        return this.value;
    }

    public static TableStatus get(int n) {
        switch (n) {
            case 1: {
                return Serving;
            }
            case 2: {
                return Booked;
            }
            case 3: {
                return Dirty;
            }
            case 4: {
                return Disable;
            }
            case 5: {
                return Available;
            }
            case 6: {
                return Seat;
            }
        }
        return null;
    }

    public String toString() {
        return this.name();
    }

    public Color getBgColor() {
        return this.bgColor == null ? Color.WHITE : this.bgColor;
    }

    public Color getTextColor() {
        return this.textColor == null ? Color.BLACK : this.textColor;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }
}

