/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.Department;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.dao.BaseDepartmentDAO;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;

public class DepartmentDAO
extends BaseDepartmentDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Department initialize(Department department) {
        if (department == null || department.getId() == null) {
            return department;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)department);
            Hibernate.initialize(department.getOutlets());
            Department department2 = department;
            return department2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Department> findByOrderType(OrderType orderType) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.getSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.createAlias("orderTypes", "o");
            criteria.add((Criterion)Restrictions.eq((String)"o.id", (Object)orderType.getId()));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsDepartment(OrderType orderType) {
        Session session = null;
        Criteria criteria = null;
        try {
            Number number;
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            if (orderType != null) {
                criteria.createAlias("orderTypes", "o");
                criteria.add((Criterion)Restrictions.eq((String)"o.id", (Object)orderType.getId()));
            }
            boolean bl = (number = (Number)criteria.uniqueResult()) != null && number.intValue() > 0;
            return bl;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Department> findDepartmentbyOutlet(Outlet outlet) {
        try (Session session = null;){
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            List list = criteria.list();
            if (list == null || list.size() == 0) {
                List<Department> list2 = null;
                return list2;
            }
            List list3 = list;
            return list3;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Department findById(String string) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Department.PROP_ID, (Object)string));
            Department department = (Department)criteria.uniqueResult();
            return department;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Department> findAllUnSyncDepartment() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            SimpleExpression simpleExpression = Restrictions.eq((String)Department.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE);
            Criterion criterion = Restrictions.isNull((String)Department.PROP_CLOUD_SYNCED);
            criteria.add((Criterion)Restrictions.or((Criterion)simpleExpression, (Criterion)criterion));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void saveOrUpdateDepartments(List<Department> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (Department department : list) {
                Department department2 = this.get(department.getId());
                if (department2 != null) {
                    String string = department2.getId();
                    long l = department2.getVersion();
                    PropertyUtils.copyProperties((Object)department2, (Object)department);
                    department2.setId(string);
                    department2.setVersion(l);
                    department2.setUpdateLastUpdateTime(bl);
                    department2.setUpdateSyncTime(bl2);
                    this.update(department2, session);
                    continue;
                }
                department.setVersion(0L);
                department.setUpdateLastUpdateTime(bl);
                department.setUpdateSyncTime(bl2);
                this.save(department, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

