/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.dao.BaseInventoryLocationDAO;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class InventoryLocationDAO
extends BaseInventoryLocationDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryLocation initialize(InventoryLocation inventoryLocation) {
        if (inventoryLocation == null || inventoryLocation.getId() == null) {
            return inventoryLocation;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)inventoryLocation);
            Hibernate.initialize(InventoryLocation.class);
            InventoryLocation inventoryLocation2 = inventoryLocation;
            return inventoryLocation2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryLocation getRootLocation() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)InventoryLocation.PROP_ROOT, (Object)true));
            List list = criteria.list();
            if (list != null && list.size() > 0) {
                InventoryLocation inventoryLocation = (InventoryLocation)list.get(0);
                return inventoryLocation;
            }
            InventoryLocation inventoryLocation = null;
            return inventoryLocation;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InventoryLocation> getRootLocations() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)InventoryLocation.PROP_ROOT, (Object)true));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryLocation getDefaultInInventoryLocation() {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.getSession();
            criteria = session.createCriteria(InventoryLocation.class);
            criteria.add((Criterion)Restrictions.eq((String)InventoryLocation.PROP_DEFAULT_IN_LOCATION, (Object)true));
            List list = criteria.list();
            if (list == null || list.isEmpty()) {
                InventoryLocation inventoryLocation = null;
                return inventoryLocation;
            }
            InventoryLocation inventoryLocation = (InventoryLocation)list.get(0);
            return inventoryLocation;
        }
        catch (Exception exception) {
            PosLog.info(this.getClass(), "" + exception);
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryLocation getDefaultOutInventoryLocation() {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.getSession();
            criteria = session.createCriteria(InventoryLocation.class);
            criteria.add((Criterion)Restrictions.eq((String)InventoryLocation.PROP_DEFAULT_OUT_LOCATION, (Object)true));
            List list = criteria.list();
            if (list == null || list.isEmpty()) {
                InventoryLocation inventoryLocation = null;
                return inventoryLocation;
            }
            InventoryLocation inventoryLocation = (InventoryLocation)list.get(0);
            return inventoryLocation;
        }
        catch (Exception exception) {
            PosLog.info(this.getClass(), "" + exception);
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    public InventoryLocation getDefaultOutInventoryLocation(Session session) {
        Criteria criteria = session.createCriteria(InventoryLocation.class);
        criteria.add((Criterion)Restrictions.eq((String)InventoryLocation.PROP_DEFAULT_OUT_LOCATION, (Object)true));
        List list = criteria.list();
        if (list == null || list.isEmpty()) {
            criteria = session.createCriteria(InventoryLocation.class);
            criteria.setMaxResults(1);
            return (InventoryLocation)criteria.uniqueResult();
        }
        return (InventoryLocation)list.get(0);
    }

    public InventoryLocation getDefaultInInventoryLocation(Session session) {
        Criteria criteria = session.createCriteria(InventoryLocation.class);
        criteria.add((Criterion)Restrictions.eq((String)InventoryLocation.PROP_DEFAULT_IN_LOCATION, (Object)true));
        List list = criteria.list();
        if (list == null || list.isEmpty()) {
            criteria = session.createCriteria(InventoryLocation.class);
            criteria.setMaxResults(1);
            return (InventoryLocation)criteria.uniqueResult();
        }
        return (InventoryLocation)list.get(0);
    }

    public void saveOrUpdateInventoryLocation(List<InventoryLocation> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (InventoryLocation inventoryLocation : list) {
                InventoryLocation inventoryLocation2 = this.get(inventoryLocation.getId());
                if (inventoryLocation2 != null) {
                    long l = inventoryLocation2.getVersion();
                    PropertyUtils.copyProperties((Object)inventoryLocation2, (Object)inventoryLocation);
                    inventoryLocation2.setVersion(l);
                    inventoryLocation2.setUpdateLastUpdateTime(bl);
                    inventoryLocation2.setUpdateSyncTime(bl2);
                    this.update(inventoryLocation2, session);
                    continue;
                }
                inventoryLocation.setUpdateLastUpdateTime(bl);
                inventoryLocation.setUpdateSyncTime(bl2);
                this.save(inventoryLocation, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

