/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.Department;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuShift;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.dao.BaseMenuCategoryDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PaginationSupport;
import com.floreantpos.util.ShiftUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.sql.JoinType;
import org.hibernate.transform.Transformers;

public class MenuCategoryDAO
extends BaseMenuCategoryDAO {
    @Override
    public Order getDefaultOrder() {
        return Order.asc((String)MenuCategory.PROP_SORT_ORDER);
    }

    @Override
    public Serializable save(Object object, Session session) throws HibernateException {
        this.updateTime(object);
        Serializable serializable = super.save(object, session);
        this.updateDependentModels((MenuCategory)object, session);
        return serializable;
    }

    @Override
    public void update(Object object, Session session) throws HibernateException {
        this.updateTime(object);
        super.update(object, session);
        this.updateDependentModels((MenuCategory)object, session);
    }

    @Override
    public void saveOrUpdate(Object object, Session session) throws HibernateException {
        this.updateTime(object);
        session.saveOrUpdate(object);
        this.updateDependentModels((MenuCategory)object, session);
    }

    private void updateDependentModels(MenuCategory menuCategory, Session session) {
        String string = "update MenuGroup set %s=:categoryName, %s=:beverage where %s=:categoryId";
        string = String.format(string, MenuGroup.PROP_MENU_CATEGORY_NAME, MenuGroup.PROP_BEVERAGE, MenuGroup.PROP_MENU_CATEGORY_ID);
        Query query = session.createQuery(string);
        query.setParameter("categoryName", (Object)menuCategory.getDisplayName());
        query.setParameter("beverage", (Object)menuCategory.isBeverage());
        query.setParameter("categoryId", (Object)menuCategory.getId());
        query.executeUpdate();
        string = "update MenuItem set %s=:categoryName, %s=:beverage where %s=:categoryId";
        string = String.format(string, MenuItem.PROP_MENU_CATEGORY_NAME, MenuItem.PROP_BEVERAGE, MenuItem.PROP_MENU_CATEGORY_ID);
        query = session.createQuery(string);
        query.setParameter("categoryName", (Object)menuCategory.getDisplayName());
        query.setParameter("beverage", (Object)menuCategory.isBeverage());
        query.setParameter("categoryId", (Object)menuCategory.getId());
        query.executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuCategory> findAllEnable(Department department) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass(), "category");
            criteria.add((Criterion)Restrictions.eq((String)MenuCategory.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.addOrder(Order.asc((String)MenuCategory.PROP_SORT_ORDER));
            if (department != null) {
                criteria.createAlias("category.departments", "department");
                criteria.add((Criterion)Restrictions.eq((String)"department.id", (Object)department.getId()));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuCategory> findActiveCategories(OrderType orderType) {
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        Department department = terminal.getDepartment();
        List<MenuShift> list = ShiftUtil.getCurrentMenuShifts();
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = this.setRestrictions(orderType, terminal, department, list, session);
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)MenuCategory.PROP_SORT_ORDER));
            criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            List list2 = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findActiveCategories(PaginatedListModel paginatedListModel, OrderType orderType) {
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        Department department = terminal.getDepartment();
        List<MenuShift> list = ShiftUtil.getCurrentMenuShifts();
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = this.setRestrictions(orderType, terminal, department, list, session);
            criteria.setProjection((Projection)Projections.countDistinct((String)MenuCategory.PROP_ID));
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                paginatedListModel.setNumRows(number.intValue());
            }
            criteria.setProjection(null);
            criteria.setFirstResult(paginatedListModel.getCurrentRowIndex());
            criteria.setMaxResults(paginatedListModel.getPageSize());
            criteria.addOrder(Order.asc((String)MenuCategory.PROP_SORT_ORDER));
            criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            paginatedListModel.setData(criteria.list());
        }
        finally {
            this.closeSession(session);
        }
    }

    private Criteria setRestrictions(OrderType orderType, Terminal terminal, Department department, List<MenuShift> list, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass(), "c");
        if (orderType != null) {
            criteria.createAlias("c.orderTypes", "orderType", JoinType.LEFT_OUTER_JOIN);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isEmpty((String)"c.orderTypes"), (Criterion)Restrictions.in((String)"orderType.id", Arrays.asList(orderType.getId()))));
        }
        if (terminal.getTerminalType() != null) {
            criteria.createAlias("c.terminalTypes", "terminalType", JoinType.LEFT_OUTER_JOIN);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isEmpty((String)"c.terminalTypes"), (Criterion)Restrictions.in((String)"terminalType.id", Arrays.asList(terminal.getTerminalType().getId()))));
        }
        if (department != null) {
            criteria.createAlias("c.departments", "department", JoinType.LEFT_OUTER_JOIN);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isEmpty((String)"c.departments"), (Criterion)Restrictions.in((String)"department.id", Arrays.asList(department.getId()))));
        }
        if (list != null) {
            criteria.createAlias("c.menuShifts", "menuShifts", JoinType.LEFT_OUTER_JOIN);
            if (list.size() > 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (MenuShift menuShift : list) {
                    arrayList.add(menuShift.getId());
                }
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isEmpty((String)"c.menuShifts"), (Criterion)Restrictions.in((String)"menuShifts.id", arrayList)));
            } else {
                criteria.add(Restrictions.isEmpty((String)"c.menuShifts"));
            }
        }
        criteria.add((Criterion)Restrictions.eq((String)MenuCategory.PROP_VISIBLE, (Object)Boolean.TRUE));
        return criteria;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuCategory initialize(MenuCategory menuCategory) {
        if (menuCategory == null || menuCategory.getId() == null) {
            return menuCategory;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)menuCategory);
            Hibernate.initialize(menuCategory.getDepartments());
            Hibernate.initialize(menuCategory.getOrderTypes());
            Hibernate.initialize(menuCategory.getMenuShifts());
            Hibernate.initialize(menuCategory.getMenuGroups());
            MenuCategory menuCategory2 = menuCategory;
            return menuCategory2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void performBatchSaveOrUpdate(MenuCategory menuCategory, List<TerminalType> list) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            this.saveOrUpdate((Object)menuCategory, session);
            transaction.commit();
        }
        catch (Exception exception) {
            try {
                transaction.rollback();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void releaseParentAndDelete(MenuCategory menuCategory) {
        if (menuCategory == null) {
            return;
        }
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            String string = "delete from MENUCATEGORY_DISCOUNT where MENUCATEGORY_ID='%s'";
            string = String.format(string, menuCategory.getId());
            SQLQuery sQLQuery = session.createSQLQuery(string);
            sQLQuery.executeUpdate();
            String string2 = "delete from CAT_DEPT where CATEGORY_ID='%s'";
            string2 = String.format(string2, menuCategory.getId());
            SQLQuery sQLQuery2 = session.createSQLQuery(string2);
            sQLQuery2.executeUpdate();
            String string3 = "delete from CATEGORY_ORDER_TYPE where CATEGORY_ID='%s'";
            string3 = String.format(string3, menuCategory.getId());
            SQLQuery sQLQuery3 = session.createSQLQuery(string3);
            sQLQuery3.executeUpdate();
            String string4 = "delete from TERMINAL_TYPE_CATEGORY where MENU_CATEGORY_ID='%s'";
            string4 = String.format(string4, menuCategory.getId());
            SQLQuery sQLQuery4 = session.createSQLQuery(string4);
            sQLQuery4.executeUpdate();
            String string5 = "update MENU_GROUP set CATEGORY_ID=null where CATEGORY_ID='%s'";
            string5 = String.format(string5, menuCategory.getId());
            SQLQuery sQLQuery5 = session.createSQLQuery(string5);
            sQLQuery5.executeUpdate();
            session.delete((Object)menuCategory);
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)exception);
            throw new RuntimeException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findCategories(PaginationSupport paginationSupport, boolean bl, String ... stringArray) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass(), "c");
            if (!bl) {
                criteria.add((Criterion)Restrictions.eq((String)MenuCategory.PROP_VISIBLE, (Object)Boolean.TRUE));
            }
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                paginationSupport.setNumRows(number.intValue());
            }
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)MenuCategory.PROP_SORT_ORDER));
            if (stringArray != null && stringArray.length > 0) {
                ProjectionList projectionList = Projections.projectionList();
                for (String string : stringArray) {
                    projectionList.add((Projection)Projections.property((String)string), string);
                }
                criteria.setProjection((Projection)projectionList);
                criteria.setResultTransformer(Transformers.aliasToBean(MenuCategory.class));
                paginationSupport.setRows(criteria.list());
            } else {
                paginationSupport.setRows(criteria.list());
            }
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuCategory findCategoriesByName(String string) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuCategory.PROP_NAME, (Object)string));
            criteria.addOrder(Order.asc((String)MenuCategory.PROP_SORT_ORDER));
            List list = criteria.list();
            if (list != null && !list.isEmpty()) {
                MenuCategory menuCategory = (MenuCategory)list.get(0);
                return menuCategory;
            }
            MenuCategory menuCategory = null;
            return menuCategory;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuCategory> findAllUnSyncMenuCategory() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            SimpleExpression simpleExpression = Restrictions.eq((String)MenuCategory.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE);
            Criterion criterion = Restrictions.isNull((String)MenuCategory.PROP_CLOUD_SYNCED);
            criteria.add((Criterion)Restrictions.or((Criterion)simpleExpression, (Criterion)criterion));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void saveOrUpdateMenuCategorys(List<MenuCategory> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (MenuCategory menuCategory : list) {
                MenuCategory menuCategory2 = this.get(menuCategory.getId());
                if (menuCategory2 != null) {
                    long l = menuCategory2.getVersion();
                    PropertyUtils.copyProperties((Object)menuCategory2, (Object)menuCategory);
                    menuCategory2.setVersion(l);
                    menuCategory2.setUpdateLastUpdateTime(bl);
                    menuCategory2.setUpdateSyncTime(bl2);
                    this.update(menuCategory2, session);
                    continue;
                }
                menuCategory.setUpdateLastUpdateTime(bl);
                menuCategory.setUpdateSyncTime(bl2);
                this.save(menuCategory, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findCategoriesByName(PaginationSupport paginationSupport, String string) {
        Session session = null;
        try {
            Number number;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuCategory.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            if ((number = (Number)criteria.uniqueResult()) != null) {
                paginationSupport.setNumRows(number.intValue());
            }
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)MenuCategory.PROP_SORT_ORDER));
            paginationSupport.setRows(criteria.list());
        }
        finally {
            this.closeSession(session);
        }
    }
}

