/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Pagination;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.ReversalTransaction;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.BasePosTransactionDAO;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.HibernateProjectionsUtil;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.model.util.TransactionSummary;
import com.floreantpos.report.CustomerPaymentReportView;
import com.floreantpos.services.PosTransactionService;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.StoreUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;

public class PosTransactionDAO
extends BasePosTransactionDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        StoreSession storeSession;
        PosTransaction posTransaction = (PosTransaction)object;
        if (StringUtils.isEmpty((String)posTransaction.getStoreSessionId()) && (storeSession = DataProvider.get().getStoreSession()) != null) {
            posTransaction.setStoreSessionId(storeSession.getId());
        }
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        PosTransaction posTransaction = (PosTransaction)object;
        if (StringUtils.isEmpty((String)posTransaction.getStoreSessionId())) {
            posTransaction.setStoreSessionId(DataProvider.get().getStoreSession().getId());
        }
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        PosTransaction posTransaction = (PosTransaction)object;
        if (StringUtils.isEmpty((String)posTransaction.getStoreSessionId())) {
            posTransaction.setStoreSessionId(DataProvider.get().getStoreSession().getId());
        }
        super.saveOrUpdate(object, session);
    }

    public List<PosTransaction> findUnauthorizedTransactions() {
        return this.findUnauthorizedTransactions(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PosTransaction> findUnauthorizedTransactions(User user) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CAPTURED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)PosTransaction.PROP_MARKED_CAPTURED), (Criterion)Restrictions.eq((String)PosTransaction.PROP_MARKED_CAPTURED, (Object)Boolean.FALSE)));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_AUTHORIZABLE, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)PosTransaction.PROP_VOIDED), (Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE)));
            criteria.add(Restrictions.isNotNull((String)PosTransaction.PROP_TICKET));
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)user.getId()));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean hasUnauthorizedTransactions(User user) {
        Session session = null;
        try {
            Number number;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CAPTURED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_AUTHORIZABLE, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
            criteria.add(Restrictions.isNotNull((String)PosTransaction.PROP_TICKET));
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)user.getId()));
            }
            Boolean bl = (number = (Number)criteria.uniqueResult()) != null && number.intValue() > 0;
            return bl;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<? extends PosTransaction> findTransactions(Terminal terminal, Class clazz, Date date, Date date2) {
        return this.findTransactions(terminal, clazz, date, date2, true);
    }

    public List<? extends PosTransaction> findTransactions(Terminal terminal, Class clazz, Date date, Date date2, boolean bl) {
        return this.findTransactions(terminal, null, clazz, date, date2, bl);
    }

    public List<? extends PosTransaction> findTransactions(Terminal terminal, Outlet outlet, Class clazz, Date date, Date date2, boolean bl) {
        return this.findTransactions(terminal, outlet, clazz, date, date2, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<? extends PosTransaction> findTransactions(Terminal terminal, Outlet outlet, Class clazz, Date date, Date date2, boolean bl, boolean bl2) {
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(clazz);
            if (bl) {
                criteria.add(Restrictions.isNotNull((String)PosTransaction.PROP_TICKET));
            }
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            if (outlet != null) {
                // empty if block
            }
            if (date != null && date2 != null) {
                criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date, (Object)date2));
            }
            ProjectionList projectionList = Projections.projectionList();
            if (bl2) {
                projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_ID), PosTransaction.PROP_ID);
            }
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_TICKET), PosTransaction.PROP_TICKET);
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_PAYMENT_TYPE_STRING), PosTransaction.PROP_PAYMENT_TYPE_STRING);
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_CARD_TYPE), PosTransaction.PROP_CARD_TYPE);
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_CARD_READER), PosTransaction.PROP_CARD_READER);
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_TRANSACTION_TIME), PosTransaction.PROP_TRANSACTION_TIME);
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_USER_ID), PosTransaction.PROP_USER_ID);
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_CARD_AUTH_CODE), PosTransaction.PROP_CARD_AUTH_CODE);
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_TIPS_AMOUNT), PosTransaction.PROP_TIPS_AMOUNT);
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_AMOUNT), PosTransaction.PROP_AMOUNT);
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_TERMINAL_ID), PosTransaction.PROP_TERMINAL_ID);
            projectionList.add((Projection)Projections.property((String)CustomerAccountTransaction.PROP_CUSTOMER_ID), CustomerAccountTransaction.PROP_CUSTOMER_ID);
            criteria.setProjection((Projection)projectionList);
            criteria.setResultTransformer(Transformers.aliasToBean(PosTransaction.class));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_TRANSACTION_TIME));
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionSummary getTransactionSummary(Terminal terminal, Class clazz, Date date, Date date2) {
        Session session = null;
        TransactionSummary transactionSummary = new TransactionSummary();
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(clazz);
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_DRAWER_RESETTED, (Object)Boolean.FALSE));
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            if (date != null && date2 != null) {
                criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date));
                criteria.add((Criterion)Restrictions.le((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date2));
            }
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.count((String)PosTransaction.PROP_ID));
            projectionList.add((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
            projectionList.add((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
            criteria.setProjection((Projection)projectionList);
            List list = criteria.list();
            if (list == null || list.size() == 0) {
                TransactionSummary transactionSummary2 = transactionSummary;
                return transactionSummary2;
            }
            Object[] objectArray = (Object[])list.get(0);
            int n = 0;
            transactionSummary.setCount(HibernateProjectionsUtil.getInt(objectArray, n++));
            transactionSummary.setAmount(HibernateProjectionsUtil.getDouble(objectArray, n++));
            transactionSummary.setTipsAmount(HibernateProjectionsUtil.getDouble(objectArray, n++));
            TransactionSummary transactionSummary3 = transactionSummary;
            return transactionSummary3;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PosTransaction> findTransactionListByGiftCardNumber(String string, Date date, Date date2) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)DateUtil.startOfDay(date), (Object)DateUtil.endOfDay(date2)));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_GIFT_CERT_NUMBER, (Object)string));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PosTransaction> findCapturedTransactions(User user) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(CreditCardTransaction.class);
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CAPTURED, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)PosTransaction.PROP_VOIDED), (Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE)));
            criteria.add(Restrictions.isNotNull((String)PosTransaction.PROP_TICKET));
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)user.getId()));
            }
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, -1);
            Date date = DateUtil.startOfDay(calendar.getTime());
            Date date2 = DateUtil.endOfDay(new Date());
            criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date, (Object)date2));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PosTransaction> getStoreSessionTransactions(StoreSession storeSession) {
        List<String> list;
        Session session;
        block3: {
            List<PosTransaction> list2;
            session = null;
            try {
                list = CashDrawerDAO.getInstance().getCashDrawerIds(storeSession);
                if (list != null && !list.isEmpty()) break block3;
                list2 = null;
            }
            catch (Throwable throwable) {
                this.closeSession(session);
                throw throwable;
            }
            this.closeSession(session);
            return list2;
        }
        session = this.getSession();
        Criteria criteria = session.createCriteria(this.getReferenceClass(), "t");
        criteria.createAlias(PosTransaction.PROP_TICKET, "ticket");
        criteria.add((Criterion)Restrictions.eq((String)"ticket.closed", (Object)true));
        criteria.add((Criterion)Restrictions.eq((String)"ticket.voided", (Object)false));
        criteria.add(Restrictions.in((String)PosTransaction.PROP_CASH_DRAWER_ID, list));
        List list3 = criteria.list();
        this.closeSession(session);
        return list3;
    }

    public void saveReversalTransaction(Ticket ticket, PosTransaction posTransaction, ReversalTransaction reversalTransaction) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            this.delete(posTransaction, session);
            this.saveOrUpdate(reversalTransaction, session);
            TicketDAO.getInstance().update(ticket, session);
            transaction.commit();
        }
        catch (Exception exception) {
            try {
                transaction.rollback();
            }
            catch (Exception exception2) {
                PosLog.error(PosTransactionService.class, exception2);
                exception2.printStackTrace();
            }
            throw exception;
        }
        finally {
            TerminalDAO.getInstance().closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PosTransaction> findCreditTransactions(Date date, Date date2, User user) {
        Session session = null;
        Criteria criteria = null;
        try {
            List list;
            session = this.createNewSession();
            criteria = session.createCriteria(PosTransaction.class);
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
            criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date, (Object)date2));
            this.addMultiUserFilter(user, criteria);
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_PAYMENT_TYPE_STRING), PosTransaction.PROP_PAYMENT_TYPE_STRING);
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_USER_ID), PosTransaction.PROP_USER_ID);
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_ID), PosTransaction.PROP_ID);
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_TRANSACTION_TIME), PosTransaction.PROP_TRANSACTION_TIME);
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_AMOUNT), PosTransaction.PROP_AMOUNT);
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_TICKET), PosTransaction.PROP_TICKET);
            criteria.setProjection((Projection)projectionList);
            criteria.setResultTransformer(Transformers.aliasToBean(PosTransaction.class));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_PAYMENT_TYPE_STRING));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_TRANSACTION_TIME));
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PosTransaction> getCloudStoreSessionTransactions(StoreSession storeSession) {
        List<String> list;
        Session session;
        block3: {
            List<PosTransaction> list2;
            session = null;
            try {
                list = CashDrawerDAO.getInstance().getCashDrawerIds(storeSession);
                if (list != null && !list.isEmpty()) break block3;
                list2 = null;
            }
            catch (Throwable throwable) {
                this.closeSession(session);
                throw throwable;
            }
            this.closeSession(session);
            return list2;
        }
        session = this.getSession();
        Criteria criteria = session.createCriteria(this.getReferenceClass(), "t");
        criteria.add(Restrictions.in((String)PosTransaction.PROP_CASH_DRAWER_ID, list));
        List list3 = criteria.list();
        this.closeSession(session);
        return list3;
    }

    private void addMultiUserFilter(User user, Criteria criteria) {
        if (user != null) {
            PosLog.info(this.getClass(), "setting multi user filter for root user '" + user.getFullName() + "', id: " + user.getId());
            Disjunction disjunction = Restrictions.disjunction();
            disjunction.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)(user == null ? null : user.getId())));
            List<User> list = user.getLinkedUser();
            if (list != null) {
                for (User user2 : list) {
                    if (user2.getId().equals(user.getId())) continue;
                    PosLog.info(this.getClass(), "linked user '" + user2.getFullName() + "', id: " + user2.getId());
                    disjunction.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)user2.getId()));
                }
            }
            criteria.add((Criterion)disjunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CustomerPaymentReportView.CustomerAccountTransactionItem> findCustomerAccountTransactions(Date date, Date date2, Customer customer) {
        Session session = null;
        try {
            session = this.getSession();
            String string = "select t.%s, t.%s, t.%s, t.%s, t.%s, t.%s, c.%s from PosTransaction as t, Customer as c where t.%s=c.%s ";
            string = String.format(string, PosTransaction.PROP_ID, PosTransaction.PROP_TICKET, PosTransaction.PROP_TRANSACTION_TIME, PosTransaction.PROP_TIPS_AMOUNT, PosTransaction.PROP_AMOUNT, PosTransaction.PROP_CUSTOMER_ID, Customer.PROP_NAME, PosTransaction.PROP_CUSTOMER_ID, Customer.PROP_ID);
            if (customer != null) {
                string = string + "and c.id= '" + customer.getId() + "'";
            }
            Query query = session.createQuery(string);
            List list = query.list();
            ArrayList<CustomerPaymentReportView.CustomerAccountTransactionItem> arrayList = new ArrayList<CustomerPaymentReportView.CustomerAccountTransactionItem>();
            for (Object[] objectArray : list) {
                CustomerPaymentReportView.CustomerAccountTransactionItem customerAccountTransactionItem = new CustomerPaymentReportView.CustomerAccountTransactionItem();
                customerAccountTransactionItem.setTransactionNo(String.valueOf(objectArray[0]));
                Ticket ticket = (Ticket)objectArray[1];
                customerAccountTransactionItem.setTicketNo(ticket.getId());
                customerAccountTransactionItem.setDate((Date)objectArray[2]);
                customerAccountTransactionItem.setTips((double)((Double)objectArray[3]));
                customerAccountTransactionItem.setTotalAmount((double)((Double)objectArray[4]));
                customerAccountTransactionItem.setCustomerId(String.valueOf(objectArray[5]));
                customerAccountTransactionItem.setCustomerName(String.valueOf(objectArray[6]));
                arrayList.add(customerAccountTransactionItem);
            }
            ArrayList<CustomerPaymentReportView.CustomerAccountTransactionItem> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PosTransaction> findTransactionsForCashDrawer(String string, boolean bl) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass(), "t");
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CASH_DRAWER_ID, (Object)string));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)bl));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_PAYMENT_TYPE_STRING));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_TRANSACTION_TIME));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PosTransaction> findTransactionsForServer(String string, String string2) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)string2));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)string));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)false));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_PAYMENT_TYPE_STRING));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_TRANSACTION_TIME));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDistinctCardMmerchantGateway(String string, Integer n) {
        List list = null;
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)string));
            }
            if (n != null) {
                criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TERMINAL_ID, (Object)n));
            }
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, -7);
            criteria.add((Criterion)Restrictions.gt((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)calendar.getTime()));
            criteria.add(Restrictions.isNotNull((String)PosTransaction.PROP_CARD_MERCHANT_GATEWAY));
            criteria.setProjection(Projections.distinct((Projection)Projections.property((String)PosTransaction.PROP_CARD_MERCHANT_GATEWAY)));
            list = criteria.list();
        }
        finally {
            this.closeSession(session);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PosTransaction> findTransactionsForSession(String string) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)string));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)false));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_PAYMENT_TYPE_STRING));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_TRANSACTION_TIME));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findLastTxPaymentTypeName(Ticket ticket) {
        if (StringUtils.isEmpty((String)ticket.getId())) {
            return null;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)false));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TICKET, (Object)ticket));
            criteria.addOrder(Order.desc((String)PosTransaction.PROP_TRANSACTION_TIME));
            criteria.setMaxResults(1);
            criteria.setProjection((Projection)Projections.property((String)PosTransaction.PROP_PAYMENT_TYPE_STRING));
            String string = (String)criteria.uniqueResult();
            if (StringUtils.isNotEmpty((String)string)) {
                String string2 = PaymentType.valueOf(string).getDisplayString();
                return string2;
            }
            String string3 = null;
            return string3;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PosTransaction> getTransactionsByOutlet(Date date, Date date2, Outlet outlet, Pagination pagination) {
        Session session = null;
        Criteria criteria = null;
        try {
            Object object;
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            if (pagination != null) {
                criteria.setFirstResult(pagination.getCurrentRowIndex());
                criteria.setMaxResults(pagination.getPageSize());
            }
            this.updateCriteria(criteria, date, date2, outlet);
            List list = criteria.list();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            this.updateCriteria(criteria, date, date2, outlet);
            if (pagination != null) {
                object = (Number)criteria.uniqueResult();
                pagination.setNumRows(((Number)object).intValue());
            }
            pagination.setRows(list);
            object = list;
            return object;
        }
        finally {
            this.closeSession(session);
        }
    }

    private void updateCriteria(Criteria criteria, Date date, Date date2, Outlet outlet) {
        if (date != null && date2 != null) {
            criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date, (Object)date2));
        }
        if (outlet != null) {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_OUTLET_ID, (Object)outlet.getId()));
        }
    }

    public void savePosTransaction(PosTransaction posTransaction, List<PosTransaction> list, Session session) {
        if (list == null || list.size() == 0) {
            return;
        }
        PosTransaction posTransaction2 = null;
        int n = list.indexOf(posTransaction);
        if (n != -1) {
            posTransaction2 = list.get(n);
            if (posTransaction2 == null) {
                this.save(posTransaction, session);
            } else {
                posTransaction.setVersion(posTransaction2.getVersion());
            }
        } else {
            this.save(posTransaction, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOrUpdatePosTransactions(List<PosTransaction> list) {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (PosTransaction posTransaction : list) {
                PosTransaction posTransaction2 = this.get(posTransaction.getId());
                PaymentType paymentType = posTransaction.getPaymentType();
                if (posTransaction2 == null) {
                    posTransaction2 = paymentType.createTransaction();
                    PropertyUtils.copyProperties((Object)posTransaction2, (Object)posTransaction);
                    this.save(posTransaction2, session);
                    continue;
                }
                long l = posTransaction2.getVersion();
                PropertyUtils.copyProperties((Object)posTransaction2, (Object)posTransaction);
                posTransaction2.setVersion(l);
                this.update(posTransaction2, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            PosLog.error(this.getClass(), exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void savePosTransactions(List<PosTransaction> list) throws Exception {
        if (list == null) {
            return;
        }
        for (PosTransaction posTransaction : list) {
            Transaction transaction = null;
            try (Session session = null;){
                session = this.createNewSession();
                transaction = session.beginTransaction();
                PaymentType paymentType = posTransaction.getPaymentType();
                PosTransaction posTransaction2 = this.get(posTransaction.getId());
                if (posTransaction2 == null) {
                    posTransaction2 = paymentType.createTransaction();
                    PropertyUtils.copyProperties((Object)posTransaction2, (Object)posTransaction);
                    if (StringUtils.isEmpty((String)posTransaction2.getStoreSessionId())) {
                        posTransaction2.setStoreSessionId(StoreUtil.getCurrentStoreSession().getId());
                    }
                    this.save(posTransaction2, session);
                }
                transaction.commit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double findTransactionsAmountByDate(Date date) {
        double d = 0.0;
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(PosTransaction.class);
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
            criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)DateUtil.startOfDay(date), (Object)DateUtil.endOfDay(date)));
            criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
            Object object = criteria.uniqueResult();
            if (object != null && object instanceof Number) {
                d = ((Number)object).doubleValue();
            }
            criteria = session.createCriteria(RefundTransaction.class);
            criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)DateUtil.startOfDay(date), (Object)DateUtil.endOfDay(date)));
            criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
            object = criteria.uniqueResult();
            if (object != null && object instanceof Number) {
                d -= ((Number)object).doubleValue();
            }
            PosLog.info(this.getReferenceClass(), "Net sales_" + date + " : " + d);
            double d2 = NumberUtil.roundToTwoDigit(d);
            return d2;
        }
        finally {
            this.closeSession(session);
        }
    }
}

