/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosException;
import com.floreantpos.main.Application;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.RecipeTable;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.BaseRecepieDAO;
import com.floreantpos.model.dao.InventoryLocationDAO;
import com.floreantpos.model.dao.InventoryTransactionDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.BeanTableModel;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class RecepieDAO
extends BaseRecepieDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rowCount(String string, boolean bl) {
        Session session = null;
        Criteria criteria = null;
        try {
            Number number;
            session = this.createNewSession();
            criteria = session.createCriteria(Recepie.class);
            criteria.setProjection(Projections.rowCount());
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)Recepie.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            if ((number = (Number)criteria.uniqueResult()) != null) {
                int n = number.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRecepies(BeanTableModel<Recepie> beanTableModel, String string, boolean bl) {
        Session session = null;
        Criteria criteria = null;
        try {
            Object object;
            session = this.createNewSession();
            criteria = session.createCriteria(Recepie.class);
            if (StringUtils.isNotEmpty((String)string)) {
                object = Restrictions.disjunction();
                object.add(Restrictions.ilike((String)Recepie.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
                criteria.createAlias(Recepie.PROP_MENU_ITEM, "item");
                object.add(Restrictions.ilike((String)"item.name", (String)string.trim(), (MatchMode)MatchMode.START));
                criteria.add((Criterion)object);
            }
            criteria.addOrder(Order.asc((String)Recepie.PROP_NAME));
            criteria.setFirstResult(beanTableModel.getCurrentRowIndex());
            criteria.setMaxResults(beanTableModel.getPageSize());
            object = criteria.list();
            beanTableModel.setRows((List)object);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Recepie> findBy(MenuItem menuItem) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Recepie.PROP_MENU_ITEM, (Object)menuItem));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void adjustInventory(Double d, List<Recepie> list) throws Exception {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            this.adjustInventory(d, list, session);
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void adjustInventory(Double d, List<Recepie> list, Session session) throws Exception {
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        HashMap<String, Double> hashMap2 = new HashMap<String, Double>();
        for (Recepie idContainer2 : list) {
            Double d2 = idContainer2.getYield();
            Double d3 = idContainer2.getCookingYield();
            MenuItem menuItem = idContainer2.getMenuItem();
            Double d4 = hashMap.get(menuItem.getId());
            if (d4 == null) {
                d4 = 0.0;
            }
            Double d5 = idContainer2.getPortion();
            if ((d5 = Double.valueOf(d5 + d4)) <= 0.0) continue;
            hashMap.put(menuItem.getId(), d5);
            idContainer2.populateRecipeItemQuantity(d, hashMap2, d3 / d2);
        }
        InventoryLocation inventoryLocation = InventoryLocationDAO.getInstance().getDefaultOutInventoryLocation(session);
        InventoryLocation inventoryLocation2 = InventoryLocationDAO.getInstance().getDefaultInInventoryLocation(session);
        this.adjustInventory(hashMap, InventoryTransactionType.IN, "PREPARE IN", inventoryLocation2, session);
        this.adjustInventory(hashMap2, InventoryTransactionType.OUT, "PREPARE OUT", inventoryLocation, session);
    }

    public void adjustRecipeItemsFromInventory(Double d, List<Recepie> list, Session session) throws Exception {
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        HashMap<String, Double> hashMap2 = new HashMap<String, Double>();
        for (Recepie recepie : list) {
            Double d2 = recepie.getYield();
            Double d3 = recepie.getCookingYield();
            MenuItem menuItem = recepie.getMenuItem();
            Double d4 = (Double)hashMap.get(menuItem.getId());
            if (d4 == null) {
                d4 = 0.0;
            }
            Double d5 = recepie.getPortion();
            if ((d5 = Double.valueOf(d5 + d4)) <= 0.0) continue;
            hashMap.put(menuItem.getId(), d5);
            recepie.populateRecipeItemQuantity(d, hashMap2, d3 / d2);
        }
        InventoryLocation inventoryLocation = InventoryLocationDAO.getInstance().getDefaultOutInventoryLocation(session);
        this.adjustInventory(hashMap2, InventoryTransactionType.OUT, "TICKET SALES", inventoryLocation, session);
    }

    private void adjustInventory(HashMap<String, Double> hashMap, InventoryTransactionType inventoryTransactionType, String string, InventoryLocation inventoryLocation, Session session) throws Exception {
        Store store = Application.getInstance().getStore();
        boolean bl = store.isUpdateOnHandBlncForSale();
        boolean bl2 = store.isUpdateAvlBlncForSale();
        for (String string2 : hashMap.keySet()) {
            Double d = hashMap.get(string2);
            MenuItem menuItem = MenuItemDAO.getInstance().getMenuItemWithFields(string2, MenuItem.PROP_NAME, MenuItem.PROP_PRICE, MenuItem.PROP_SKU, MenuItem.PROP_BARCODE, MenuItem.PROP_UNIT_ID, MenuItem.PROP_COST, MenuItem.PROP_AVERAGE_UNIT_PURCHASE_PRICE, MenuItem.PROP_AVG_COST);
            if (menuItem == null) continue;
            menuItem.setId(string2);
            InventoryTransaction inventoryTransaction = new InventoryTransaction();
            inventoryTransaction.setReason(string);
            inventoryTransaction.setTransactionDate(new Date());
            inventoryTransaction.setMenuItem(menuItem);
            inventoryTransaction.setType(inventoryTransactionType.getType());
            inventoryTransaction.setUser(Application.getCurrentUser());
            InventoryUnit inventoryUnit = menuItem.getUnit();
            inventoryTransaction.setUnitPrice(menuItem.getPrice());
            inventoryTransaction.setQuantity(d);
            if (inventoryUnit != null) {
                inventoryTransaction.setUnit(inventoryUnit.getCode());
            }
            inventoryTransaction.setUnitCost(menuItem.getAverageUnitPurchasePrice());
            if (inventoryTransactionType == InventoryTransactionType.IN) {
                inventoryTransaction.setToInventoryLocation(inventoryLocation);
            } else {
                inventoryTransaction.setFromInventoryLocation(inventoryLocation);
            }
            inventoryTransaction.setTotal(inventoryTransaction.getUnitPrice() * inventoryTransaction.getQuantity());
            InventoryTransactionDAO.getInstance().adjustInventoryStock(inventoryTransaction, session, bl2, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMenuItemName(Recepie recepie) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.createAlias("menuItem", "item");
            criteria.setProjection((Projection)Projections.property((String)"item.name"));
            criteria.add((Criterion)Restrictions.eq((String)RecipeTable.PROP_ID, (Object)recepie.getId()));
            String string = (String)criteria.uniqueResult();
            return string;
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    protected Serializable save(Object object, Session session) {
        Recepie recepie = (Recepie)object;
        if (this.nameExists(recepie.getId(), recepie.getName())) {
            throw new PosException("Recipe name already exists.");
        }
        recepie.setLastUpdateTime(new Date());
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        Recepie recepie = (Recepie)object;
        if (this.nameExists(recepie.getId(), recepie.getName())) {
            throw new PosException("Recipe name already exists.");
        }
        recepie.setLastUpdateTime(new Date());
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        Recepie recepie = (Recepie)object;
        if (this.nameExists(recepie.getId(), recepie.getName())) {
            throw new PosException("Recipe name already exists.");
        }
        recepie.setLastUpdateTime(new Date());
        super.saveOrUpdate(object, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nameExists(String string, String string2) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add((Criterion)Restrictions.ne((String)Recepie.PROP_ID, (Object)string));
            }
            criteria.add((Criterion)Restrictions.eq((String)Recepie.PROP_NAME, (Object)string2).ignoreCase());
            Number number = (Number)criteria.uniqueResult();
            boolean bl = number != null && number.intValue() > 0;
            return bl;
        }
        finally {
            this.closeSession(session);
        }
    }
}

