/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Database;
import com.floreantpos.config.AppConfig;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.dao.PosDataInterceptor;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao._BaseRootDAO;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.service.ServiceRegistry;

public abstract class _RootDAO
extends _BaseRootDAO {
    private static StandardServiceRegistry standardServiceRegistry;

    public static void initialize() {
        Database database = AppConfig.getDefaultDatabase();
        String string = AppConfig.getConnectString();
        String string2 = AppConfig.getDatabaseUser();
        String string3 = AppConfig.getDatabasePassword();
        _RootDAO.initialize("oropos.hibernate.cfg.xml", database, string, string2, string3);
    }

    public static void initialize(String string) {
        Database database = AppConfig.getDefaultDatabase();
        String string2 = AppConfig.getConnectString();
        String string3 = AppConfig.getDatabaseUser();
        String string4 = AppConfig.getDatabasePassword();
        _RootDAO.initialize(string, database, string2, string3, string4);
    }

    public static void initialize(String string, Database database, String string2, String string3, String string4) {
        _RootDAO.initialize(string, database.getHibernateDialect(), database.getHibernateConnectionDriverClass(), string2, string3, string4);
    }

    public static void initialize(String string, String string2, String string3, String string4, String string5, String string6) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("hibernate.dialect", string2);
        hashMap.put("hibernate.connection.driver_class", string3);
        hashMap.put("hibernate.connection.url", string4);
        hashMap.put("hibernate.connection.username", string5);
        hashMap.put("hibernate.connection.password", string6);
        hashMap.put("hibernate.connection.autocommit", "false");
        hashMap.put("hibernate.max_fetch_depth", "3");
        hashMap.put("hibernate.show_sql", "false");
        hashMap.put("hibernate.connection.isolation", String.valueOf(1));
        hashMap.put("hibernate.cache.use_second_level_cache", "false");
        hashMap.put("hibernate.cache.provider_class", "org.hibernate.cache.EhCacheProvider");
        hashMap.put("hibernate.cache.region.factory_class", "org.hibernate.cache.ehcache.SingletonEhCacheRegionFactory");
        _RootDAO.initialize(string, hashMap);
    }

    public static void initialize(Map<String, String> map) {
        _RootDAO.initialize("oropos.hibernate.cfg.xml", map);
    }

    public static void initialize(String string, Map<String, String> map) {
        if (sessionFactory != null) {
            sessionFactory.close();
        }
        if (standardServiceRegistry != null) {
            StandardServiceRegistryBuilder.destroy((ServiceRegistry)standardServiceRegistry);
        }
        StandardServiceRegistryBuilder standardServiceRegistryBuilder = new StandardServiceRegistryBuilder();
        URL uRL = _RootDAO.class.getResource("/" + string);
        standardServiceRegistryBuilder.configure(uRL);
        standardServiceRegistryBuilder.applySettings(map);
        _RootDAO.setupCconnectionPoolSettings(standardServiceRegistryBuilder);
        standardServiceRegistry = standardServiceRegistryBuilder.build();
        Metadata metadata = new MetadataSources((ServiceRegistry)standardServiceRegistry).getMetadataBuilder().build();
        SessionFactoryBuilder sessionFactoryBuilder = metadata.getSessionFactoryBuilder();
        SessionFactory sessionFactory = sessionFactoryBuilder.applyInterceptor((Interceptor)new PosDataInterceptor()).build();
        _RootDAO.setSessionFactory(sessionFactory);
    }

    public static void setupCconnectionPoolSettings(StandardServiceRegistryBuilder standardServiceRegistryBuilder) {
        standardServiceRegistryBuilder.applySetting("hibernate.c3p0.min_size", (Object)"0");
        standardServiceRegistryBuilder.applySetting("hibernate.c3p0.max_size", (Object)"5");
        standardServiceRegistryBuilder.applySetting("hibernate.c3p0.timeout", (Object)"300");
        standardServiceRegistryBuilder.applySetting("hibernate.c3p0.max_statements", (Object)"0");
        standardServiceRegistryBuilder.applySetting("hibernate.c3p0.checkoutTimeout", (Object)"5000");
        standardServiceRegistryBuilder.applySetting("hibernate.c3p0.acquireRetryAttempts", (Object)"1");
        standardServiceRegistryBuilder.applySetting("hibernate.c3p0.acquireRetryDelay", (Object)"100");
        standardServiceRegistryBuilder.applySetting("hibernate.c3p0.acquireIncrement", (Object)"1");
        standardServiceRegistryBuilder.applySetting("testConnectionOnCheckout", (Object)"true");
        standardServiceRegistryBuilder.applySetting("hibernate.c3p0.breakAfterAcquireFailure", (Object)"false");
    }

    public static void setupHikariCPSettings(StandardServiceRegistryBuilder standardServiceRegistryBuilder) {
        standardServiceRegistryBuilder.applySetting("hibernate.connection.provider_class", (Object)"org.hibernate.hikaricp.internal.HikariCPConnectionProvider");
        standardServiceRegistryBuilder.applySetting("hibernate.hikari.idleTimeout", (Object)"30000");
        standardServiceRegistryBuilder.applySetting("hibernate.hikari.minimumIdle", (Object)"0");
        standardServiceRegistryBuilder.applySetting("hibernate.hikari.maximumPoolSize", (Object)"5");
    }

    public static void initialize(String string, Configuration configuration) {
        if (standardServiceRegistry != null) {
            StandardServiceRegistryBuilder.destroy((ServiceRegistry)standardServiceRegistry);
        }
        _RootDAO.initialize();
    }

    public static void releaseConnection() {
        if (standardServiceRegistry != null) {
            StandardServiceRegistryBuilder.destroy((ServiceRegistry)standardServiceRegistry);
        }
    }

    public void refresh(Object object) {
        Session session = this.createNewSession();
        super.refresh(object, session);
        session.close();
    }

    public int rowCount() {
        Session session = this.getSession();
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.setProjection(Projections.rowCount());
        return ((Long)criteria.uniqueResult()).intValue();
    }

    public int rowCount(Criteria criteria) {
        criteria.setProjection(Projections.rowCount());
        int n = ((Long)criteria.uniqueResult()).intValue();
        criteria.setProjection(null);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPageData(int n, int n2) {
        Session session = this.getSession();
        try {
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setFirstResult(n * n2);
            criteria.setMaxResults(n2);
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rowCount(Map<String, Object> map) {
        Session session = this.getSession();
        try {
            Object object;
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            if (map != null) {
                object = map.keySet().iterator();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    criteria.add((Criterion)Restrictions.eq((String)string, (Object)map.get(string)));
                }
            }
            if ((object = (Number)criteria.uniqueResult()) != null) {
                int n = ((Number)object).intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPageData(int n, int n2, Map<String, Object> map) {
        Session session = this.getSession();
        try {
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setFirstResult(n * n2);
            criteria.setMaxResults(n2);
            if (map != null) {
                for (String string : map.keySet()) {
                    criteria.add((Criterion)Restrictions.eq((String)string, (Object)map.get(string)));
                }
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    protected void updateTime(Object object) {
        if (!(object instanceof TimedModel)) {
            return;
        }
        TimedModel timedModel = (TimedModel)object;
        Date date = StoreDAO.getServerTimestamp();
        if (timedModel.isUpdateLastUpdateTime()) {
            timedModel.setLastUpdateTime(date);
        }
        if (timedModel.isUpdateSyncTime()) {
            timedModel.setLastSyncTime(date);
        }
    }
}

