/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.model.LabelItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.report.AbstractReportDataSource;
import com.floreantpos.util.NumberUtil;
import java.util.List;

public class LabelPrinterTableModel
extends AbstractReportDataSource {
    public LabelPrinterTableModel(List<LabelItem> list) {
        super(new String[]{"barcodeNumber", "itemName", "memberPrice", "retailPrice"});
        this.setRows(list);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        LabelItem labelItem = (LabelItem)this.rows.get(n);
        MenuItem menuItem = labelItem.getMenuItem();
        switch (n2) {
            case 0: {
                return menuItem.getBarcode();
            }
            case 1: {
                return "<html><body>" + menuItem.getName() + "</body></html>";
            }
            case 2: {
                if (menuItem.getPrice() != null) {
                    return "<html><body>Member Price: " + NumberUtil.getCurrencyFormat(menuItem.getPrice()) + "</body></html>";
                }
                return "";
            }
            case 3: {
                if (menuItem.getRetailPrice() != null) {
                    return "<html><body>Retail Price: " + NumberUtil.getCurrencyFormat(menuItem.getRetailPrice()) + "</body></html>";
                }
                return "";
            }
        }
        return null;
    }
}

