/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.swing.ListTableModel;
import com.floreantpos.util.NumberUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ServerProductivityReport {
    private Date a;
    private Date b;
    private Date c;
    private List<ServerProductivityReportData> d = new ArrayList<ServerProductivityReportData>();
    private ServerProductivityReportTableModel e;

    public ServerProductivityReportTableModel getTableModel() {
        if (this.e == null) {
            this.e = new ServerProductivityReportTableModel(this.d);
        }
        return this.e;
    }

    public Date getFromDate() {
        return this.a;
    }

    public void setFromDate(Date date) {
        this.a = date;
    }

    public Date getReportTime() {
        return this.c;
    }

    public void setReportTime(Date date) {
        this.c = date;
    }

    public Date getToDate() {
        return this.b;
    }

    public void setToDate(Date date) {
        this.b = date;
    }

    public void addReportData(ServerProductivityReportData serverProductivityReportData) {
        this.d.add(serverProductivityReportData);
    }

    public static class ServerProductivityReportTableModel
    extends ListTableModel {
        String[] a = new String[]{"serverName", "categoryName", "totalCheckCount", "totalGuestCount", "totalSales", "netSales", "averageNetSales", "totalAllocation", "grossSales", "salesDiscount", "averageCheck", "averageGuest", "allocation", "checkCount"};

        public ServerProductivityReportTableModel(List<ServerProductivityReportData> list) {
            this.setColumnNames(this.a);
            this.setRows(list);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ServerProductivityReportData serverProductivityReportData = (ServerProductivityReportData)this.rows.get(n);
            switch (n2) {
                case 0: {
                    return serverProductivityReportData.getServerName();
                }
                case 1: {
                    return serverProductivityReportData.getCategoryName();
                }
                case 2: {
                    return String.valueOf(serverProductivityReportData.getTotalCheckCount());
                }
                case 3: {
                    return String.valueOf(serverProductivityReportData.getTotalGuestCount());
                }
                case 4: {
                    return NumberUtil.formatNumber(serverProductivityReportData.getTotalSales());
                }
                case 5: {
                    return NumberUtil.formatNumber(serverProductivityReportData.getNetSales());
                }
                case 6: {
                    return NumberUtil.formatNumber(serverProductivityReportData.getAverageNetSales());
                }
                case 7: {
                    return NumberUtil.formatNumber(serverProductivityReportData.getTotalAllocation());
                }
                case 8: {
                    return NumberUtil.formatNumber(serverProductivityReportData.getGrossSales());
                }
                case 9: {
                    return NumberUtil.formatNumber(serverProductivityReportData.getSalesDiscount());
                }
                case 10: {
                    return NumberUtil.formatNumber(serverProductivityReportData.getAverageCheck());
                }
                case 11: {
                    return NumberUtil.formatNumber(serverProductivityReportData.getAverageGuest());
                }
                case 12: {
                    return NumberUtil.formatNumber(serverProductivityReportData.getAllocation());
                }
                case 13: {
                    return String.valueOf(serverProductivityReportData.getCheckCount());
                }
            }
            return null;
        }
    }

    public static class ServerProductivityReportData {
        private String a;
        private int b;
        private int c;
        private double d;
        private double e;
        private String f;
        private int g;
        private double h;
        private double i;
        private double j;
        private double k;
        private double l;
        private double m;
        private double n;

        public double getAllocation() {
            return this.n;
        }

        public void setAllocation(double d) {
            this.n = d;
        }

        public double getAverageCheck() {
            return this.i;
        }

        public void setAverageCheck(double d) {
            this.i = d;
        }

        public double getAverageGuest() {
            return this.j;
        }

        public void setAverageGuest(double d) {
            this.j = d;
        }

        public String getCategoryName() {
            return this.f;
        }

        public void setCategoryName(String string) {
            this.f = string;
        }

        public double getSalesDiscount() {
            return this.h;
        }

        public void setSalesDiscount(double d) {
            this.h = d;
        }

        public String getServerName() {
            return this.a;
        }

        public void setServerName(String string) {
            this.a = string;
        }

        public double getTotalAllocation() {
            return this.e;
        }

        public void setTotalAllocation(double d) {
            this.e = d;
        }

        public int getTotalCheckCount() {
            return this.b;
        }

        public void setTotalCheckCount(int n) {
            this.b = n;
        }

        public int getTotalGuestCount() {
            return this.c;
        }

        public void setTotalGuestCount(int n) {
            this.c = n;
        }

        public double getTotalSales() {
            return this.d;
        }

        public void setTotalSales(double d) {
            this.d = d;
        }

        public void calculate() {
            if (this.b > 0) {
                this.i = this.d / (double)this.b;
            }
            if (this.c > 0) {
                this.j = this.d / (double)this.c;
            }
            this.l = this.k - this.h;
            if (this.g > 0) {
                this.m = this.l / (double)this.g;
                this.n = (double)this.b / (double)this.g * 100.0;
            }
        }

        public double getAverageNetSales() {
            return this.m;
        }

        public void setAverageNetSales(double d) {
            this.m = d;
        }

        public double getGrossSales() {
            return this.k;
        }

        public void setGrossSales(double d) {
            this.k = d;
        }

        public double getNetSales() {
            return this.l;
        }

        public void setNetSales(double d) {
            this.l = d;
        }

        public int getCheckCount() {
            return this.g;
        }

        public void setCheckCount(int n) {
            this.g = n;
        }
    }
}

