/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.model.User;
import com.floreantpos.report.WeeklyPayrollReportData;
import com.floreantpos.swing.ListTableModel;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class WeeklyPayrollReportModel
extends ListTableModel {
    SimpleDateFormat a = new SimpleDateFormat("EEE MMM dd");
    DecimalFormat b = new DecimalFormat("0.00");

    public WeeklyPayrollReportModel() {
        super(new String[]{"userID", "userName", "role", "regHour", "overtime", "regPmnt", "otPmnt", "total", "payment", "decTips", "nonCashTips", "dateOfWeek"});
    }

    @Override
    public Object getValueAt(int n, int n2) {
        WeeklyPayrollReportData weeklyPayrollReportData = (WeeklyPayrollReportData)this.rows.get(n);
        switch (n2) {
            case 0: {
                User user = weeklyPayrollReportData.getUser();
                User user2 = user.getParentUser();
                if (user2 != null) {
                    return String.valueOf(user2.getId());
                }
                return String.valueOf(user.getId());
            }
            case 1: {
                return weeklyPayrollReportData.getUser().getFirstName() + " " + weeklyPayrollReportData.getUser().getLastName();
            }
            case 2: {
                return weeklyPayrollReportData.getUser().getType().getName();
            }
            case 3: {
                return weeklyPayrollReportData.getRegularHourDisplay();
            }
            case 4: {
                return weeklyPayrollReportData.getOvertimeDisplay();
            }
            case 5: {
                return weeklyPayrollReportData.getRegularPayment();
            }
            case 6: {
                return weeklyPayrollReportData.getOvertimePayment();
            }
            case 7: {
                return weeklyPayrollReportData.getTotalHourDisplay();
            }
            case 8: {
                return weeklyPayrollReportData.getTotalPayment();
            }
            case 9: {
                return null;
            }
            case 10: {
                return null;
            }
            case 11: {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(weeklyPayrollReportData.getFromDateOfWeek());
                calendar.setFirstDayOfWeek(weeklyPayrollReportData.getFirstDayOfWeek());
                int n3 = calendar.get(4);
                return "Week " + n3 + " (" + this.a.format(weeklyPayrollReportData.getFromDateOfWeek()) + " - " + this.a.format(weeklyPayrollReportData.getToDateOfWeek()) + ")";
            }
            case 12: {
                return "To: " + this.a.format(weeklyPayrollReportData.getToDateOfWeek());
            }
        }
        return null;
    }
}

