/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.table;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.ShopTableType;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.dao.ShopTableStatusDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.table.ShopTableForm;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;

public class ShopTableBrowser
extends TransparentPanel {
    private JTable a;
    private BeanTableModel<ShopTable> b;
    private JTextField c;

    public ShopTableBrowser() {
        this.a();
        this.initData();
    }

    private void a() {
        this.setBorder(new TitledBorder(null, Messages.getString("ShopTableBrowser.3"), 2, 2, null, null));
        this.b = new BeanTableModel(ShopTable.class);
        this.b.addColumn(Messages.getString("ShopTableBrowser.0"), ShopTable.PROP_ID);
        this.b.addColumn(Messages.getString("ShopTableBrowser.4"), ShopTable.PROP_NAME);
        this.b.addColumn(Messages.getString("ShopTableBrowser.1"), ShopTable.PROP_CAPACITY);
        this.b.addColumn(Messages.getString("ShopTableBrowser.5"), "typesAsString");
        this.b.addColumn(Messages.getString("ShopTableBrowser.7"), ShopTable.PROP_MIN_CAPACITY);
        this.b.addColumn(Messages.getString("ShopTableBrowser.8"), ShopTable.PROP_RESERVABLE);
        this.b.addColumn(Messages.getString("ShopTableBrowser.2"), ShopTable.PROP_DESCRIPTION);
        this.a = new JTable(this.b);
        this.a.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.a.setSelectionMode(0);
        this.a.setRowHeight(PosUIManager.getSize(20));
        this.a.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ShopTableBrowser.this.d();
                }
            }
        });
        this.a.setRowHeight(PosUIManager.getSize(30));
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)new PosScrollPane(this.a), "Center");
        this.add((Component)this.b(), "South");
        this.add((Component)this.h(), "North");
    }

    private JPanel b() {
        ExplorerButtonPanel explorerButtonPanel = new ExplorerButtonPanel();
        JButton jButton = explorerButtonPanel.getEditButton();
        JButton jButton2 = explorerButtonPanel.getAddButton();
        JButton jButton3 = explorerButtonPanel.getDeleteButton();
        jButton2.setText(Messages.getString("ShopTableBrowser.9"));
        jButton.setText(Messages.getString("ShopTableBrowser.10"));
        jButton3.setText(Messages.getString("ShopTableBrowser.11"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShopTableBrowser.this.d();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShopTableBrowser.this.c();
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShopTableBrowser.this.e();
            }
        });
        JButton jButton4 = new JButton(Messages.getString("ShopTableBrowser.12"));
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShopTableBrowser.this.g();
            }
        });
        JButton jButton5 = new JButton(Messages.getString("ShopTableBrowser.13"));
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShopTableBrowser.this.f();
            }
        });
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("center", ""));
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton);
        transparentPanel.add(jButton3);
        transparentPanel.add(jButton4);
        transparentPanel.add(jButton5);
        jPanel.add((Component)transparentPanel, "");
        return jPanel;
    }

    public void initData() {
        List<ShopTable> list = ShopTableDAO.getInstance().findAllWithTypes();
        BeanTableModel beanTableModel = (BeanTableModel)this.a.getModel();
        beanTableModel.removeAll();
        beanTableModel.addRows(list);
    }

    public void doRefreshTable() {
        List<ShopTable> list = ShopTableDAO.getInstance().findAllWithTypes();
        BeanTableModel beanTableModel = (BeanTableModel)this.a.getModel();
        beanTableModel.removeAll();
        beanTableModel.addRows(list);
    }

    private void c() {
        ShopTableForm shopTableForm = new ShopTableForm(new ShopTable(), false);
        BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)shopTableForm);
        beanEditorDialog.openWithScale(800, 600);
        if (beanEditorDialog.isCanceled()) {
            return;
        }
        ShopTable shopTable = (ShopTable)shopTableForm.getBean();
        this.b.addRow(shopTable);
    }

    private void d() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ShopTableBrowser.17"));
                return;
            }
            n = this.a.convertRowIndexToModel(n);
            ShopTable shopTable = this.b.getRow(n);
            this.b.setRow(n, shopTable);
            ShopTableForm shopTableForm = new ShopTableForm(shopTable, false);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)shopTableForm);
            beanEditorDialog.openWithScale(800, 600);
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            this.a.repaint();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void e() {
        int n = this.a.getSelectedRow();
        if (n < 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ShopTableBrowser.17"));
            return;
        }
        n = this.a.convertRowIndexToModel(n);
        ShopTable shopTable = this.b.getRow(n);
        this.b.setRow(n, shopTable);
        ShopTableForm shopTableForm = new ShopTableForm(shopTable, false);
        shopTableForm.delete();
        this.a.repaint();
        this.doRefreshTable();
    }

    private void f() {
        this.deleteAllTables();
        this.a.repaint();
        this.doRefreshTable();
    }

    public boolean deleteAllTables() {
        try {
            int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("ShopTableForm.20"), Messages.getString("ShopTableForm.21"));
            if (n != 0) {
                return false;
            }
            boolean bl = ShopTableDAO.getInstance().deleteAllTables();
            if (bl) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ShopTableBrowser.19"));
            } else {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ShopTableBrowser.20"));
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
        return false;
    }

    private void g() {
        int n = this.a.getSelectedRow();
        if (n < 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ShopTableBrowser.17"));
            return;
        }
        n = this.a.convertRowIndexToModel(n);
        ShopTable shopTable = this.b.getRow(n);
        int n2 = (int)NumberSelectionDialog2.takeIntInput(Messages.getString("ShopTableBrowser.22"), 1.0);
        if (n2 == -1) {
            return;
        }
        for (int i = 0; i < n2; ++i) {
            this.a(shopTable);
        }
        this.a.repaint();
        this.doRefreshTable();
    }

    private void a(ShopTable shopTable) {
        ShopTable shopTable2 = new ShopTable();
        int n = ShopTableDAO.getInstance().getNextTableNumber();
        if (shopTable2.getId() == null) {
            shopTable2.setId(n + 1);
        }
        List<ShopTableType> list = shopTable.getTypes();
        ArrayList<ShopTableType> arrayList = new ArrayList<ShopTableType>();
        for (ShopTableType shopTableType : list) {
            arrayList.add(shopTableType);
        }
        shopTable2.setTypes(arrayList);
        shopTable2.setCapacity(shopTable.getCapacity());
        shopTable2.setDescription(shopTable.getDescription());
        shopTable2.setName(shopTable.getName());
        shopTable2.setTableStatus(TableStatus.Available);
        shopTable2.setMinCapacity(shopTable.getMinCapacity());
        shopTable2.setReservable(shopTable.isReservable());
        ShopTableDAO.getInstance().saveOrUpdate(shopTable2);
        ShopTableStatus shopTableStatus = new ShopTableStatus();
        shopTableStatus.setId(shopTable2.getId());
        shopTableStatus.setTableStatus(TableStatus.Available);
        ShopTableStatusDAO.getInstance().save(shopTableStatus);
    }

    private JPanel h() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("", "[][][][]", ""));
        JLabel jLabel = new JLabel(Messages.getString("ShopTableBrowser.26"));
        this.c = new JTextField(15);
        JButton jButton = new JButton(Messages.getString("ShopTableBrowser.27"));
        JButton jButton2 = new JButton(Messages.getString("ShopTableBrowser.28"));
        JButton jButton3 = new JButton(Messages.getString("ShopTableBrowser.29"));
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShopTableBrowser.this.i();
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShopTableBrowser.this.i();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShopTableBrowser.this.c.setText("");
                ShopTableBrowser.this.doRefreshTable();
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShopTableBrowser.this.c.setText("");
                ShopTableBrowser.this.doRefreshTable();
            }
        });
        jPanel.add((Component)jLabel, "grow");
        jPanel.add((Component)this.c, "grow");
        jPanel.add((Component)jButton, "grow");
        jPanel.add((Component)jButton3, "grow");
        return jPanel;
    }

    private void i() {
        String string = this.c.getText();
        if (StringUtils.isEmpty((CharSequence)string)) {
            return;
        }
        List<ShopTable> list = ShopTableDAO.getInstance().findBy(string);
        if (list == null || list.size() == 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ShopTableBrowser.36"));
            return;
        }
        BeanTableModel beanTableModel = (BeanTableModel)this.a.getModel();
        beanTableModel.removeAll();
        beanTableModel.addRows(list);
    }
}

