/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.table;

import com.floreantpos.Messages;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.FloorLayoutPlugin;
import com.floreantpos.model.BookingInfo;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.ShopTableType;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.dao.BookingInfoDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.dao.ShopTableStatusDAO;
import com.floreantpos.model.dao.ShopTableTypeDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.CheckBoxList;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.hibernate.StaleStateException;

public class ShopTableForm
extends BeanEditor<ShopTable> {
    private FixedLengthTextField a;
    private IntegerTextField b;
    private IntegerTextField c;
    private FixedLengthTextField d;
    private CheckBoxList e;
    private JPanel f;
    private JRadioButton g;
    private JRadioButton h;
    private JButton i;
    private JButton j;
    private JButton k;
    private JButton l;
    private JButton m;
    private JButton n;
    private JButton o;
    private int p;
    private boolean q;
    private boolean r;
    private String s;
    private Integer t;
    private String u;
    private List<ShopTableType> v;
    private int w;
    private boolean x;
    private IntegerTextField y;
    private JCheckBox z;

    public ShopTableForm(ShopTable shopTable, boolean bl) {
        this.setDuplicate(bl);
        this.a();
        this.setBean(shopTable, false);
        this.initData();
        this.updateView();
    }

    private void a() {
        this.setBorder(new TitledBorder(null, Messages.getString("ShopTableForm.19"), 2, 2, null, null));
        this.setPreferredSize(new Dimension(600, 800));
        this.setLayout((LayoutManager)new MigLayout("", "50[][grow]150", ""));
        this.e = new CheckBoxList();
        this.e.setModel(ShopTableTypeDAO.getInstance().findAll());
        JScrollPane jScrollPane = new JScrollPane(this.e);
        jScrollPane.setPreferredSize(new Dimension(0, 350));
        JLabel jLabel = new JLabel(Messages.getString("ShopTableForm.0"));
        this.add((Component)jLabel, "trailing");
        this.c = new IntegerTextField(6);
        this.c.setEnabled(false);
        this.add((Component)this.c, "wrap");
        JLabel jLabel2 = new JLabel(Messages.getString("ShopTableForm.23"));
        this.add((Component)jLabel2, "trailing");
        this.d = new FixedLengthTextField(20);
        this.add((Component)this.d, "grow, wrap");
        JLabel jLabel3 = new JLabel(Messages.getString("ShopTableForm.2"));
        this.add((Component)jLabel3, "trailing");
        this.a = new FixedLengthTextField();
        this.add((Component)this.a, "grow, wrap");
        JLabel jLabel4 = new JLabel(Messages.getString("ShopTableForm.3"), 4);
        this.add((Component)jLabel4, "grow, trailing");
        this.b = new IntegerTextField(6);
        this.add((Component)this.b, "grow, split 7");
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == ShopTableForm.this.i) {
                    ShopTableForm.this.b.setText("1");
                } else if (actionEvent.getSource() == ShopTableForm.this.j) {
                    ShopTableForm.this.b.setText("2");
                } else if (actionEvent.getSource() == ShopTableForm.this.k) {
                    ShopTableForm.this.b.setText("4");
                } else if (actionEvent.getSource() == ShopTableForm.this.l) {
                    ShopTableForm.this.b.setText("6");
                } else if (actionEvent.getSource() == ShopTableForm.this.m) {
                    ShopTableForm.this.b.setText("8");
                } else if (actionEvent.getSource() == ShopTableForm.this.n) {
                    ShopTableForm.this.b.setText("10");
                }
            }
        };
        this.i = new PosButton("1");
        this.i.setPreferredSize(new Dimension(52, 52));
        this.j = new PosButton("2");
        this.j.setPreferredSize(new Dimension(52, 52));
        this.k = new PosButton("4");
        this.k.setPreferredSize(new Dimension(52, 52));
        this.l = new PosButton("6");
        this.l.setPreferredSize(new Dimension(52, 52));
        this.m = new PosButton("8");
        this.m.setPreferredSize(new Dimension(52, 52));
        this.n = new PosButton("10");
        this.n.setPreferredSize(new Dimension(52, 52));
        this.i.addActionListener(actionListener);
        this.j.addActionListener(actionListener);
        this.k.addActionListener(actionListener);
        this.l.addActionListener(actionListener);
        this.m.addActionListener(actionListener);
        this.n.addActionListener(actionListener);
        this.add((Component)this.i, "");
        this.add((Component)this.j, "");
        this.add((Component)this.k, "");
        this.add((Component)this.l, "");
        this.add((Component)this.m, "");
        this.add((Component)this.n, "");
        JLabel jLabel5 = new JLabel("Min guest", 4);
        this.add((Component)jLabel5, "newline, trailing");
        this.y = new IntegerTextField(6);
        this.add((Component)this.y, "grow, wrap");
        this.z = new JCheckBox(Messages.getString("ShopTableForm.24"));
        this.z.setSelected(true);
        this.add((Component)this.z, "skip 1, grow, wrap");
        this.f = new JPanel();
        this.f.setBorder(new TitledBorder(null, Messages.getString("ShopTableForm.4"), 2, 2, null, null));
        this.add((Component)this.f, "skip 1, grow, wrap");
        this.f.setLayout(new FlowLayout(0, 5, 5));
        this.g = new JRadioButton(Messages.getString("ShopTableForm.5"));
        this.f.add(this.g);
        this.h = new JRadioButton(Messages.getString("ShopTableForm.9"));
        this.f.add(this.h);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.g);
        buttonGroup.add(this.h);
        this.add((Component)new JLabel(), "grow,span");
        final FloorLayoutPlugin floorLayoutPlugin = (FloorLayoutPlugin)ExtensionManager.getPlugin(FloorLayoutPlugin.class);
        if (floorLayoutPlugin != null) {
            this.o = new JButton(Messages.getString("ShopTableForm.40"));
            this.add((Component)new JLabel(Messages.getString("ShopTableForm.10")), "trailing");
            this.add((Component)jScrollPane, "span,grow");
            this.add((Component)this.o, "skip 1");
            this.o.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), floorLayoutPlugin.getBeanEditor());
                    beanEditorDialog.open();
                    ShopTable shopTable = (ShopTable)ShopTableForm.this.getBean();
                    ShopTableForm.this.a(shopTable);
                }
            });
        }
    }

    public void initData() {
        ShopTableDAO.getInstance().initializeSeats((ShopTable)this.bean);
        ShopTableDAO.getInstance().initializeTypes((ShopTable)this.bean);
        int n = ShopTableDAO.getInstance().getNextTableNumber();
        if (n == 0) {
            n = 1;
        }
        for (int i = 1; i <= n + 1; ++i) {
            ShopTable shopTable = ShopTableDAO.getInstance().get(i);
            if (shopTable != null) continue;
            this.c.setText(String.valueOf(i));
            break;
        }
        this.b.setText("4");
        this.a.setText("");
        this.d.setText("");
    }

    @Override
    public void cancel() {
    }

    @Override
    public void clearFields() {
        this.c.setText("");
        this.b.setText("");
        this.a.setText("");
        this.d.setText("");
        this.e.unCheckAll();
        this.g.setSelected(false);
        this.h.setSelected(false);
    }

    @Override
    public boolean delete() {
        try {
            ShopTable shopTable = (ShopTable)this.getBean();
            if (shopTable == null) {
                return false;
            }
            TableStatus tableStatus = shopTable.getShopTableStatus().getTableStatus();
            if (tableStatus.equals((Object)TableStatus.Booked) || tableStatus.equals((Object)TableStatus.Serving)) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("ShopTableForm.100"));
                return false;
            }
            int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("ShopTableForm.14"), Messages.getString("ShopTableForm.15"));
            if (n != 0) {
                return false;
            }
            List<BookingInfo> list = BookingInfoDAO.getInstance().findAll();
            block2: for (BookingInfo bookingInfo : list) {
                List<ShopTable> list2 = bookingInfo.getTables();
                for (ShopTable shopTable2 : list2) {
                    if (!shopTable2.getId().equals(shopTable.getId())) continue;
                    list2.remove(shopTable2);
                    bookingInfo.setTables(list2);
                    BookingInfoDAO.getInstance().saveOrUpdate(bookingInfo);
                    continue block2;
                }
            }
            ShopTableDAO.getInstance().delete(shopTable);
            this.b.setText("");
            this.a.setText("");
            this.d.setText("");
            this.c.setText("");
            this.e.unCheckAll();
            return true;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
            return false;
        }
    }

    public boolean deleteAllTables() {
        List<ShopTable> list = ShopTableDAO.getInstance().findAll();
        if (list.isEmpty()) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("ShopTableForm.51"));
            return false;
        }
        int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("ShopTableForm.20"), Messages.getString("ShopTableForm.21"));
        if (n != 0) {
            return false;
        }
        List<BookingInfo> list2 = BookingInfoDAO.getInstance().findAll();
        for (BookingInfo comparable : list2) {
            comparable.setTables(null);
            BookingInfoDAO.getInstance().saveOrUpdate(comparable);
        }
        for (ShopTable shopTable : list) {
            shopTable.setFloor(null);
            shopTable.setTypes(null);
            ShopTableDAO.getInstance().delete(shopTable);
        }
        this.c.setText("");
        this.b.setText("");
        this.a.setText("");
        this.d.setText("");
        this.e.unCheckAll();
        return true;
    }

    public void setFieldsEditable(boolean bl) {
        this.d.setEditable(bl);
        this.a.setEditable(bl);
        this.b.setEditable(bl);
    }

    @Override
    public void setFieldsEnable(boolean bl) {
        this.e.setEnabled(bl);
        this.e.clearSelection();
        this.d.setEnabled(bl);
        this.a.setEnabled(bl);
        this.b.setEnabled(bl);
        this.i.setEnabled(bl);
        this.j.setEnabled(bl);
        this.k.setEnabled(bl);
        this.l.setEnabled(bl);
        this.m.setEnabled(bl);
        this.n.setEnabled(bl);
        if (this.o != null) {
            this.o.setEnabled(bl);
        }
        this.g.setEnabled(bl);
        this.h.setEnabled(bl);
    }

    public void setOnlyStatusEnable() {
        this.c.setEditable(false);
        this.d.setEditable(false);
        this.a.setEditable(false);
        this.b.setEditable(false);
        this.i.setVisible(false);
        this.j.setVisible(false);
        this.k.setVisible(false);
        this.l.setVisible(false);
        this.m.setVisible(false);
        this.n.setVisible(false);
        this.e.setEnabled(false);
        if (this.o != null) {
            this.o.setVisible(false);
        }
        this.g.setEnabled(true);
        this.h.setEnabled(true);
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            ShopTable shopTable = (ShopTable)this.getBean();
            ShopTableDAO.getInstance().saveOrUpdate(shopTable);
            ShopTableStatus shopTableStatus = shopTable.getShopTableStatus();
            ShopTableStatusDAO.getInstance().saveOrUpdate(shopTableStatus);
            this.updateView();
            return true;
        }
        catch (IllegalModelStateException illegalModelStateException) {
        }
        catch (StaleStateException staleStateException) {
            BOMessageDialog.showError(this, Messages.getString("ShopTableForm.16"));
            return false;
        }
        return false;
    }

    @Override
    protected void updateView() {
        ShopTable shopTable = (ShopTable)this.getBean();
        if (shopTable == null) {
            return;
        }
        if (shopTable.getId() == null) {
            this.c.setEnabled(true);
        }
        Integer n = shopTable.getCapacity() == 0 ? 4 : shopTable.getCapacity();
        this.a(shopTable);
        this.c.setText(String.valueOf(shopTable.getTableNumber()));
        this.d.setText(shopTable.getName());
        this.a.setText(shopTable.getDescription());
        this.b.setText(String.valueOf(n));
        this.y.setText(String.valueOf(shopTable.getMinCapacity()));
        if (shopTable.isReservable() != null) {
            this.z.setSelected(shopTable.isReservable());
        } else {
            this.z.setSelected(true);
        }
        this.g.setSelected(true);
        TableStatus tableStatus = shopTable.getTableStatus();
        if (tableStatus == TableStatus.Disable) {
            this.h.setSelected(true);
        }
        if (shopTable.getTableNumber() != null) {
            this.w = shopTable.getTableNumber();
        }
        if (this.isDuplicateOn()) {
            List list = this.e.getCheckedValues();
            this.v = list;
            this.t = n;
            this.u = shopTable.getDescription();
            this.s = shopTable.getName();
            this.q = this.g.isSelected();
            this.r = this.h.isSelected();
        }
    }

    private void a(ShopTable shopTable) {
        this.e.setModel(ShopTableTypeDAO.getInstance().findAll());
        this.e.selectItems(shopTable.getTypes());
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        ShopTable shopTable = (ShopTable)this.getBean();
        if (shopTable == null) {
            shopTable = new ShopTable();
            this.setBean(shopTable, false);
        }
        if (!this.isDuplicateOn() && this.c.getInteger() == 0) {
            POSMessageDialog.showError(null, Messages.getString("ShopTableForm.57"));
            return false;
        }
        ShopTable shopTable2 = ShopTableDAO.getInstance().get(this.c.getInteger());
        if (shopTable2 != null && this.w != shopTable2.getId()) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("ShopTableForm.58"));
            return false;
        }
        int n = this.y.getInteger();
        if (this.isDuplicateOn()) {
            shopTable = new ShopTable();
            int n2 = ShopTableDAO.getInstance().getNextTableNumber();
            for (int i = 1; i <= n2; ++i) {
                ShopTable shopTable3 = ShopTableDAO.getInstance().get(i);
                if (shopTable3 != null) continue;
                shopTable.setId(i);
                break;
            }
            if (shopTable.getId() == null) {
                shopTable.setId(n2 + 1);
            }
            shopTable.setTypes(this.v);
            shopTable.setCapacity(this.t);
            shopTable.setDescription(this.u);
            shopTable.setName(this.s);
            if (this.q) {
                shopTable.setTableStatus(TableStatus.Available);
            }
            if (this.r) {
                shopTable.setTableStatus(TableStatus.Disable);
            }
            shopTable.setMinCapacity(n == 0 ? 1 : n);
            shopTable.setReservable(this.z.isSelected());
            this.setDuplicate(false);
            this.setBean(shopTable);
        } else {
            shopTable.setId(this.c.getInteger());
            shopTable.setName(this.d.getText());
            shopTable.setDescription(this.a.getText());
            if (this.b.getInteger() == 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ShopTableForm.25"));
                return false;
            }
            shopTable.setCapacity(this.b.getInteger());
            List<ShopTableType> list = this.e.getCheckedValues();
            shopTable.setTypes(list);
            if (this.g.isSelected()) {
                shopTable.setTableStatus(TableStatus.Available);
            } else if (this.h.isSelected()) {
                shopTable.setTableStatus(TableStatus.Disable);
            }
            shopTable.setMinCapacity(n == 0 ? 1 : n);
            shopTable.setReservable(this.z.isSelected());
        }
        this.setNewTable(shopTable.getId());
        return true;
    }

    @Override
    public void edit() {
        System.out.println("");
    }

    @Override
    public String getDisplayText() {
        if (((ShopTable)this.getBean()).getId() == null) {
            return Messages.getString("ShopTableForm.18");
        }
        return Messages.getString("ShopTableForm.27");
    }

    public void setTableTypeCBoxListEnable(boolean bl) {
        this.e.setEnabled(bl);
    }

    public boolean isDuplicateOn() {
        return this.x;
    }

    public void setDuplicate(boolean bl) {
        this.x = bl;
    }

    public int getNewTable() {
        return this.p;
    }

    public void setNewTable(int n) {
        this.p = n;
    }
}

