/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.main.Application;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.EmployeeInOutHistory;
import com.floreantpos.model.Shift;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.AttendenceHistoryDAO;
import com.floreantpos.model.dao.EmployeeInOutHistoryDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.ShiftUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;

public class AttendanceDialog
extends POSDialog {
    private SimpleDateFormat a = new SimpleDateFormat("MMM,dd  hh:mm a");
    private JXTable b;
    private User c;
    private static final SimpleDateFormat d = new SimpleDateFormat("hh:mm:ss");
    private Timer e = new Timer(1000, new ClockTimerHandler());
    private TitlePanel f;

    public AttendanceDialog(User user) {
        this.c = user;
        this.setLayout((LayoutManager)new MigLayout("fill"));
        this.setTitle("CLOCKED IN/OUT STATUS");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(5, 10, 5, 10));
        this.b = new JXTable((TableModel)new AttendenceHistoryTableModel(AttendenceHistoryDAO.getInstance().findAll()));
        jPanel.add(new PosScrollPane((Component)this.b));
        this.b.getSelectionModel().setSelectionMode(0);
        this.b.setRowHeight(45);
        this.b.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
        this.b.getTableHeader().setPreferredSize(PosUIManager.getSize(0, 40));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("center,hidemode 3,ins 5 0 5 0"));
        this.f = new TitlePanel();
        this.f.setTitle("");
        this.add((Component)this.f, "grow,wrap");
        JLabel jLabel = new JLabel();
        jLabel.setFont(new Font(this.getFont().getName(), 1, 20));
        jPanel2.add((Component)jLabel, "grow");
        PosButton posButton = new PosButton(Messages.getString("ClockInOutAction.5"));
        posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttendanceDialog.this.a(AttendanceDialog.this.c);
            }
        });
        PosButton posButton2 = new PosButton(Messages.getString("ClockInOutAction.6"));
        posButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttendanceDialog.this.b(AttendanceDialog.this.c);
            }
        });
        PosButton posButton3 = new PosButton("DRIVER IN");
        posButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttendanceDialog.this.performDriverIn(AttendanceDialog.this.c);
            }
        });
        PosButton posButton4 = new PosButton("DRIVER OUT");
        posButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttendanceDialog.this.performDriverOut(AttendanceDialog.this.c);
            }
        });
        if (user.isClockedIn().booleanValue()) {
            jPanel2.add(posButton2);
        } else {
            jPanel2.add(posButton);
        }
        if (user.isDriver().booleanValue() && user.isClockedIn().booleanValue()) {
            if (user.isAvailableForDelivery().booleanValue()) {
                jPanel2.add(posButton4);
            } else {
                jPanel2.add(posButton3);
            }
        }
        PosButton posButton5 = new PosButton(Messages.getString("ClockInOutAction.7"));
        posButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttendanceDialog.this.dispose();
            }
        });
        PosButton posButton6 = new PosButton("PRINT");
        posButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string = "- Emp. :" + AttendanceDialog.this.c.getFullName() + " (#" + AttendanceDialog.this.c.getId() + ")";
                    String string2 = " Clocked in : " + AttendanceDialog.this.a.format(AttendanceDialog.this.c.getLastClockInTime()) + "\n Printed On: " + AttendanceDialog.this.a.format(new Date());
                    ReceiptPrintService.printGenericReport(string, string2);
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
                }
            }
        });
        jPanel2.add(posButton6);
        jPanel2.add(posButton5);
        jPanel2.add((Component)new JSeparator(), "newline,span");
        jPanel.add((Component)jPanel2, "South");
        this.add((Component)jPanel, "grow");
        this.showAttendanceTime();
        this.a();
        this.e.start();
    }

    private void a() {
        try {
            Date date = this.c.getLastClockInTime();
            Date date2 = DateUtil.endOfDay(new Date());
            AttendenceHistoryDAO attendenceHistoryDAO = new AttendenceHistoryDAO();
            List<AttendenceHistory> list = attendenceHistoryDAO.findAttendanceHistory(date, date2, this.c);
            AttendenceHistoryTableModel attendenceHistoryTableModel = (AttendenceHistoryTableModel)this.b.getModel();
            attendenceHistoryTableModel.setRows(list);
        }
        catch (Exception exception) {
            BOMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.e.start();
        } else {
            this.e.stop();
        }
    }

    public void showAttendanceTime() {
        Date date = this.c.getLastClockInTime();
        Date date2 = new Date();
        DateTime dateTime = new DateTime((Object)date);
        DateTime dateTime2 = new DateTime((Object)date2);
        Period period = new Period((ReadableInstant)dateTime, (ReadableInstant)dateTime2);
        int n = period.getHours();
        int n2 = period.getMinutes();
        int n3 = period.getMinutes();
        String string = "Welcome  " + this.c.getFullName() + "(#" + this.c.getId() + ")";
        String string2 = "You have been clocked In for ";
        if (n > 0) {
            string2 = n > 1 ? string2 + n + " Hours " : string2 + n + " Hour ";
        }
        string2 = n2 > 1 ? string2 + n2 + " Minutes " : string2 + n2 + " Minute ";
        if (this.c.isClockedIn().booleanValue()) {
            this.f.setTitle("<html><h3 style='color:gray'>" + string + "<br>" + string2 + "</h3></html>");
        } else {
            this.f.setTitle("<html>" + string + "<br></html>");
        }
    }

    private void a(User user) {
        try {
            if (user == null) {
                return;
            }
            if (user.isClockedIn() != null && user.isClockedIn().booleanValue()) {
                POSMessageDialog.showMessage(Messages.getString("ClockInOutAction.11") + user.getFirstName() + " " + user.getLastName() + Messages.getString("ClockInOutAction.13"));
                return;
            }
            Shift shift = ShiftUtil.getCurrentShift();
            Calendar calendar = Calendar.getInstance();
            user.doClockIn(Application.getInstance().getTerminal(), shift, calendar);
            POSMessageDialog.showMessage(Messages.getString("ClockInOutAction.14") + user.getFirstName() + " " + user.getLastName() + Messages.getString("ClockInOutAction.16"));
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private void b(User user) {
        try {
            Calendar calendar;
            Comparable comparable;
            if (user == null) {
                return;
            }
            AttendenceHistoryDAO attendenceHistoryDAO = new AttendenceHistoryDAO();
            AttendenceHistory attendenceHistory = attendenceHistoryDAO.findHistoryByClockedInTime(user);
            if (attendenceHistory == null) {
                attendenceHistory = new AttendenceHistory();
                comparable = user.getLastClockInTime();
                calendar = Calendar.getInstance();
                calendar.setTime((Date)comparable);
                attendenceHistory.setClockInTime((Date)comparable);
                attendenceHistory.setClockInHour((short)calendar.get(10));
                attendenceHistory.setUser(user);
                attendenceHistory.setTerminal(Application.getInstance().getTerminal());
                attendenceHistory.setShift(user.getCurrentShift());
            }
            comparable = user.getCurrentShift();
            calendar = Calendar.getInstance();
            user.doClockOut(attendenceHistory, (Shift)comparable, calendar);
            POSMessageDialog.showMessage(Messages.getString("ClockInOutAction.8") + user.getFirstName() + " " + user.getLastName() + Messages.getString("ClockInOutAction.10"));
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    public void performDriverOut(User user) {
        try {
            if (user == null) {
                return;
            }
            Shift shift = ShiftUtil.getCurrentShift();
            Terminal terminal = Application.getInstance().getTerminal();
            Calendar calendar = Calendar.getInstance();
            user.setAvailableForDelivery(false);
            user.setLastClockOutTime(calendar.getTime());
            LogFactory.getLog(Application.class).info((Object)("terminal id befor saving clockIn=" + terminal.getId()));
            EmployeeInOutHistory employeeInOutHistory = new EmployeeInOutHistory();
            employeeInOutHistory.setOutTime(calendar.getTime());
            employeeInOutHistory.setOutHour((short)calendar.get(11));
            employeeInOutHistory.setClockOut(true);
            employeeInOutHistory.setUser(user);
            employeeInOutHistory.setTerminal(terminal);
            employeeInOutHistory.setShift(shift);
            UserDAO.getInstance().saveDriverOut(user, employeeInOutHistory, shift, calendar);
            POSMessageDialog.showMessage("Driver " + user.getFirstName() + " " + user.getLastName() + " is out for delivery.");
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    public void performDriverIn(User user) {
        try {
            Calendar calendar;
            Comparable comparable;
            if (user == null) {
                return;
            }
            if (!user.isClockedIn().booleanValue()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ClockInOutAction.2"));
                return;
            }
            EmployeeInOutHistoryDAO employeeInOutHistoryDAO = new EmployeeInOutHistoryDAO();
            EmployeeInOutHistory employeeInOutHistory = employeeInOutHistoryDAO.findDriverHistoryByClockedInTime(user);
            if (employeeInOutHistory == null) {
                employeeInOutHistory = new EmployeeInOutHistory();
                comparable = user.getLastClockOutTime();
                calendar = Calendar.getInstance();
                calendar.setTime((Date)comparable);
                employeeInOutHistory.setOutTime((Date)comparable);
                employeeInOutHistory.setOutHour((short)calendar.get(10));
                employeeInOutHistory.setUser(user);
                employeeInOutHistory.setTerminal(Application.getInstance().getTerminal());
                employeeInOutHistory.setShift(user.getCurrentShift());
            }
            comparable = user.getCurrentShift();
            calendar = Calendar.getInstance();
            user.setAvailableForDelivery(true);
            employeeInOutHistory.setClockOut(false);
            employeeInOutHistory.setInTime(calendar.getTime());
            employeeInOutHistory.setInHour((short)calendar.get(11));
            UserDAO.getInstance().saveDriverIn(user, employeeInOutHistory, (Shift)comparable, calendar);
            POSMessageDialog.showMessage("Driver " + user.getFirstName() + " " + user.getLastName() + " is in after delivery");
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    class AttendenceHistoryTableModel
    extends ListTableModel {
        String[] a = new String[]{Messages.getString("AttendanceHistoryExplorer.7"), Messages.getString("AttendanceHistoryExplorer.8"), Messages.getString("AttendanceHistoryExplorer.9"), Messages.getString("AttendanceHistoryExplorer.10"), Messages.getString("AttendanceHistoryExplorer.11"), Messages.getString("AttendanceHistoryExplorer.12"), Messages.getString("AttendanceHistoryExplorer.13")};

        AttendenceHistoryTableModel(List<AttendenceHistory> list) {
            this.setRows(list);
            this.setColumnNames(this.a);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            AttendenceHistory attendenceHistory = (AttendenceHistory)this.rows.get(n);
            switch (n2) {
                case 0: {
                    return attendenceHistory.getUser().getId();
                }
                case 1: {
                    return attendenceHistory.getUser().getFirstName() + " " + attendenceHistory.getUser().getLastName();
                }
                case 2: {
                    Date date = attendenceHistory.getClockInTime();
                    if (date != null) {
                        return AttendanceDialog.this.a.format(date);
                    }
                    return "";
                }
                case 3: {
                    Date date = attendenceHistory.getClockOutTime();
                    if (date != null) {
                        return AttendanceDialog.this.a.format(date);
                    }
                    return "";
                }
                case 4: {
                    return attendenceHistory.isClockedOut();
                }
                case 5: {
                    if (attendenceHistory.getShift() == null) {
                        return "";
                    }
                    return attendenceHistory.getShift().getId();
                }
                case 6: {
                    return attendenceHistory.getTerminal().getId();
                }
            }
            return null;
        }
    }

    private class ClockTimerHandler
    implements ActionListener {
        private ClockTimerHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!AttendanceDialog.this.isShowing()) {
                AttendanceDialog.this.e.stop();
                return;
            }
            AttendanceDialog.this.showAttendanceTime();
        }
    }
}

