/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.actions.DrawerAssignmentAction;
import com.floreantpos.actions.StaffBankCloseAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CashDropTransaction;
import com.floreantpos.model.DrawerType;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TipsCashoutReport;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BaseStore;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.CashDropTransactionDAO;
import com.floreantpos.model.dao.GratuityDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.print.PosPrintService;
import com.floreantpos.report.CashDrawerTransactionReportModel;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.services.report.CashDrawerReportService;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.DetailReportDialog;
import com.floreantpos.ui.dialog.GratuityDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PayoutDialog;
import com.floreantpos.ui.dialog.TipsCashoutReportDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.ui.views.TicketReceiptView;
import com.floreantpos.util.DrawerUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import org.jdesktop.swingx.JXDatePicker;

public class CashDrawerReportDialog
extends POSDialog
implements ActionListener {
    private TitlePanel a;
    private CashDrawer b;
    private PosButton c;
    private PosButton d;
    private PosButton e;
    private PosButton f;
    private PosButton g;
    private PosButton h;
    private PosButton i;
    private User j;
    private Terminal k;
    private PosButton l;
    private PosButton m;
    private List<CashDrawer> n;
    private JPanel o;
    private JPanel p;
    private JPanel q;
    private PosButton r;
    private boolean s;
    private JasperPrint t;
    private JasperPrint u;

    public CashDrawerReportDialog(CashDrawer cashDrawer) {
        this(null, cashDrawer);
    }

    public CashDrawerReportDialog(User user, CashDrawer cashDrawer) {
        super(POSUtil.getFocusedWindow());
        this.setModal(true);
        this.j = user;
        this.b = cashDrawer;
        this.k = cashDrawer.getTerminal();
        this.b();
        this.setSize(PosUIManager.getSize(800, 670));
    }

    private void a() {
        boolean bl;
        if (this.s) {
            return;
        }
        if (this.b.getId() == null || this.b.isClosed()) {
            this.a(false);
            return;
        }
        boolean bl2 = this.b.getTerminal().getId().intValue() == Application.getInstance().getTerminal().getId().intValue();
        boolean bl3 = bl = this.b.getDrawerType() == DrawerType.STAFF_BANK;
        if (bl) {
            this.c.setText("CLOSE STAFF BANK");
        }
        this.c.setEnabled(this.b.getId() != null && this.b.isOpen());
        this.g.setEnabled(this.b.getId() != null && this.b.isOpen());
        this.i.setVisible(bl);
        this.h.setVisible(bl);
        this.g.setVisible(bl);
        this.d.setVisible(!bl);
        this.e.setVisible(!bl && bl2);
        this.f.setVisible(bl2);
        this.c.setVisible(!bl);
    }

    private void a(boolean bl) {
        this.c.setEnabled(bl);
        this.g.setVisible(bl);
        this.i.setEnabled(bl);
        this.h.setEnabled(bl);
        this.g.setEnabled(bl);
        this.d.setEnabled(bl);
        this.f.setEnabled(bl);
        this.c.setVisible(bl);
    }

    public void showInfoOnly(boolean bl) {
        this.s = bl;
        this.p.setVisible(!bl);
        if (this.j == null) {
            return;
        }
        if (this.s) {
            this.q.removeAll();
            this.q.add((Component)new JSeparator(), "grow,span,wrap");
            this.q.add((Component)this.m, "grow");
            this.q.add((Component)this.l, "grow");
            this.q.add((Component)this.r, "grow");
            this.g.setVisible(!this.s);
            this.c.setVisible(!this.s);
        }
    }

    private void b() {
        this.setLayout(new BorderLayout(5, 5));
        this.a = new TitlePanel();
        this.add((Component)this.a, "North");
        this.o = new JPanel(new BorderLayout());
        this.add(new PosScrollPane(this.o));
        this.q = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,ins 5 5 5 5,wrap 5", "[grow]", ""));
        this.l = new PosButton(Messages.getString("DrawerPullReportDialog.8"));
        this.r = new PosButton(POSConstants.SAVE_BUTTON_TEXT);
        this.d = new PosButton(POSConstants.DRAWER_BLEED);
        this.e = new PosButton(Messages.getString("ManagerDialog.1"));
        this.f = new PosButton(POSConstants.PAYOUT_BUTTON_TEXT);
        this.c = new PosButton("CLOSE DRAWER");
        this.d.addActionListener(this);
        this.e.addActionListener(this);
        this.f.addActionListener(this);
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CashDrawerReportDialog.this.o();
            }
        });
        this.g = new PosButton("CLOSE STAFF BANK");
        this.g.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CashDrawerReportDialog.this.p();
            }
        });
        this.i = new PosButton("DECLARE TIPS");
        this.i.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CashDrawerReportDialog.this.f();
            }
        });
        this.h = new PosButton("ENCASH TIPS");
        this.h.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CashDrawerReportDialog.this.g();
            }
        });
        this.p = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,ins 0 20 0 20,wrap 1", "[120px,grow]", ""));
        this.q.add((Component)new JSeparator(), "grow,span,wrap");
        this.q.add((Component)this.l, "gapleft 160,grow");
        this.m = new PosButton(POSConstants.DETAILS.toUpperCase());
        this.m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CashDrawerReportDialog.this.c();
            }
        });
        this.p.add((Component)this.d, "grow");
        this.p.add((Component)this.e, "grow");
        this.p.add((Component)this.f, "grow");
        this.q.add((Component)this.m, "grow");
        this.q.add((Component)this.c, "grow");
        this.q.add((Component)this.g, "grow");
        this.p.add((Component)this.h, "grow");
        this.q.add((Component)this.r, "grow");
        this.add((Component)this.q, "South");
        this.add((Component)this.p, "West");
        this.r.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CashDrawerReportDialog.this.h();
            }
        });
        this.l.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CashDrawerReportDialog.this.i();
            }
        });
    }

    public void refreshReport() {
        try {
            this.createReport(!this.s);
            this.a();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private void c() {
        try {
            if (this.b == null) {
                return;
            }
            this.d();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void d() throws Exception {
        this.e();
        DetailReportDialog detailReportDialog = new DetailReportDialog(this.t);
        detailReportDialog.setTitle(this.b.getType().intValue() == DrawerType.DRAWER.getTypeNumber() ? "Cash Drawer Sales details" : "Server Bank Sales details");
        detailReportDialog.updateView();
        detailReportDialog.open();
    }

    private void e() throws JRException {
        Object object;
        Object object2;
        ArrayList<PosTransaction> arrayList = new ArrayList<PosTransaction>();
        if (this.n != null && this.n.size() > 0) {
            for (CashDrawer serializable2 : this.n) {
                object2 = PosTransactionDAO.getInstance().findTransactionsForCashDrawer(serializable2.getId(), false);
                arrayList.addAll((Collection<PosTransaction>)object2);
            }
        } else {
            object = PosTransactionDAO.getInstance().findTransactionsForCashDrawer(this.b.getId(), false);
            arrayList.addAll((Collection<PosTransaction>)object);
        }
        object = new CashDrawerTransactionReportModel();
        ((CashDrawerTransactionReportModel)object).setItems(arrayList);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        object2 = Application.getInstance().getStore();
        hashMap.put("headerLine1", ((BaseStore)object2).getName());
        hashMap.put("headerLine2", ((BaseStore)object2).getAddressLine1());
        hashMap.put("receiptType", this.b.getType().intValue() == DrawerType.DRAWER.getTypeNumber() ? "Cash Drawer Sales details" : "Server Bank Sales details");
        if (this.b.getAssignedUser() != null) {
            hashMap.put("serverName", "Assigned To: " + this.b.getAssignedUser());
        }
        hashMap.put("startDate", "Date: " + DateUtil.formatFullDateAndTimeAsString(this.b.getStartTime()));
        hashMap.put("status", arrayList == null || arrayList.isEmpty() ? "No transaction found." : null);
        JasperReport jasperReport = ReportUtil.getReport("transaction_report_receipt");
        this.t = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)object));
    }

    private void f() {
        try {
            if (this.b == null) {
                return;
            }
            Double d = NumberSelectionDialog2.takeDoubleInput("Enter tips amount", "Tips Amount", this.b.getTipsPaid());
            if (Double.isNaN(d)) {
                return;
            }
            this.b.setDeclaredTips(d);
            TerminalDAO.getInstance().performBatchSave(this.b);
            this.refreshReport();
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    private void g() {
        this.j();
    }

    private void h() {
        this.dispose();
    }

    @Override
    public void setTitle(String string) {
        this.a.setTitle(string);
        super.setTitle(VersionInfo.getAppName());
    }

    private void i() {
        try {
            PosPrintService.printReportByJasperPrint(this.u);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this, posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, Messages.getString("DrawerPullReportDialog.122") + exception.getMessage(), exception);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        PosButton posButton = (PosButton)actionEvent.getSource();
        if (posButton == this.d) {
            this.k();
            this.refreshReport();
        } else if (posButton == this.e) {
            this.l();
        } else if (posButton == this.f) {
            this.m();
            this.refreshReport();
        }
    }

    private void j() {
        GratuityDialog gratuityDialog = new GratuityDialog((Window)this, this.j);
        gratuityDialog.setCaption("Tips Management");
        gratuityDialog.setOkButtonText("PAY");
        gratuityDialog.setSize(PosUIManager.getSize(780, 550));
        gratuityDialog.open();
        if (gratuityDialog.isCanceled()) {
            return;
        }
        try {
            this.refreshReport();
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    private void k() {
        try {
            DrawerUtil.kickDrawer();
            NumberSelectionDialog2 numberSelectionDialog2 = new NumberSelectionDialog2();
            numberSelectionDialog2.setTitle(Messages.getString("CashDropDialog.17"));
            numberSelectionDialog2.setFloatingPoint(true);
            numberSelectionDialog2.pack();
            numberSelectionDialog2.open();
            if (!numberSelectionDialog2.isCanceled()) {
                double d = numberSelectionDialog2.getValue();
                CashDropTransaction cashDropTransaction = new CashDropTransaction();
                StoreSession storeSession = DataProvider.get().getStoreSession();
                cashDropTransaction.setDrawerResetted(false);
                cashDropTransaction.setTerminal(this.k);
                if (this.j.isStaffBankStarted().booleanValue()) {
                    cashDropTransaction.setCashDrawer(this.j.getActiveDrawerPullReport());
                } else {
                    cashDropTransaction.setCashDrawer(this.k.getCurrentCashDrawer());
                }
                cashDropTransaction.setPaymentType(PaymentType.CASH);
                cashDropTransaction.setUser(this.j);
                cashDropTransaction.setServer(this.j);
                cashDropTransaction.setTransactionTime(new Date());
                cashDropTransaction.setAmount(d);
                cashDropTransaction.setStoreSessionId(storeSession.getId());
                CashDropTransactionDAO cashDropTransactionDAO = new CashDropTransactionDAO();
                cashDropTransactionDAO.saveNewCashDrop(cashDropTransaction, this.k);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("CashDropDialog.18"), exception);
        }
    }

    private void l() {
        try {
            DrawerUtil.kickDrawer();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private void m() {
        try {
            TerminalDAO.getInstance().refresh(this.k);
            if (!POSUtil.checkDrawerAssignment(this.k, this.j)) {
                return;
            }
            DrawerUtil.kickDrawer();
            PayoutDialog payoutDialog = new PayoutDialog((Dialog)this, this.j, this.k);
            payoutDialog.open();
            this.refreshReport();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private void n() {
        try {
            JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
            List<User> list = UserDAO.getInstance().findAll();
            JXDatePicker jXDatePicker = UiUtil.getCurrentMonthStart();
            JXDatePicker jXDatePicker2 = UiUtil.getCurrentMonthEnd();
            jPanel.add((Component)new JLabel(POSConstants.SELECT_USER + ":"), "grow");
            JComboBox jComboBox = new JComboBox(new ListComboBoxModel(list));
            jPanel.add(jComboBox, "grow, wrap");
            jPanel.add((Component)new JLabel(POSConstants.FROM + ":"), "grow");
            jPanel.add((Component)jXDatePicker, "wrap");
            jPanel.add((Component)new JLabel(POSConstants.TO_), "grow");
            jPanel.add((Component)jXDatePicker2);
            int n = JOptionPane.showOptionDialog(Application.getPosWindow(), jPanel, POSConstants.SELECT_CRIETERIA, 2, 3, null, null, null);
            if (n != 0) {
                return;
            }
            GratuityDAO gratuityDAO = new GratuityDAO();
            TipsCashoutReport tipsCashoutReport = gratuityDAO.createReport(jXDatePicker.getDate(), jXDatePicker2.getDate(), (User)jComboBox.getSelectedItem());
            TipsCashoutReportDialog tipsCashoutReportDialog = new TipsCashoutReportDialog(tipsCashoutReport);
            tipsCashoutReportDialog.setSize(400, 600);
            tipsCashoutReportDialog.open();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private void o() {
        try {
            if (!this.j.isClockedIn().booleanValue()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "You are not clockd in.\n Please clock in first to close drawer.");
                return;
            }
            DrawerUtil.kickDrawer();
            DrawerAssignmentAction drawerAssignmentAction = new DrawerAssignmentAction(this.k, this.j);
            drawerAssignmentAction.execute();
            this.b = CashDrawerDAO.getInstance().get(this.b.getId());
            this.refreshReport();
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    private void p() {
        try {
            if (!this.j.isClockedIn().booleanValue()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "You are not clockd in.\n Please clock in first to staff bank.");
                return;
            }
            StaffBankCloseAction staffBankCloseAction = new StaffBankCloseAction(this.b, this.j);
            staffBankCloseAction.execute();
            this.b = CashDrawerDAO.getInstance().get(this.b.getId());
            this.refreshReport();
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    public void createReport(boolean bl) throws Exception {
        Object object;
        this.o.removeAll();
        if (bl || this.b.getReportTime() == null) {
            object = new CashDrawerReportService(this.b);
            ((CashDrawerReportService)object).populateReport();
        }
        this.u = PosPrintService.populateTerminalStatusReport(this.b);
        object = new TicketReceiptView(this.u);
        ((TicketReceiptView)object).setZoom(1.25f);
        this.o.add(((TicketReceiptView)object).getReportPanel());
        this.o.revalidate();
        this.o.repaint();
    }
}

