/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.IconFactory;
import com.floreantpos.PosException;
import com.floreantpos.main.Application;
import com.floreantpos.model.ComboGroup;
import com.floreantpos.model.ComboTicketItem;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.ModifiableTicketItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.base.BaseTicketItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ScrollableFlowPanel;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.ticket.MultiLineTableCellRenderer;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionDialog;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionModel;
import com.floreantpos.ui.views.order.multipart.PizzaModifierSelectionDialog;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.jidesoft.swing.SimpleScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.hibernate.Session;

public class ComboTicketItemSelectionDialog
extends OkCancelOptionDialog {
    private JPanel a;
    private ScrollableFlowPanel b;
    private ScrollableFlowPanel c;
    private Map<String, TicketItem> d = new LinkedHashMap<String, TicketItem>();
    private Map<String, List<MenuItem>> e = new HashMap<String, List<MenuItem>>();
    private MenuItem f;
    private ComboTicketItem g;
    private ComboGroup h;
    private JTable i;
    private PosButton j;
    private PosButton k;
    private PosButton l;

    public ComboTicketItemSelectionDialog(MenuItem menuItem, TicketItem ticketItem) {
        super((Frame)Application.getPosWindow(), true);
        this.g = (ComboTicketItem)ticketItem;
        this.f = menuItem;
        this.a();
        this.c();
        this.e();
    }

    private void a() {
        this.setOkButtonText("DONE");
        this.setCaption(this.f + " - Select combo items");
        this.getContentPanel().setBorder(new EmptyBorder(0, 10, 0, 10));
        JPanel jPanel = new JPanel(new BorderLayout());
        this.a = new JPanel((LayoutManager)new MigLayout("fill"));
        this.b = new ScrollableFlowPanel(1);
        PosScrollPane posScrollPane = new PosScrollPane(this.b, 20, 31);
        posScrollPane.getVerticalScrollBar().setPreferredSize(PosUIManager.getSize(60, 0));
        posScrollPane.setBorder(null);
        this.a.add((Component)posScrollPane, "grow,span");
        jPanel.add((Component)this.a, "Center");
        this.getContentPanel().add((Component)jPanel, "Center");
        this.i = new JTable();
        this.i.setRowHeight(40);
        this.i.setModel(new ComboTicketItemTableModel());
        this.i.setTableHeader(null);
        this.i.setDefaultRenderer(Object.class, new MultiLineTableCellRenderer());
        this.i.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                TicketItem ticketItem = ComboTicketItemSelectionDialog.this.b();
                boolean bl = ticketItem != null && ComboTicketItemSelectionDialog.this.a(ticketItem);
                ComboTicketItemSelectionDialog.this.j.setEnabled(bl);
                ComboTicketItemSelectionDialog.this.k.setEnabled(bl);
                ComboTicketItemSelectionDialog.this.l.setEnabled(bl);
                ComboTicketItemSelectionDialog.this.j.setText("...");
                ComboTicketItemSelectionDialog.this.j.setEnabled(bl);
                if (ticketItem == null) {
                    return;
                }
                double d = ticketItem.getQuantity();
                ComboTicketItemSelectionDialog.this.updateQuantity(d);
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.i);
        jScrollPane.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(5, 0, 2, 3), jScrollPane.getBorder()));
        jScrollPane.setPreferredSize(PosUIManager.getSize(250, 0));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        TitledBorder titledBorder = new TitledBorder("Selected combo items");
        titledBorder.setTitleJustification(2);
        jPanel2.setBorder(titledBorder);
        jPanel2.add(jScrollPane);
        this.getContentPanel().add((Component)jPanel2, "West");
        int n = PosUIManager.getSize(30);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new MigLayout("fillx,ins 2 0 2 0", "[" + n + "px][grow][" + n + "px]", "[" + n + "]"));
        this.k = new PosButton();
        this.k.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketItem ticketItem = ComboTicketItemSelectionDialog.this.b();
                if (ticketItem == null) {
                    return;
                }
                if (!ComboTicketItemSelectionDialog.this.a(ticketItem)) {
                    return;
                }
                double d = ticketItem.getQuantity();
                ticketItem.setQuantity(d + 1.0);
                if (!ComboTicketItemSelectionDialog.this.a(ticketItem, d)) {
                    return;
                }
                ComboTicketItemSelectionDialog.this.updateQuantity(ticketItem.getQuantity());
            }
        });
        this.j = new PosButton("...");
        this.j.setFont(new Font(this.j.getFont().getName(), 1, 20));
        this.j.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketItem ticketItem = ComboTicketItemSelectionDialog.this.b();
                if (ticketItem == null) {
                    return;
                }
                if (!ComboTicketItemSelectionDialog.this.a(ticketItem)) {
                    return;
                }
                NumberSelectionDialog2 numberSelectionDialog2 = new NumberSelectionDialog2();
                numberSelectionDialog2.setTitle("Enter quantity");
                numberSelectionDialog2.setFloatingPoint(false);
                numberSelectionDialog2.pack();
                numberSelectionDialog2.open();
                if (numberSelectionDialog2.isCanceled()) {
                    return;
                }
                double d = (int)numberSelectionDialog2.getValue();
                if (d <= 0.0) {
                    return;
                }
                double d2 = ticketItem.getQuantity();
                ticketItem.setQuantity(d);
                if (!ComboTicketItemSelectionDialog.this.a(ticketItem, d2)) {
                    return;
                }
                ComboTicketItemSelectionDialog.this.updateQuantity(ticketItem.getQuantity());
            }
        });
        this.l = new PosButton();
        this.l.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketItem ticketItem = ComboTicketItemSelectionDialog.this.b();
                if (ticketItem == null) {
                    return;
                }
                if (!ComboTicketItemSelectionDialog.this.a(ticketItem)) {
                    return;
                }
                double d = ticketItem.getQuantity();
                if (d == 1.0) {
                    return;
                }
                ticketItem.setQuantity(d - 1.0);
                if (!ComboTicketItemSelectionDialog.this.a(ticketItem, d)) {
                    return;
                }
                ComboTicketItemSelectionDialog.this.updateQuantity(ticketItem.getQuantity());
            }
        });
        this.k.setIcon(IconFactory.getIcon("/ui_icons/", "plus_32.png"));
        this.l.setIcon(IconFactory.getIcon("/ui_icons/", "minus_32.png"));
        jPanel3.add(this.l);
        jPanel3.add((Component)this.j, "grow");
        jPanel3.add(this.k);
        jPanel2.add((Component)jPanel3, "South");
        this.c = new ScrollableFlowPanel(1);
        SimpleScrollPane simpleScrollPane = new SimpleScrollPane((Component)this.c);
        simpleScrollPane.setBorder(null);
        simpleScrollPane.setHorizontalScrollBarPolicy(30);
        simpleScrollPane.setVerticalScrollBarPolicy(20);
        simpleScrollPane.setViewportView((Component)this.c);
        JPanel jPanel4 = new JPanel((LayoutManager)new MigLayout("fill"));
        TitledBorder titledBorder2 = new TitledBorder("Group");
        titledBorder2.setTitleJustification(2);
        jPanel4.setBorder(titledBorder2);
        jPanel4.setPreferredSize(PosUIManager.getSize(0, 110));
        jPanel4.add((Component)simpleScrollPane, "grow");
        jPanel.add((Component)jPanel4, "North");
        PosButton posButton = new PosButton("MODIFY");
        posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketItem ticketItem = ComboTicketItemSelectionDialog.this.b();
                if (ticketItem == null) {
                    return;
                }
                ticketItem.setTicket(OrderView.getInstance().getCurrentTicket());
                if (ticketItem instanceof ModifiableTicketItem || ticketItem.isPizzaType().booleanValue()) {
                    ComboTicketItemSelectionDialog.this.openModifierDialog(ticketItem);
                    ticketItem.setTicket(null);
                    ComboTicketItemSelectionDialog.this.e();
                }
            }
        });
        this.getButtonPanel().add((Component)posButton, 0);
    }

    private boolean a(TicketItem ticketItem) {
        return ticketItem.getGroupId() != null;
    }

    private boolean a(TicketItem ticketItem, double d) {
        if (ticketItem.getGroupId() == null) {
            return false;
        }
        if (this.f.getComboGroups() != null) {
            for (ComboGroup object : this.f.getComboGroups()) {
                if (!object.getId().equals(ticketItem.getGroupId())) continue;
                this.h = object;
                this.a(this.h);
                break;
            }
        }
        int n = 0;
        for (TicketItem ticketItem2 : this.d.values()) {
            if (!this.h.getId().equals(ticketItem2.getGroupId())) continue;
            n = (int)((double)n + ticketItem2.getQuantity());
        }
        if (n > this.h.getMaxQuantity()) {
            ticketItem.setQuantity(d);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Maximum limit is : " + this.h.getMaxQuantity());
            return false;
        }
        return true;
    }

    protected void updateQuantity(double d) {
        this.j.setText(NumberUtil.trimDecilamIfNotNeeded(d));
        this.i.repaint();
    }

    private TicketItem b() {
        int n = this.i.getSelectedRow();
        if (n == -1) {
            return null;
        }
        int n2 = this.i.convertRowIndexToModel(n);
        ITicketItem iTicketItem = (ITicketItem)((ComboTicketItemTableModel)this.i.getModel()).getRowData(n2);
        TicketItem ticketItem = null;
        if (iTicketItem instanceof TicketItem) {
            ticketItem = (TicketItem)iTicketItem;
        } else if (iTicketItem instanceof TicketItemModifier) {
            TicketItemModifier ticketItemModifier = (TicketItemModifier)iTicketItem;
            ticketItem = ticketItemModifier.getTicketItem();
        }
        return ticketItem;
    }

    public void openModifierDialog(TicketItem ticketItem) {
        try {
            ArrayList arrayList;
            Ticket ticket = ticketItem.getTicket();
            MenuItem menuItem = ticketItem.getMenuItem();
            MenuItemDAO.getInstance().initialize(menuItem);
            List<TicketItemModifier> list = ticketItem.getTicketItemModifiers();
            if (list == null) {
                list = new ArrayList<TicketItemModifier>();
            }
            TicketItem ticketItem2 = ticketItem.clone();
            boolean bl = ticketItem.isPizzaType();
            if (bl) {
                arrayList = new PizzaModifierSelectionDialog(ticket, ticketItem2, menuItem, true);
                ((POSDialog)((Object)arrayList)).openFullScreen();
                if (((POSDialog)((Object)arrayList)).isCanceled()) {
                    return;
                }
                TicketItemModifier ticketItemModifier = ticketItem2.getSizeModifier();
                ticketItemModifier.setTicketItem(ticketItem);
                ticketItem.setSizeModifier(ticketItemModifier);
                ticketItem.setQuantity(ticketItem2.getQuantity());
                ticketItem.setUnitPrice(ticketItem2.getUnitPrice());
            } else {
                arrayList = new ModifierSelectionDialog(new ModifierSelectionModel(ticket, ticketItem2, menuItem));
                ((POSDialog)((Object)arrayList)).open();
                if (((POSDialog)((Object)arrayList)).isCanceled()) {
                    return;
                }
            }
            arrayList = ticketItem2.getTicketItemModifiers();
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            list.clear();
            for (TicketItemModifier ticketItemModifier : arrayList) {
                ticketItemModifier.setTicketItem(ticketItem);
                ticketItem.addToticketItemModifiers(ticketItemModifier);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private void c() {
        Serializable serializable;
        Object object;
        List<TicketItem> list = this.g.getComboItems();
        if (list != null) {
            object = list.iterator();
            while (object.hasNext()) {
                serializable = object.next();
                if (((BaseTicketItem)serializable).getGroupId() == null) continue;
                this.d.put(((BaseTicketItem)serializable).getMenuItemId(), (TicketItem)serializable);
            }
        }
        if (this.f.isVariant().booleanValue()) {
            this.f = this.f.getParentMenuItem();
            MenuItemDAO.getInstance().initialize(this.f);
        }
        if ((object = this.f.getComboGroups()) != null) {
            serializable = PosUIManager.getSize(115, 60);
            ButtonGroup buttonGroup = new ButtonGroup();
            boolean bl = true;
            Object object2 = object.iterator();
            while (object2.hasNext()) {
                ComboGroup comboGroup = (ComboGroup)object2.next();
                ComboGroupButton comboGroupButton = new ComboGroupButton(comboGroup);
                comboGroupButton.setSelected(bl);
                comboGroupButton.setPreferredSize((Dimension)serializable);
                this.c.add(comboGroupButton);
                List<MenuItem> list2 = comboGroup.getItems();
                try {
                    if (list2 != null) {
                        for (MenuItem menuItem : list2) {
                            TicketItem ticketItem = this.d.get(menuItem.getId());
                            if (ticketItem == null) continue;
                            ticketItem.setMenuItem(menuItem);
                        }
                        this.e.put(comboGroup.getId(), list2);
                    }
                }
                catch (PosException posException) {
                    posException.printStackTrace();
                }
                buttonGroup.add(comboGroupButton);
                bl = false;
            }
            if (object != null && object.size() > 0) {
                this.h = (ComboGroup)object.get(0);
                this.a(this.h);
                object2 = BorderFactory.createTitledBorder(this.h.getName() + " Min:" + this.h.getMinQuantity() + " Max:" + this.h.getMaxQuantity());
                ((TitledBorder)object2).setTitleJustification(2);
                this.a.setBorder((Border)object2);
            } else {
                object2 = BorderFactory.createTitledBorder("-");
                ((TitledBorder)object2).setTitleJustification(2);
                this.a.setBorder((Border)object2);
            }
        }
    }

    private void a(ComboGroup comboGroup) {
        try {
            this.b.getContentPane().removeAll();
            Dimension dimension = PosUIManager.getSize(115, 80);
            if (comboGroup == null) {
                return;
            }
            List<MenuItem> list = this.e.get(comboGroup.getId());
            if (list != null) {
                for (MenuItem menuItem : list) {
                    MenuItemButton menuItemButton = new MenuItemButton(menuItem);
                    TicketItem ticketItem = this.d.get(menuItem.getId());
                    if (ticketItem != null) {
                        menuItemButton.setSelected(true);
                    }
                    this.b.getContentPane().add(menuItemButton);
                    menuItemButton.setPreferredSize(dimension);
                }
            }
            this.b.getContentPane().revalidate();
            this.b.getContentPane().repaint();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this, posException.getLocalizedMessage(), posException);
        }
    }

    @Override
    public void doOk() {
        if (!this.d()) {
            return;
        }
        List<TicketItem> list = this.g.getComboItems();
        if (list != null) {
            Iterator<TicketItem> iterator = list.iterator();
            while (iterator.hasNext()) {
                TicketItem ticketItem = iterator.next();
                if (ticketItem.getGroupId() == null) continue;
                iterator.remove();
            }
        }
        for (TicketItem ticketItem : this.d.values()) {
            ticketItem.setParentTicketItem(this.g);
            ticketItem.setTicket(null);
            this.g.addTocomboItems(ticketItem);
        }
        this.setCanceled(false);
        this.dispose();
    }

    private boolean d() {
        List<ComboGroup> list = this.f.getComboGroups();
        if (list == null) {
            return true;
        }
        for (ComboGroup comboGroup : list) {
            int n = 0;
            for (TicketItem ticketItem : this.d.values()) {
                if (!comboGroup.getId().equals(ticketItem.getGroupId())) continue;
                n = (int)((double)n + ticketItem.getQuantity());
            }
            if (n >= comboGroup.getMinQuantity()) continue;
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select minimum " + comboGroup.getMinQuantity() + " quantity from group " + comboGroup.getName());
            this.a(comboGroup);
            return false;
        }
        return true;
    }

    private void e() {
        ComboTicketItemTableModel comboTicketItemTableModel = (ComboTicketItemTableModel)this.i.getModel();
        ArrayList<ITicketItem> arrayList = new ArrayList<ITicketItem>();
        List<TicketItem> list = this.g.getComboItems();
        if (list != null) {
            for (TicketItem ticketItem : list) {
                if (ticketItem.getGroupId() != null) continue;
                arrayList.add(ticketItem);
            }
        }
        arrayList.addAll(this.d.values());
        comboTicketItemTableModel.setRows((List<ITicketItem>)arrayList);
    }

    @Override
    public void doCancel() {
        this.d.clear();
        this.setCanceled(true);
        this.dispose();
    }

    public Collection<TicketItem> getSelectedMenuItems() {
        return this.d.values();
    }

    private boolean f() {
        int n = 1;
        for (TicketItem ticketItem : this.d.values()) {
            if (!this.h.getId().equals(ticketItem.getGroupId())) continue;
            n = (int)((double)n + ticketItem.getQuantity());
        }
        return n <= this.h.getMaxQuantity();
    }

    public boolean addComboItem(MenuItem menuItem) {
        Ticket ticket = OrderView.getInstance().getCurrentTicket();
        TicketItem ticketItem = menuItem.convertToTicketItem(ticket, 1.0);
        ticketItem.setMenuItem(menuItem);
        ticketItem.setTicket(ticket);
        if (menuItem.isPizzaType().booleanValue()) {
            PizzaModifierSelectionDialog pizzaModifierSelectionDialog = new PizzaModifierSelectionDialog(ticket, ticketItem, menuItem, false);
            pizzaModifierSelectionDialog.openFullScreen();
            if (pizzaModifierSelectionDialog.isCanceled()) {
                return false;
            }
        } else if (menuItem.hasMandatoryModifiers()) {
            ModifierSelectionDialog modifierSelectionDialog = new ModifierSelectionDialog(new ModifierSelectionModel(ticket, ticketItem, menuItem));
            modifierSelectionDialog.open();
            if (modifierSelectionDialog.isCanceled()) {
                return false;
            }
        }
        this.d.put(menuItem.getId(), ticketItem);
        ticketItem.setMenuItemId(menuItem.getId());
        ticketItem.setGroupId(this.h.getId());
        ticketItem.setName(menuItem.getName());
        ticketItem.setTicket(null);
        ticketItem.setQuantity(1.0);
        return true;
    }

    public class ComboTicketItemTableModel
    extends ListTableModel<ITicketItem> {
        public ComboTicketItemTableModel() {
            super(new String[]{"Item"});
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ITicketItem iTicketItem = (ITicketItem)this.rows.get(n);
            switch (n2) {
                case 0: {
                    return iTicketItem.getItemQuantityDisplay() + "x " + iTicketItem.getNameDisplay();
                }
            }
            return null;
        }

        @Override
        public void setRows(List<ITicketItem> list) {
            ArrayList<ITicketItem> arrayList = new ArrayList<ITicketItem>();
            for (ITicketItem iTicketItem : list) {
                TicketItem ticketItem;
                arrayList.add(iTicketItem);
                if (!(iTicketItem instanceof TicketItem) || !(ticketItem = (TicketItem)iTicketItem).isHasModifiers().booleanValue() || ticketItem.getTicketItemModifiers() == null) continue;
                arrayList.addAll(ticketItem.getTicketItemModifiers());
            }
            super.setRows(arrayList);
        }
    }

    private class ComboGroupButton
    extends POSToggleButton
    implements ActionListener {
        ComboGroup a;

        ComboGroupButton(ComboGroup comboGroup) {
            this.a = comboGroup;
            this.setText("<html><body><center>" + comboGroup.getName() + "</center></body></html>");
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ComboTicketItemSelectionDialog.this.a.setBorder(BorderFactory.createTitledBorder(this.a.getName() + " Min:" + this.a.getMinQuantity() + " Max:" + this.a.getMaxQuantity()));
            ComboTicketItemSelectionDialog.this.a(this.a);
            ComboTicketItemSelectionDialog.this.h = this.a;
        }
    }

    private class MenuItemButton
    extends POSToggleButton
    implements ActionListener {
        private int c = 100;
        MenuItem a;

        MenuItemButton(MenuItem menuItem) {
            Color color;
            this.a = menuItem;
            this.setFocusable(false);
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            this.c = PosUIManager.getSize(100);
            ImageIcon imageIcon = menuItem.getImage();
            if (imageIcon != null) {
                if (menuItem.isShowImageOnly().booleanValue()) {
                    this.setIcon(imageIcon);
                } else {
                    this.setIcon(imageIcon);
                    this.setText("<html><body><center>" + menuItem.getDisplayName() + "</center></body></html>");
                }
            } else {
                this.setText("<html><body><center>" + menuItem.getName() + "</center></body></html>");
            }
            Color color2 = menuItem.getButtonColor();
            if (color2 != null) {
                this.setBackground(color2);
            }
            if ((color = menuItem.getTextColor()) != null) {
                this.setForeground(color);
            }
            this.setPreferredSize(new Dimension(this.c, this.c));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            block7: {
                if (this.isSelected()) {
                    if (!ComboTicketItemSelectionDialog.this.f()) {
                        this.setSelected(false);
                        POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Maximum limit is : " + ComboTicketItemSelectionDialog.this.h.getMaxQuantity());
                        return;
                    }
                    Session session = null;
                    try {
                        session = MenuItemDAO.getInstance().getSession();
                        this.a = (MenuItem)session.merge((Object)this.a);
                        if (!ComboTicketItemSelectionDialog.this.addComboItem(this.a)) {
                            this.setSelected(false);
                            return;
                        }
                        break block7;
                    }
                    finally {
                        MenuItemDAO.getInstance().closeSession(session);
                    }
                }
                TicketItem ticketItem = (TicketItem)ComboTicketItemSelectionDialog.this.d.get(this.a.getId());
                if (ticketItem != null) {
                    ComboTicketItemSelectionDialog.this.d.remove(this.a.getId());
                }
            }
            ComboTicketItemSelectionDialog.this.e();
        }
    }
}

