/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.Discount;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.NumberUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;

public class DiscountListDialog
extends POSDialog
implements ActionListener {
    private JPanel a;
    private PosButton b;
    private PosButton c;
    private PosButton d;
    private PosButton e;
    private PosButton f;
    private JTable g;
    private List<Ticket> h;
    private DiscountViewTableModel i;
    private DefaultListSelectionModel j;
    private boolean k = false;

    public DiscountListDialog(List<Ticket> list) {
        this.d();
        this.h = list;
        this.setSize(700, 500);
        this.i = new DiscountViewTableModel();
        this.g.setModel(this.i);
        this.j = new DefaultListSelectionModel();
        this.j.setSelectionMode(0);
        this.g.setSelectionModel(this.j);
        this.d.setActionCommand("scrollUP");
        this.e.setActionCommand("scrollDown");
        this.d.addActionListener(this);
        this.e.addActionListener(this);
        this.setContentPane(this.a);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.b);
        this.b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DiscountListDialog.this.b();
            }
        });
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DiscountListDialog.this.c();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                DiscountListDialog.this.c();
            }
        });
        this.a.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DiscountListDialog.this.c();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.f.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DiscountListDialog.this.a();
            }
        });
    }

    private void a() {
        try {
            int n = this.j.getLeadSelectionIndex();
            if (n < 0) {
                POSMessageDialog.showError(this, POSConstants.SELECT_ITEM_TO_DELETE);
                return;
            }
            if (ConfirmDeleteDialog.showMessage(this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            Object object = this.i.get(n);
            this.k = this.i.delete((TicketCoupon)object);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, Messages.getString("DiscountListDialog.2"), exception);
        }
    }

    private void b() {
        this.h = null;
        this.setCanceled(false);
        this.dispose();
    }

    private void c() {
        this.h = null;
        this.setCanceled(true);
        this.dispose();
    }

    private void d() {
        this.a = new JPanel();
        this.a.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(10, 10, 10, 10), -1, -1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.a.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 2, 1, 3, 1, null, null, null, 0, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 5, 5));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.f = new PosButton();
        this.f.setIcon(IconFactory.getIcon("/ui_icons/", "delete.png"));
        this.f.setPreferredSize(new Dimension(140, 50));
        this.f.setText(Messages.getString("DiscountListDialog.5"));
        jPanel2.add(this.f);
        this.b = new PosButton();
        this.b.setIcon(IconFactory.getIcon("/ui_icons/", "finish.png"));
        this.b.setPreferredSize(new Dimension(120, 50));
        this.b.setText(POSConstants.OK);
        jPanel2.add(this.b);
        this.c = new PosButton();
        this.c.setIcon(IconFactory.getIcon("/ui_icons/", "cancel.png"));
        this.c.setPreferredSize(new Dimension(120, 50));
        this.c.setText(POSConstants.CANCEL);
        jPanel2.add(this.c);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.a.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 5, 5, null, new Dimension(458, 310), null, 0, false));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel3.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 5, 5, null, null, null, 0, false));
        this.g = new JTable();
        jScrollPane.setViewportView(this.g);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new FormLayout("fill:p:grow", "center:d:grow,top:4dlu:noGrow,center:d:grow"));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 3, 5, 5, null, null, null, 0, false));
        this.d = new PosButton();
        this.d.setIcon(IconFactory.getIcon("/ui_icons/", "up.png"));
        this.d.setPreferredSize(new Dimension(50, 50));
        this.d.setText("");
        CellConstraints cellConstraints = new CellConstraints();
        jPanel4.add((Component)this.d, cellConstraints.xy(1, 1, CellConstraints.CENTER, CellConstraints.BOTTOM));
        this.e = new PosButton();
        this.e.setIcon(IconFactory.getIcon("/ui_icons/", "down.png"));
        this.e.setPreferredSize(new Dimension(50, 50));
        this.e.setText("");
        jPanel4.add((Component)this.e, cellConstraints.xy(1, 3, CellConstraints.CENTER, CellConstraints.TOP));
    }

    public JComponent $$$getRootComponent$$$() {
        return this.a;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("scrollUP".equals(actionEvent.getActionCommand())) {
            int n = this.j.getLeadSelectionIndex();
            n = n <= 0 ? 0 : --n;
            this.j.setLeadSelectionIndex(n);
            Rectangle rectangle = this.g.getCellRect(n, 0, false);
            this.g.scrollRectToVisible(rectangle);
        } else if ("scrollDown".equals(actionEvent.getActionCommand())) {
            int n = this.j.getLeadSelectionIndex();
            if (n < 0) {
                n = 0;
            } else if (n < this.i.getRowCount() - 1) {
                ++n;
            }
            this.j.setLeadSelectionIndex(n);
            Rectangle rectangle = this.g.getCellRect(n, 0, false);
            this.g.scrollRectToVisible(rectangle);
        }
    }

    public boolean isModified() {
        return this.k;
    }

    class TicketCoupon {
        private Ticket b;
        private Object c;

        public TicketCoupon() {
        }

        public TicketCoupon(Ticket ticket, Object object) {
            this.b = ticket;
            this.c = object;
        }

        public Object getDiscountObject() {
            return this.c;
        }

        public void setDiscountObject(Object object) {
            this.c = object;
        }

        public Ticket getTicket() {
            return this.b;
        }

        public void setTicket(Ticket ticket) {
            this.b = ticket;
        }

        public boolean equals(Object object) {
            if (!(object instanceof TicketCoupon)) {
                return false;
            }
            TicketCoupon ticketCoupon = (TicketCoupon)object;
            return this.c.equals(ticketCoupon.c);
        }
    }

    class DiscountViewTableModel
    extends AbstractTableModel {
        String[] a = new String[]{Messages.getString("DiscountListDialog.18"), Messages.getString("DiscountListDialog.19"), Messages.getString("DiscountListDialog.20")};
        ArrayList b = new ArrayList();

        DiscountViewTableModel() {
            for (Ticket ticket : DiscountListDialog.this.h) {
                List<TicketDiscount> list = ticket.getDiscounts();
                if (list == null) continue;
                for (TicketDiscount ticketDiscount : list) {
                    TicketCoupon ticketCoupon = new TicketCoupon(ticket, ticketDiscount);
                    this.b.add(ticketCoupon);
                }
            }
        }

        @Override
        public int getRowCount() {
            return this.b.size();
        }

        @Override
        public int getColumnCount() {
            return this.a.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.a[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            TicketCoupon ticketCoupon = (TicketCoupon)this.b.get(n);
            Object object = ticketCoupon.getDiscountObject();
            switch (n2) {
                case 0: {
                    if (object instanceof TicketDiscount) {
                        return ((TicketDiscount)object).getName();
                    }
                    return null;
                }
                case 1: {
                    if (object instanceof TicketDiscount) {
                        return Discount.COUPON_TYPE_NAMES[((TicketDiscount)object).getType()];
                    }
                    return null;
                }
                case 2: {
                    if (object instanceof TicketDiscount) {
                        return NumberUtil.formatNumber(((TicketDiscount)object).getValue());
                    }
                    return null;
                }
            }
            return null;
        }

        public boolean delete(TicketCoupon ticketCoupon) {
            Ticket ticket = ticketCoupon.getTicket();
            Object object = ticketCoupon.getDiscountObject();
            if (object instanceof TicketCoupon) {
                boolean bl = ticket.getDiscounts().remove(object);
                this.b.remove(ticketCoupon);
                this.fireTableDataChanged();
                return bl;
            }
            return false;
        }

        public Object get(int n) {
            return this.b.get(n);
        }
    }
}

