/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PrinterIsNotConfiguredException;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.print.PosPrintService;
import com.floreantpos.report.CashDrawerTransactionReportModel;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.services.report.StoreSessionSummaryReportService;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.DetailReportDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.TicketReceiptView;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;

public class StoreSessionSummaryReportDialog
extends POSDialog {
    private TitlePanel a;
    private CashDrawer b;
    private PosButton c;
    private JPanel d;
    private PosButton e;
    private PosButton f;
    private StoreSession g;
    private JPanel h;
    private JasperPrint i;
    private JasperPrint j;

    public StoreSessionSummaryReportDialog(StoreSession storeSession) {
        super(POSUtil.getFocusedWindow());
        this.setModal(true);
        this.g = storeSession;
        this.a();
        this.setSize(PosUIManager.getSize(800, 670));
    }

    private void a() {
        this.setLayout(new BorderLayout(5, 5));
        this.a = new TitlePanel();
        this.add((Component)this.a, "North");
        this.h = new JPanel(new BorderLayout());
        this.add(new PosScrollPane(this.h));
        this.d = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,ins 5 5 5 5,wrap 4", "[grow]", ""));
        this.f = new PosButton(Messages.getString("DrawerPullReportDialog.8"));
        this.e = new PosButton(POSConstants.SAVE_BUTTON_TEXT);
        this.d.add((Component)new JSeparator(), "grow,span,wrap");
        this.c = new PosButton(POSConstants.DETAILS.toUpperCase());
        this.d.add((Component)this.f, "grow");
        this.d.add((Component)this.c, "grow");
        this.d.add((Component)this.e, "grow");
        this.add((Component)this.d, "South");
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StoreSessionSummaryReportDialog.this.b();
            }
        });
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StoreSessionSummaryReportDialog.this.d();
            }
        });
        this.f.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StoreSessionSummaryReportDialog.this.e();
            }
        });
    }

    private void b() {
        try {
            this.c();
            DetailReportDialog detailReportDialog = new DetailReportDialog(this.i);
            detailReportDialog.setTitle("Store Session Detail Report");
            detailReportDialog.updateView();
            detailReportDialog.open();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void c() throws JRException {
        ArrayList<PosTransaction> arrayList = new ArrayList<PosTransaction>();
        if (this.b == null) {
            return;
        }
        List<PosTransaction> list = PosTransactionDAO.getInstance().findTransactionsForSession(this.g.getId());
        arrayList.addAll(list);
        CashDrawerTransactionReportModel cashDrawerTransactionReportModel = new CashDrawerTransactionReportModel();
        cashDrawerTransactionReportModel.setItems(arrayList);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Store store = Application.getInstance().getStore();
        hashMap.put("headerLine1", store.getName());
        hashMap.put("headerLine2", store.getAddressLine1());
        hashMap.put("receiptType", "Store Session Detail Report");
        Date date = this.g != null ? this.g.getCloseTime() : new Date();
        String string = "<b>From:</b> " + DateUtil.formatFullDateAndTimeAsString(this.b.getStartTime()) + " <b>To:</b> " + DateUtil.formatFullDateAndTimeAsString(date != null ? date : new Date());
        hashMap.put("startDate", string);
        hashMap.put("status", arrayList == null || arrayList.isEmpty() ? "No transaction found." : null);
        JasperReport jasperReport = ReportUtil.getReport("server_details_report");
        this.i = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)cashDrawerTransactionReportModel));
    }

    private void d() {
        this.dispose();
    }

    @Override
    public void setTitle(String string) {
        this.a.setTitle(string);
        super.setTitle(VersionInfo.getAppName());
    }

    private void e() {
        try {
            PosPrintService.printReportByJasperPrint(this.j);
        }
        catch (PrinterIsNotConfiguredException printerIsNotConfiguredException) {
            POSMessageDialog.showError(this, Messages.getString("DrawerPullReportDialog.122") + printerIsNotConfiguredException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, Messages.getString("DrawerPullReportDialog.122") + exception.getMessage(), exception);
        }
    }

    public void refreshReport() throws Exception {
        this.h.removeAll();
        StoreSessionSummaryReportService storeSessionSummaryReportService = new StoreSessionSummaryReportService(this.g);
        this.b = storeSessionSummaryReportService.populateStoreSessionSummaryReport();
        this.j = PosPrintService.populateStoreSessionSummaryReportParameters(this.b);
        TicketReceiptView ticketReceiptView = new TicketReceiptView(this.j);
        ticketReceiptView.setZoom(1.25f);
        this.h.add(ticketReceiptView.getReportPanel());
        this.h.revalidate();
        this.h.repaint();
    }
}

