/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.dao.TaxDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.model.TaxForm;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;

public class TaxSelectionDialog
extends POSDialog {
    private JXTable a;
    private BeanTableModel<Tax> b;
    private List<Tax> c;
    private TaxGroup d;

    public TaxSelectionDialog(TaxGroup taxGroup) {
        super(POSUtil.getFocusedWindow(), "");
        this.d = taxGroup;
        this.a();
        List<Tax> list = TaxDAO.getInstance().findAll();
        List<Tax> list2 = null;
        if (taxGroup != null) {
            list2 = taxGroup.getTaxes();
        }
        if (list2 != null) {
            for (Tax tax : list) {
                if (!list2.contains(tax)) continue;
                tax.setEnable(true);
            }
        }
        this.b.setRows(list);
        this.a.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
    }

    private void a() {
        this.setLayout(new BorderLayout(5, 5));
        this.setTitle("Select Tax");
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle("Tax Group: " + this.d.getName());
        this.add((Component)titlePanel, "North");
        this.b = new BeanTableModel<Tax>(Tax.class){

            @Override
            public Object getValueAt(int n, int n2) {
                Tax tax;
                if (n2 == 2 && (tax = (Tax)TaxSelectionDialog.this.b.getRow(n)) != null) {
                    return NumberUtil.trimDecilamIfNotNeeded(tax.getRate()) + "%";
                }
                return super.getValueAt(n, n2);
            }
        };
        this.b.addColumn("", "enable");
        this.b.addColumn(POSConstants.NAME.toUpperCase(), "name");
        this.b.addColumn("RATE", "rate");
        this.a = new JXTable(this.b);
        this.a.setSelectionMode(2);
        this.a.setTableHeader(null);
        this.a.setRowHeight(PosUIManager.getSize(30));
        this.a.setShowGrid(true, false);
        this.a.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    TaxSelectionDialog.this.d();
                } else {
                    TaxSelectionDialog.this.f();
                }
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane((Component)this.a);
        jPanel.add(jScrollPane);
        this.add(jPanel);
        this.resizeColumnWidth((JTable)this.a);
        this.add((Component)this.b(), "South");
    }

    private TransparentPanel b() {
        ExplorerButtonPanel explorerButtonPanel = new ExplorerButtonPanel();
        JButton jButton = explorerButtonPanel.getEditButton();
        JButton jButton2 = explorerButtonPanel.getAddButton();
        JButton jButton3 = new JButton("DONE");
        jButton3.setHorizontalTextPosition(4);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TaxSelectionDialog.this.e();
            }
        });
        JButton jButton4 = new JButton(POSConstants.CANCEL);
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TaxSelectionDialog.this.setCanceled(true);
                TaxSelectionDialog.this.dispose();
            }
        });
        jButton2.setText("New Tax");
        jButton.setText(POSConstants.EDIT);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TaxSelectionDialog.this.d();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Tax tax = new Tax();
                    TaxForm taxForm = new TaxForm(tax);
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)taxForm);
                    beanEditorDialog.open();
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    Tax tax2 = (Tax)taxForm.getBean();
                    TaxSelectionDialog.this.b.addRow(tax2);
                }
                catch (Throwable throwable) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
        jButton3.setBackground(Color.GREEN);
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new MigLayout("center,ins 0 0 5 0", "sg,fill", ""));
        int n = PosUIManager.getSize(40);
        transparentPanel.add((Component)jButton2, "h " + n);
        transparentPanel.add((Component)jButton3, "h " + n);
        transparentPanel.add((Component)jButton4, "h " + n);
        return transparentPanel;
    }

    public void resizeColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth((Integer)this.c().get(i));
        }
    }

    private List c() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(50);
        arrayList.add(250);
        arrayList.add(50);
        return arrayList;
    }

    private void d() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                return;
            }
            n = this.a.convertRowIndexToModel(n);
            Tax tax = this.b.getRow(n);
            this.b.setRow(n, tax);
            TaxForm taxForm = new TaxForm(tax);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)taxForm);
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            this.a.repaint();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void e() {
        try {
            this.c = new ArrayList<Tax>();
            List<Tax> list = this.b.getRows();
            for (Tax tax : list) {
                if (!tax.isEnable().booleanValue()) continue;
                this.c.add(tax);
            }
            this.setCanceled(false);
            this.dispose();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    public List<Tax> getSelectedTaxList() {
        return this.c;
    }

    private void f() {
        Tax tax;
        if (this.a.getSelectedRow() < 0) {
            return;
        }
        int n = this.a.getSelectedRow();
        tax.setEnable((tax = this.b.getRow(n = this.a.convertRowIndexToModel(n))).isEnable() == false);
        this.a.repaint();
    }
}

