/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.actions.EmailSendAction;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.DefaultCustomerListView;
import com.floreantpos.mailservices.MailService;
import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosOptionPane;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.AESencrp;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.mail.util.ByteArrayDataSource;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class TransactionCompletionDialog
extends POSDialog {
    private double a;
    private double b;
    private double c;
    private double d;
    private double e;
    private double f;
    private JLabel g;
    private JLabel h;
    private JLabel i;
    private JLabel j;
    private JLabel k;
    private JLabel l;
    private PosTransaction m;
    private List<PosTransaction> n;
    private boolean o;
    private List<Ticket> p;
    private Customer q;
    private PosButton r;
    private PosButton s;
    private PosButton t;

    public TransactionCompletionDialog(PosTransaction posTransaction) {
        this.m = posTransaction;
        this.o = this.m.isCard();
        this.a();
    }

    public TransactionCompletionDialog(List<PosTransaction> list) {
        this.n = list;
        this.a();
    }

    private void a() {
        this.setTitle(POSConstants.TRANSACTION_COMPLETED);
        this.setLayout((LayoutManager)new MigLayout("align 50% 0%, ins 20", "[]20[]", ""));
        this.add((Component)this.createLabel(Messages.getString("TransactionCompletionDialog.3") + ":", 2), "grow");
        this.h = this.createLabel("0.0", 4);
        this.add((Component)this.h, "span, grow");
        this.add((Component)this.createLabel(Messages.getString("TransactionCompletionDialog.8") + ":", 2), "newline,grow");
        this.g = this.createLabel("0.0", 4);
        this.add((Component)this.g, "span, grow");
        this.add((Component)new JSeparator(), "newline,span, grow");
        this.add((Component)this.createLabel(Messages.getString("TransactionCompletionDialog.14") + ":", 2), "newline,grow");
        this.i = this.createLabel("0.0", 4);
        this.add((Component)this.i, "span, grow");
        this.add((Component)this.createLabel(Messages.getString("TransactionCompletionDialog.19") + ":", 2), "newline,grow");
        this.j = this.createLabel("0.0", 4);
        this.add((Component)this.j, "span, grow");
        this.add((Component)new JSeparator(), "newline,span, grow");
        this.add((Component)this.createLabel(Messages.getString("TransactionCompletionDialog.25") + ":", 2), "newline,grow");
        this.l = this.createLabel("0.0", 4);
        this.add((Component)this.l, "span, grow");
        this.add((Component)new JSeparator(), "newline,span, grow");
        this.add((Component)this.createLabel(Messages.getString("TransactionCompletionDialog.31") + ":", 2), "grow");
        this.k = this.createLabel("0.0", 4);
        this.add((Component)this.k, "span, grow");
        this.add((Component)new JSeparator(), "sg mygroup,newline,span,grow");
        this.r = new PosButton("EMAIL");
        this.r.setAction(new EmailSendAction(){

            @Override
            public Ticket getTicket() {
                return TransactionCompletionDialog.this.m.getTicket();
            }
        });
        this.s = new PosButton(Messages.getString("TransactionCompletionDialog.37"));
        this.s.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TransactionCompletionDialog.this.dispose();
            }
        });
        this.t = new PosButton(Messages.getString("TransactionCompletionDialog.38"));
        this.t.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (TransactionCompletionDialog.this.p != null) {
                        for (Ticket ticket : TransactionCompletionDialog.this.p) {
                            ReceiptPrintService.printTicket(ticket);
                        }
                    } else {
                        ReceiptPrintService.printTransaction(TransactionCompletionDialog.this.m, true, false);
                    }
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("TransactionCompletionDialog.39"), exception);
                }
            }
        });
        PosButton posButton = new PosButton(Messages.getString("TransactionCompletionDialog.40"));
        posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (TransactionCompletionDialog.this.p != null) {
                        for (Ticket ticket : TransactionCompletionDialog.this.p) {
                            ReceiptPrintService.printTicket(ticket);
                        }
                    } else {
                        ReceiptPrintService.printTransaction(TransactionCompletionDialog.this.m, true, true);
                    }
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("TransactionCompletionDialog.41"), exception);
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(this.r);
        if (this.o) {
            jPanel.add((Component)posButton, "newline,skip, h 50");
            jPanel.add((Component)this.t, "skip, h 50");
            jPanel.add((Component)this.s, "skip, h 50");
        } else {
            this.t.setText(Messages.getString("TransactionCompletionDialog.0"));
            jPanel.add((Component)this.t, "skip, h 50");
            jPanel.add((Component)this.s, "skip, h 50");
        }
        this.add((Component)jPanel, "newline, span 2, grow, gaptop 15px");
    }

    private void b() {
        try {
            Object object;
            Ticket ticket = this.m.getTicket();
            if (ticket == null) {
                return;
            }
            String string = ticket.getCustomerId();
            String string2 = null;
            if (string == null) {
                int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "No customer is set for the order. Do you want to set customer?", "Customer selection");
                if (n != 0) {
                    return;
                }
                object = new CustomerSelectorDialog(new DefaultCustomerListView());
                ((CustomerSelectorDialog)object).setCreateNewTicket(false);
                ((CustomerSelectorDialog)object).updateView(true);
                ((POSDialog)object).openUndecoratedFullScreen();
                if (((POSDialog)object).isCanceled()) {
                    return;
                }
                this.q = ((CustomerSelectorDialog)object).getSelectedCustomer();
                string2 = this.q.getEmail().trim();
            } else {
                this.q = CustomerDAO.getInstance().get(string);
                string2 = this.q.getEmail();
            }
            if (StringUtils.isEmpty((String)string2)) {
                string2 = PosOptionPane.showInputDialog("Enter Email Address", "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$", "Invalid email! Please enter valid email.", true);
                if (StringUtils.isEmpty((String)string2)) {
                    POSMessageDialog.showError("Cannot send email without customer email address");
                    return;
                }
                Customer customer = CustomerDAO.getInstance().findByPhoneOrEmail(null, string2);
                if (customer != null) {
                    POSMessageDialog.showError("Email already exists with different customer, please choose a different one.");
                    return;
                }
                this.q.setEmail(string2.trim());
                CustomerDAO.getInstance().saveOrUpdate(this.q);
            }
            ticket.setCustomer(this.q);
            TicketDAO.getInstance().saveOrUpdate(ticket);
            this.m.setTicket(ticket);
            Terminal terminal = Application.getInstance().refreshAndGetTerminal();
            object = terminal.getSmtpHost();
            String string3 = terminal.getSmtpSender();
            String string4 = terminal.getSmtpPassword();
            String string5 = null;
            if (!StringUtils.isEmpty((String)string4)) {
                string5 = AESencrp.decrypt(string4);
            }
            if (StringUtils.isEmpty((String)object)) {
                POSMessageDialog.showError("SMTP Host not found! Please set configuration!");
                return;
            }
            if (StringUtils.isEmpty((String)string3)) {
                POSMessageDialog.showError("Sender email not found! Please set configuration!");
                return;
            }
            if (StringUtils.isEmpty((String)string5)) {
                POSMessageDialog.showError("Password not found! Please set configuration!");
                return;
            }
            byte[] byArray = ReceiptPrintService.createPDFStream(ticket);
            ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(byArray, "application/pdf");
            MailService.sendMail(string2, "Ticket Receipt", "Ticket Receipt", "TICKET_RECEIPT_" + ticket.getId() + ".pdf", byteArrayDataSource);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Order payment receipt successfully sent to \"" + string2 + "\"");
        }
        catch (Exception exception) {
            PosLog.error(TransactionCompletionDialog.class, exception);
        }
    }

    protected JLabel createLabel(String string, int n) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(new Font("Tahoma", 1, 24));
        jLabel.setHorizontalAlignment(n);
        jLabel.setText(string);
        return jLabel;
    }

    public double getTenderedAmount() {
        return this.a;
    }

    public void setTenderedAmount(double d) {
        this.a = d;
    }

    public void updateView() {
        this.h.setText(NumberUtil.formatNumber(this.b));
        this.g.setText(NumberUtil.formatNumber(this.a));
        this.i.setText(NumberUtil.formatNumber(this.c));
        this.j.setText(NumberUtil.formatNumber(this.d));
        this.l.setText(NumberUtil.formatNumber(this.e));
        this.k.setText(NumberUtil.formatNumber(this.f));
    }

    public double getDueAmount() {
        return this.d;
    }

    public void setDueAmount(double d) {
        this.d = d;
    }

    public double getPaidAmount() {
        return this.c;
    }

    public void setPaidAmount(double d) {
        this.c = d;
    }

    public double getTotalAmount() {
        return this.b;
    }

    public void setTotalAmount(double d) {
        this.b = d;
    }

    public double getGratuityAmount() {
        return this.e;
    }

    public void setGratuityAmount(double d) {
        this.e = d;
    }

    public double getChangeAmount() {
        return this.f;
    }

    public void setChangeAmount(double d) {
        this.f = d;
    }

    public void setCompletedTransaction(PosTransaction posTransaction) {
        this.m = posTransaction;
    }

    public boolean isCard() {
        return this.o;
    }

    public void setCard(boolean bl) {
        this.o = bl;
    }

    public void setTickets(List<Ticket> list) {
        this.p = list;
    }

    public List<PosTransaction> getCompletedTransactions() {
        return this.n;
    }
}

