/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.main.Application;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class UserListDialog
extends OkCancelOptionDialog {
    BeanTableModel<User> a;
    JTable b;

    public UserListDialog() {
        super((Frame)Application.getPosWindow(), true);
        this.setTitle(Messages.getString("UserListDialog.0"));
        this.setCaption(Messages.getString("UserListDialog.0"));
        JPanel jPanel = this.getContentPanel();
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.a = new BeanTableModel(User.class);
        this.a.addColumn("Name", "fullName");
        this.b = new JTable(this.a);
        this.b.setRowHeight(PosUIManager.getSize(60));
        this.b.getSelectionModel().setSelectionMode(0);
        jPanel.add(new JScrollPane(this.b));
        this.b.getTableHeader().setPreferredSize(PosUIManager.getSize(0, 40));
        List<User> list = UserDAO.getInstance().findClockedInUsers();
        this.a.addRows(list);
        if (list != null && !list.isEmpty()) {
            this.b.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    public void setUsers(List<User> list) {
        this.a.removeAll();
        this.a.addRows(list);
    }

    public void hideUser(User user) {
        this.a.removeRow(user);
    }

    public User getSelectedUser() {
        return this.a.getRows().get(this.b.getSelectedRow());
    }

    @Override
    public void doOk() {
        int n = this.b.getSelectedRow();
        if (n == -1) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("UserListDialog.4"));
            return;
        }
        this.setCanceled(false);
        this.dispose();
    }
}

