/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.forms;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.Customer;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.PosSmallButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.QwertyKeyPad;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.ImageGalleryDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PosGuiUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;
import org.hibernate.StaleObjectStateException;

public class CustomerForm
extends BeanEditor<Customer> {
    private FixedLengthTextField a;
    private FixedLengthTextField b;
    private FixedLengthTextField c;
    private FixedLengthTextField d;
    private FixedLengthTextField e;
    private JTextArea f;
    private FixedLengthTextField g;
    private FixedLengthTextField h;
    private FixedLengthTextField i;
    private FixedLengthTextField j;
    private FixedLengthTextField k;
    private IntegerTextField l;
    private DoubleTextField m;
    private DoubleTextField n;
    private JCheckBox o;
    private JCheckBox p;
    private JLabel q;
    private PosSmallButton r;
    private PosSmallButton s;
    private JComboBox t;
    private QwertyKeyPad u;
    public boolean isKeypad;
    private ImageResource v;
    private MyOwnFocusTraversalPolicy w;
    private Image x;
    private FixedLengthTextField y;

    public CustomerForm() {
        this.a();
    }

    public CustomerForm(boolean bl) {
        this.isKeypad = bl;
        this.a();
    }

    private void a() {
        this.setOpaque(true);
        this.setLayout((LayoutManager)new MigLayout("fill", "[][][]", ""));
        this.add((Component)this.b(), "top 0");
        this.add((Component)this.c(), "grow");
        this.add((Component)this.d(), "grow, wrap");
        this.u = new QwertyKeyPad();
        if (this.isKeypad) {
            this.add((Component)((Object)this.u), "span, grow");
        }
        this.r.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomerForm.this.doSelectImageFile();
            }
        });
        this.s.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomerForm.this.doClearImage();
            }
        });
        this.enableCustomerFields(false);
        this.callOrderController();
    }

    private JPanel b() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        this.q = new JLabel("");
        this.x = IconFactory.getIcon("/images/", "generic-profile-pic-v2.png").getImage();
        this.q = new JLabel("");
        this.q.setPreferredSize(new Dimension(200, 200));
        this.q.setIcon(new ImageIcon(this.x.getScaledInstance(200, 200, 1)));
        this.q.setIconTextGap(0);
        this.q.setHorizontalAlignment(0);
        jPanel.setBorder(new TitledBorder(null, Messages.getString("CustomerForm.10"), 4, 2, null, null));
        jPanel.add((Component)this.q, "grow,wrap,center");
        this.r = new PosSmallButton();
        this.r.setText(Messages.getString("CustomerForm.44"));
        jPanel.add((Component)this.r, "split 2,center");
        this.s = new PosSmallButton();
        this.s.setText(Messages.getString("CustomerForm.45"));
        jPanel.add(this.s);
        return jPanel;
    }

    private JPanel c() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx", "[][grow]", ""));
        JLabel jLabel = new JLabel(Messages.getString("CustomerForm.0"));
        this.t = new JComboBox();
        this.t.addItem(Messages.getString("CustomerForm.2"));
        this.t.addItem(Messages.getString("CustomerForm.4"));
        this.t.addItem(Messages.getString("CustomerForm.5"));
        this.t.addItem(Messages.getString("CustomerForm.6"));
        this.t.setPreferredSize(new Dimension(100, 0));
        JLabel jLabel2 = new JLabel(Messages.getString("CustomerForm.3"));
        this.a = new FixedLengthTextField(30);
        JLabel jLabel3 = new JLabel(Messages.getString("CustomerForm.11"));
        this.b = new FixedLengthTextField();
        JLabel jLabel4 = new JLabel("DoB (MM-DD-YYYY)");
        this.c = new FixedLengthTextField();
        JLabel jLabel5 = new JLabel(Messages.getString("CustomerForm.16"));
        this.d = new FixedLengthTextField(30);
        JLabel jLabel6 = new JLabel(Messages.getString("CustomerForm.17"));
        this.e = new FixedLengthTextField();
        JLabel jLabel7 = new JLabel(Messages.getString("CustomerForm.8"));
        this.y = new FixedLengthTextField();
        JLabel jLabel8 = new JLabel(Messages.getString("CustomerForm.19"));
        this.k = new FixedLengthTextField();
        JLabel jLabel9 = new JLabel(Messages.getString("CustomerForm.20"));
        this.l = new IntegerTextField();
        this.l.setEditable(false);
        JLabel jLabel10 = new JLabel(Messages.getString("CustomerForm.23"));
        this.m = new DoubleTextField();
        this.m.setText("500.00");
        JLabel jLabel11 = new JLabel(Messages.getString("CustomerForm.25"));
        this.n = new DoubleTextField();
        jPanel.add((Component)jLabel, "right");
        jPanel.add((Component)this.t, "wrap,grow");
        jPanel.add((Component)jLabel2, "right");
        jPanel.add((Component)this.a, "wrap,grow");
        jPanel.add((Component)jLabel3, "right");
        jPanel.add((Component)this.b, "wrap,grow");
        jPanel.add((Component)jLabel4, "right");
        jPanel.add((Component)this.c, "wrap,grow");
        jPanel.add((Component)jLabel5, "right");
        jPanel.add((Component)this.d, "wrap,grow");
        jPanel.add((Component)jLabel6, "right");
        jPanel.add((Component)this.e, "wrap,grow");
        jPanel.add((Component)jLabel7, "right");
        jPanel.add((Component)this.y, "wrap,grow");
        jPanel.add((Component)jLabel8, "right");
        jPanel.add((Component)this.k, "wrap,grow");
        jPanel.add((Component)jLabel9, "right");
        jPanel.add((Component)this.l, "wrap,grow");
        jPanel.add((Component)jLabel10, "right");
        jPanel.add((Component)this.m, "wrap,grow");
        jPanel.add((Component)jLabel11, "right");
        jPanel.add((Component)this.n, "grow");
        return jPanel;
    }

    private JPanel d() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx", "[][grow]"));
        JLabel jLabel = new JLabel(Messages.getString("CustomerForm.51"));
        this.f = new JTextArea();
        this.f.setRows(3);
        this.f.setLineWrap(true);
        JScrollPane jScrollPane = new JScrollPane(this.f);
        JLabel jLabel2 = new JLabel(Messages.getString("CustomerForm.52"));
        this.g = new FixedLengthTextField();
        JLabel jLabel3 = new JLabel(Messages.getString("CustomerForm.53"));
        this.h = new FixedLengthTextField();
        JLabel jLabel4 = new JLabel(Messages.getString("CustomerForm.55"));
        this.i = new FixedLengthTextField();
        JLabel jLabel5 = new JLabel(Messages.getString("CustomerForm.56"));
        this.j = new FixedLengthTextField();
        this.j.setText(Messages.getString("CustomerForm.57"));
        this.o = new JCheckBox(Messages.getString("CustomerForm.58"));
        this.o.setFocusable(false);
        this.p = new JCheckBox(Messages.getString("CustomerForm.59"));
        jPanel.add((Component)jLabel, "right");
        jPanel.add((Component)jScrollPane, "wrap, span 0 1, grow");
        jPanel.add((Component)jLabel2, "right");
        jPanel.add((Component)this.g, "wrap");
        jPanel.add((Component)jLabel3, "right");
        jPanel.add((Component)this.h, "wrap");
        jPanel.add((Component)jLabel4, "right");
        jPanel.add((Component)this.i, "wrap");
        jPanel.add((Component)jLabel5, "right");
        jPanel.add((Component)this.j, "wrap");
        jPanel.add((Component)this.o, "skip 1,wrap");
        jPanel.add((Component)this.p, "skip 1");
        return jPanel;
    }

    public void callOrderController() {
        Vector<Component> vector = new Vector<Component>();
        vector.add(this.a);
        vector.add(this.b);
        vector.add(this.c);
        vector.add(this.d);
        vector.add(this.e);
        vector.add(this.y);
        vector.add(this.k);
        vector.add(this.l);
        vector.add(this.m);
        vector.add(this.n);
        vector.add(this.f);
        vector.add(this.g);
        vector.add(this.h);
        vector.add(this.i);
        vector.add(this.j);
        this.w = new MyOwnFocusTraversalPolicy(vector);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(this.w);
    }

    public void enableCustomerFields(boolean bl) {
        this.t.setEnabled(bl);
        this.b.setEnabled(bl);
        this.a.setEnabled(bl);
        this.c.setEnabled(bl);
        this.d.setEnabled(bl);
        this.e.setEnabled(bl);
        this.y.setEnabled(bl);
        this.f.setEnabled(bl);
        this.g.setEnabled(bl);
        this.h.setEditable(bl);
        this.i.setEnabled(bl);
        this.j.setEnabled(bl);
        this.k.setEnabled(bl);
        this.l.setEnabled(bl);
        this.m.setEnabled(bl);
        this.n.setEnabled(bl);
        this.o.setEnabled(bl);
        this.p.setEnabled(bl);
        this.s.setEnabled(bl);
        this.r.setEnabled(bl);
    }

    @Override
    public void setFieldsEnable(boolean bl) {
        this.t.setEnabled(bl);
        this.a.setEnabled(bl);
        this.b.setEnabled(bl);
        this.e.setEnabled(bl);
        this.y.setEnabled(bl);
        this.k.setEnabled(bl);
        this.f.setEnabled(bl);
        this.g.setEnabled(bl);
        this.m.setEnabled(bl);
        this.i.setEnabled(bl);
        this.j.setEnabled(bl);
        this.o.setEnabled(bl);
        this.p.setEnabled(bl);
        this.c.setEnabled(bl);
        this.n.setEnabled(bl);
        this.s.setEnabled(bl);
        this.r.setEnabled(bl);
        this.l.setEnabled(bl);
        this.d.setEnabled(bl);
    }

    public void setFieldsEditable(boolean bl) {
        this.t.setEditable(bl);
        this.a.setEditable(bl);
        this.b.setEditable(bl);
        this.e.setEditable(bl);
        this.y.setEditable(bl);
        this.k.setEditable(bl);
        this.f.setEditable(bl);
        this.g.setEditable(bl);
        this.m.setEditable(bl);
        this.i.setEditable(bl);
        this.j.setEditable(bl);
        this.o.setEnabled(bl);
        this.p.setEnabled(bl);
        this.c.setEditable(bl);
        this.n.setEditable(bl);
        this.s.setEnabled(bl);
        this.r.setEnabled(bl);
        this.l.setEditable(bl);
        this.d.setEditable(bl);
    }

    @Override
    public void createNew() {
        this.setBean(new Customer());
        this.a.setText("");
        this.b.setText("");
        this.t.setSelectedIndex(0);
        this.c.setText("");
        this.f.setText("");
        this.g.setText("");
        this.j.setText("");
        this.m.setText("");
        this.e.setText("");
        this.y.setText("");
        this.k.setText("");
        this.l.setText("");
        this.n.setText("");
        this.i.setText("");
        this.o.setSelected(false);
        this.p.setSelected(false);
        this.d.setText("");
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            Customer customer = (Customer)this.getBean();
            CustomerDAO.getInstance().saveOrUpdate(customer);
            this.updateView();
            return true;
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (IllegalModelStateException illegalModelStateException) {
        }
        catch (StaleObjectStateException staleObjectStateException) {
            BOMessageDialog.showError(this, Messages.getString("CustomerForm.47"));
        }
        return false;
    }

    @Override
    protected void updateView() {
        Customer customer = (Customer)this.getBean();
        if (customer == null) {
            return;
        }
        this.t.setSelectedItem(customer.getSalutation());
        this.a.setText(customer.getFirstName());
        this.b.setText(customer.getLastName());
        this.c.setText(customer.getDob());
        this.f.setText(customer.getAddress());
        this.g.setText(customer.getCity());
        this.j.setText(customer.getCountry());
        this.m.setText(String.valueOf(customer.getCreditLimit()));
        this.e.setText(customer.getEmail());
        this.y.setText(customer.getEmail2());
        this.k.setText(customer.getLoyaltyNo());
        this.l.setText(customer.getLoyaltyPoint().toString());
        this.n.setText(String.valueOf(customer.getBalance()));
        this.h.setText(customer.getState());
        this.i.setText(customer.getZipCode());
        this.o.setSelected(customer.isVip());
        this.p.setSelected(customer.isTaxExempt());
        this.d.setText(customer.getMobileNo());
        if (customer.getSsn() != null) {
            // empty if block
        }
        this.v = ImageResourceDAO.getInstance().findById(customer.getImageId());
        if (this.v != null) {
            this.q.setIcon(new ImageIcon(this.v.getImage().getScaledInstance(200, 200, 1)));
        } else {
            this.q.setIcon(new ImageIcon(this.x.getScaledInstance(200, 200, 1)));
        }
    }

    protected void doSelectImageFile() {
        ImageGalleryDialog imageGalleryDialog = ImageGalleryDialog.getInstance();
        imageGalleryDialog.setTitle("Image Gallery");
        imageGalleryDialog.setSelectBtnVisible(true);
        imageGalleryDialog.setSize(PosUIManager.getSize(650, 600));
        imageGalleryDialog.setResizable(false);
        imageGalleryDialog.open();
        if (imageGalleryDialog.isCanceled()) {
            return;
        }
        this.v = imageGalleryDialog.getImageResource();
        if (this.v != null) {
            this.q.setIcon(new ImageIcon(this.v.getImage().getScaledInstance(200, 200, 1)));
        }
    }

    protected void doClearImage() {
        this.q.setIcon(new ImageIcon(this.x.getScaledInstance(200, 200, 1)));
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        Object object;
        String string = this.a.getText();
        String string2 = this.e.getText();
        String string3 = this.y.getText();
        if (StringUtils.isNotEmpty((String)string2) && !this.a(string2)) {
            return false;
        }
        if (StringUtils.isNotEmpty((String)string3) && !this.a(string3)) {
            return false;
        }
        Customer customer = (Customer)this.getBean();
        if (customer == null) {
            customer = new Customer();
            this.setBean(customer, false);
        }
        if ((object = this.t.getSelectedItem()) != null) {
            customer.setSalutation(object.toString());
        }
        GenericDAO.getInstance().checkIdOrNameExists(customer.getId(), string, Customer.class);
        customer.setFirstName(this.a.getText());
        customer.setLastName(this.b.getText());
        customer.setDob(this.c.getText());
        customer.setAddress(this.f.getText());
        customer.setCity(this.g.getText());
        customer.setCountry(this.j.getText());
        customer.setState(this.h.getText());
        customer.setCreditLimit(PosGuiUtil.parseDouble(this.m));
        customer.setEmail(string2);
        customer.setEmail2(this.y.getText());
        customer.setLoyaltyNo(this.k.getText());
        customer.setLoyaltyPoint(this.l.getInteger());
        customer.setZipCode(this.i.getText());
        customer.setVip(this.o.isSelected());
        customer.setTaxExempt(this.p.isSelected());
        customer.setMobileNo(this.d.getText());
        customer.setBalance(PosGuiUtil.parseDouble(this.n));
        if (this.v != null) {
            customer.setImageId(this.v.getId());
        }
        return true;
    }

    private boolean a(String string) {
        boolean bl = EmailValidator.getInstance().isValid(string);
        if (!bl) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CustomerForm.9"));
            return false;
        }
        return bl;
    }

    @Override
    public boolean delete() {
        try {
            Customer customer = (Customer)this.getBean();
            if (customer == null) {
                return false;
            }
            int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), "Are you sure to delete selected table?", "Confirm");
            if (n != 0) {
                return false;
            }
            CustomerDAO.getInstance().delete(customer);
            return true;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
            return false;
        }
    }

    @Override
    public String getDisplayText() {
        if (this.getBean() == null) {
            return Messages.getString("CustomerForm.54");
        }
        return Messages.getString("CustomerForm.12");
    }

    public static class MyOwnFocusTraversalPolicy
    extends FocusTraversalPolicy {
        Vector<Component> a;

        public MyOwnFocusTraversalPolicy(Vector<Component> vector) {
            this.a = new Vector(vector.size());
            this.a.addAll(vector);
        }

        @Override
        public Component getComponentAfter(Container container, Component component) {
            int n = (this.a.indexOf(component) + 1) % this.a.size();
            return this.a.get(n);
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            int n = this.a.indexOf(component) - 1;
            if (n < 0) {
                n = this.a.size() - 1;
            }
            return this.a.get(n);
        }

        @Override
        public Component getDefaultComponent(Container container) {
            return this.a.get(0);
        }

        @Override
        public Component getLastComponent(Container container) {
            return this.a.lastElement();
        }

        @Override
        public Component getFirstComponent(Container container) {
            return this.a.get(0);
        }
    }
}

