/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.menuitem.variant;

import com.floreantpos.model.ImageResource;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.menuitem.ButtonStylePanel;
import com.floreantpos.ui.menuitem.InventoryPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTabbedPane;
import org.hibernate.StaleStateException;

public class VariantForm
extends BeanEditor<MenuItem>
implements RefreshableView {
    private ButtonStylePanel a;
    private InventoryPanel b;

    public VariantForm(MenuItem menuItem) {
        this.a();
        this.setBean(menuItem);
        this.b.setMenuItem(menuItem);
    }

    private void a() {
        this.setLayout(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.a = new ButtonStylePanel();
        this.a.setSortOrderVisibility(true);
        this.b = new InventoryPanel((MenuItem)this.getBean());
        jTabbedPane.addTab("Button Style", this.a);
        jTabbedPane.addTab("Inventory", this.b);
        this.add((Component)jTabbedPane, "Center");
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            MenuItem menuItem = (MenuItem)this.getBean();
            MenuItemDAO menuItemDAO = new MenuItemDAO();
            if (menuItem.getId() == null) {
                menuItemDAO.save(menuItem);
            } else {
                menuItemDAO.saveOrUpdate(menuItem);
            }
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
            return false;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    @Override
    protected void updateView() {
        Color color;
        MenuItem menuItem = (MenuItem)this.getBean();
        ImageResource imageResource = ImageResourceDAO.getInstance().findById(menuItem.getImageId());
        if (imageResource != null) {
            this.a.setImageResource(imageResource);
        }
        if ((color = menuItem.getButtonColor()) != null) {
            this.a.setButtonColor(color);
            this.a.setTextColor(color);
        }
        if (menuItem.getTextColor() != null) {
            this.a.setTextForegroundColor(menuItem.getTextColor());
        }
        this.a.setSortOrder(menuItem.getSortOrder());
        this.b.setSku(menuItem.getSku());
        this.b.setReOrderLevel(menuItem.getReorderLevel());
        this.b.setReplenishLevel(menuItem.getReplenishLevel());
        this.b.setCbDisableStockCount(menuItem.isDisableWhenStockAmountIsZero());
    }

    @Override
    public boolean updateModel() {
        MenuItem menuItem = (MenuItem)this.getBean();
        menuItem.setReorderLevel(this.b.getReOrderLevel());
        menuItem.setReplenishLevel(this.b.getReplenishLevel());
        menuItem.setDisableWhenStockAmountIsZero(this.b.isCbDisableStockCount());
        menuItem.setShowImageOnly(this.a.isShowTextWithImage());
        menuItem.setButtonColor(this.a.getButtonColor());
        menuItem.setButtonColorCode(this.a.getButtonColorCode());
        menuItem.setTextColor(this.a.getTextColor());
        menuItem.setTextColorCode(this.a.getTextColorCode());
        menuItem.setImageId(this.a.getImageResourceId());
        menuItem.setSortOrder(this.a.getSortOrder());
        menuItem.setSku(this.b.getSku());
        return true;
    }

    @Override
    public String getDisplayText() {
        return "Variant Edit Form";
    }

    @Override
    public void refresh() {
        MenuItem menuItem = (MenuItem)this.getBean();
        MenuItem menuItem2 = MenuItemDAO.getInstance().get(menuItem.getId());
        this.setBean(menuItem2);
    }
}

