/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.AttributeGroup;
import com.floreantpos.model.dao.AttributeDAO;
import com.floreantpos.model.dao.AttributeGroupDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import net.miginfocom.swing.MigLayout;

public class AttributeEntryForm
extends BeanEditor<Attribute> {
    private FixedLengthTextField a = new FixedLengthTextField(30);
    private IntegerTextField b = new IntegerTextField(10);
    private JComboBox<AttributeGroup> c = new JComboBox();
    private List<AttributeGroup> d;
    private JButton e;
    private JCheckBox f;

    public AttributeEntryForm() {
        this(new Attribute());
    }

    public AttributeEntryForm(Attribute attribute) {
        this.a();
        this.d = AttributeGroupDAO.getInstance().findAll();
        if (this.d != null) {
            this.c.setModel(new ComboBoxModel(this.d));
        }
        this.setBean(attribute);
    }

    private void a() {
        this.setLayout((LayoutManager)new MigLayout("fillx"));
        this.add(new JLabel("Name"));
        this.add((Component)this.a, "grow, wrap");
        this.add(new JLabel("Sort Order"));
        this.add((Component)this.b, "wrap,grow");
        this.add(new JLabel("Attribute Group"));
        this.add(this.c, "split 2,grow");
        this.e = new JButton("New");
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    AttributeGroup attributeGroup = new AttributeGroup();
                    String string = JOptionPane.showInputDialog(POSUtil.getFocusedWindow(), (Object)"Enter group name");
                    if (string == null) {
                        return;
                    }
                    if (string.length() > 30) {
                        BOMessageDialog.showError(POSUtil.getFocusedWindow(), "Group name too long.");
                        return;
                    }
                    GenericDAO.getInstance().checkIdOrNameExists(attributeGroup.getId(), string, AttributeGroup.class);
                    attributeGroup.setName(string);
                    AttributeGroupDAO.getInstance().saveOrUpdate(attributeGroup);
                    AttributeEntryForm.this.d.add(attributeGroup);
                    AttributeEntryForm.this.c.setModel(new ComboBoxModel(AttributeEntryForm.this.d));
                    AttributeEntryForm.this.c.setSelectedItem(attributeGroup);
                }
                catch (PosException posException) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
                }
            }
        });
        this.add((Component)this.e, "wrap");
        this.f = new JCheckBox("Default");
        this.add((Component)this.f, "skip 1,wrap");
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            Attribute attribute = (Attribute)this.getBean();
            boolean bl = attribute.isDefaultAttribute();
            AttributeGroup attributeGroup = attribute.getGroup();
            if (bl) {
                if (attributeGroup.getAttributes() != null) {
                    for (Attribute list2 : attributeGroup.getAttributes()) {
                        list2.setDefaultAttribute(false);
                    }
                }
                attribute.setDefaultAttribute(true);
            }
            ArrayList arrayList = new ArrayList();
            List<Attribute> list = attributeGroup.getAttributes();
            if (list != null) {
                if (list.contains(attribute)) {
                    for (Attribute attribute2 : list) {
                        if (attribute2.getId().equals(attribute.getId())) {
                            attribute2 = attribute;
                        }
                        arrayList.add(attribute2);
                    }
                    attributeGroup.setAttributes(arrayList);
                } else {
                    attributeGroup.addToattributes(attribute);
                }
            } else {
                attributeGroup.addToattributes(attribute);
            }
            AttributeGroupDAO.getInstance().saveOrUpdate(attributeGroup);
            return true;
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (IllegalModelStateException illegalModelStateException) {
            POSMessageDialog.showError(this, illegalModelStateException.getMessage());
        }
        return false;
    }

    @Override
    public void createNew() {
        this.setBean(new Attribute());
        this.clearFields();
    }

    @Override
    public void setFieldsEnable(boolean bl) {
        this.a.setEnabled(bl);
        this.b.setEnabled(bl);
        this.c.setEnabled(bl);
        this.e.setEnabled(bl);
        this.f.setEnabled(bl);
    }

    @Override
    public void clearFields() {
        this.a.setText("");
        this.b.setText("");
    }

    @Override
    protected void updateView() {
        Attribute attribute = (Attribute)this.getBean();
        if (attribute == null) {
            return;
        }
        this.a.setText(attribute.getName());
        this.b.setText(attribute.getSortOrder() + "");
        this.c.setSelectedItem(attribute.getGroup());
        this.f.setSelected(attribute.isDefaultAttribute());
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        Attribute attribute = (Attribute)this.getBean();
        String string = this.a.getText();
        Integer n = this.b.getInteger();
        AttributeGroup attributeGroup = (AttributeGroup)this.c.getSelectedItem();
        if (attributeGroup == null) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), "Please select a group");
            return false;
        }
        GenericDAO.getInstance().checkIdOrNameExists(attribute.getId(), string, Attribute.class);
        attribute.setName(string);
        attribute.setSortOrder(n);
        attribute.setGroup(attributeGroup);
        attribute.setDefaultAttribute(this.f.isSelected());
        return true;
    }

    @Override
    public boolean delete() {
        try {
            Attribute attribute = (Attribute)this.getBean();
            if (attribute == null) {
                return false;
            }
            int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), "Are you sure to delete selected item ?", "Confirm");
            if (n != 0) {
                return false;
            }
            AttributeDAO.getInstance().delete(attribute);
            this.clearFields();
            return true;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
            return false;
        }
    }

    @Override
    public String getDisplayText() {
        return "Add/Edit Attribute";
    }
}

