/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.IconFactory;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.forms.CustomerForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class MultipleCustomerSelectionView
extends JPanel {
    private JXTable a;
    private BeanTableModel<Customer> b;
    private JTextField c;
    private Customer d;
    private PosButton e;
    private PosButton f;
    private CustomerGroup g;
    private JLabel h = new JLabel();
    private JLabel i;
    private JButton j;
    private JPanel k;
    private Map<String, Customer> l = new HashMap<String, Customer>();
    private JCheckBox m;
    private JCheckBox n;
    private boolean o;

    public MultipleCustomerSelectionView(List<Customer> list) {
        this.a();
        this.b.setCurrentRowIndex(0);
        this.setCustomer(list);
    }

    private void a() {
        this.setLayout(new BorderLayout(5, 5));
        this.b = new BeanTableModel(Customer.class);
        this.b.addColumn("", "selected");
        this.b.addColumn(POSConstants.NAME.toUpperCase(), "name");
        this.b.setPageSize(10);
        this.a = new JXTable(this.b);
        this.a.setSelectionMode(2);
        this.a.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.a.setRowHeight(PosUIManager.getSize(40));
        this.a.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    MultipleCustomerSelectionView.this.i();
                } else {
                    MultipleCustomerSelectionView.this.l();
                }
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(10, 5, 10, 5));
        JScrollPane jScrollPane = new JScrollPane((Component)this.a);
        jScrollPane.setPreferredSize(PosUIManager.getSize(500, 250));
        jPanel.add(jScrollPane);
        jPanel.add((Component)this.b(), "North");
        this.add(jPanel);
        this.resizeColumnWidth((JTable)this.a);
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("ins 5 0 0 0,fillx", "[left,grow][][][]", ""));
        jPanel2.add((Component)this.g(), "left,split 2");
        this.m = new JCheckBox("Show selected");
        this.m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MultipleCustomerSelectionView.this.m.isSelected()) {
                    MultipleCustomerSelectionView.this.b.setRows(new ArrayList(MultipleCustomerSelectionView.this.l.values()));
                    MultipleCustomerSelectionView.this.e();
                    MultipleCustomerSelectionView.this.m.setText("Show Selected (" + MultipleCustomerSelectionView.this.l.values().size() + ")");
                    MultipleCustomerSelectionView.this.h.setText("");
                    MultipleCustomerSelectionView.this.f.setEnabled(false);
                    MultipleCustomerSelectionView.this.e.setEnabled(false);
                    MultipleCustomerSelectionView.this.a.repaint();
                }
            }
        });
        jPanel2.add(this.m);
        jPanel2.add((Component)this.h, "split 3,center");
        this.f = new PosButton();
        this.f.setIcon(IconFactory.getIcon("/ui_icons/", "previous.png"));
        jPanel2.add((Component)this.f, "center");
        PosButton posButton = new PosButton();
        posButton.setBorder(null);
        posButton.setOpaque(false);
        posButton.setContentAreaFilled(false);
        posButton.setIcon(IconFactory.getIcon("/ui_icons/", "dot.png"));
        this.e = new PosButton();
        this.e.setIcon(IconFactory.getIcon("/ui_icons/", "next.png"));
        jPanel2.add(this.e);
        jPanel2.add((Component)new JSeparator(), "newline,span,grow");
        jPanel.add((Component)jPanel2, "South");
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object = actionEvent.getSource();
                    if (object == MultipleCustomerSelectionView.this.f) {
                        MultipleCustomerSelectionView.this.k();
                    } else if (object == MultipleCustomerSelectionView.this.e) {
                        MultipleCustomerSelectionView.this.j();
                    }
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
                }
            }
        };
        this.f.addActionListener(actionListener);
        this.e.addActionListener(actionListener);
        this.e.setEnabled(false);
        this.f.setEnabled(false);
    }

    private JPanel b() {
        this.k = new JPanel();
        this.k.setLayout((LayoutManager)new MigLayout("inset 0,fillx,hidemode 3", "", "[][]"));
        this.i = new JLabel(POSConstants.NAME);
        this.c = new JTextField();
        this.j = new JButton(POSConstants.SEARCH_ITEM_BUTTON_TEXT);
        this.k.add((Component)this.i, "align label,split 5");
        this.k.add((Component)this.c, "grow");
        JButton jButton = new JButton("Search");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultipleCustomerSelectionView.this.b.setCurrentRowIndex(0);
                MultipleCustomerSelectionView.this.c();
            }
        });
        this.k.add((Component)jButton, "wrap");
        this.n = new JCheckBox("Select All");
        this.n.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultipleCustomerSelectionView.this.d();
            }
        });
        this.k.add((Component)this.n, "left");
        this.j.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultipleCustomerSelectionView.this.b.setCurrentRowIndex(0);
                MultipleCustomerSelectionView.this.c();
            }
        });
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultipleCustomerSelectionView.this.b.setCurrentRowIndex(0);
                MultipleCustomerSelectionView.this.c();
            }
        });
        return this.k;
    }

    private void c() {
        this.b.setNumRows(CustomerDAO.getInstance().getRowCount(this.c.getText()));
        CustomerDAO.getInstance().loadCustomers(this.c.getText(), this.b);
        this.m();
        this.f();
        this.e();
        this.a.repaint();
        this.m.setSelected(false);
    }

    private void d() {
        List<Customer> list = this.b.getRows();
        if (list != null && list.size() > 0) {
            for (Customer customer : list) {
                if (this.d != null && this.d.getId() != null && this.d.getId().equals(customer.getId())) continue;
                customer.setSelected(this.n.isSelected());
                if (customer.isSelected().booleanValue()) {
                    this.l.put(customer.getId(), customer);
                    continue;
                }
                this.l.remove(customer.getId());
            }
        } else {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "No items found!");
            this.n.setSelected(false);
        }
        this.a.repaint();
    }

    private void e() {
        List<Customer> list = this.b.getRows();
        if (list == null) {
            return;
        }
        Iterator<Customer> iterator = list.iterator();
        while (iterator.hasNext()) {
            Customer customer;
            Customer customer2 = this.l.get((customer = iterator.next()).getId());
            customer.setSelected(customer2 != null);
        }
    }

    private void f() {
        int n;
        int n2 = this.b.getCurrentRowIndex() + 1;
        int n3 = this.b.getNextRowIndex();
        if (n3 > (n = this.b.getNumRows())) {
            n3 = n;
        }
        this.h.setText(String.format("Showing %s to %s of %s", n2, n3, n));
        this.f.setEnabled(this.b.hasPrevious());
        this.e.setEnabled(this.b.hasNext());
        if (this.b.getRowCount() > 0) {
            this.a.setRowSelectionInterval(0, 0);
        }
        this.m.setText("Show Selected (" + this.l.values().size() + ")");
    }

    private TransparentPanel g() {
        ExplorerButtonPanel explorerButtonPanel = new ExplorerButtonPanel();
        JButton jButton = explorerButtonPanel.getEditButton();
        JButton jButton2 = explorerButtonPanel.getAddButton();
        jButton2.setText(POSConstants.ADD);
        jButton.setText(POSConstants.EDIT);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultipleCustomerSelectionView.this.i();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    CustomerForm customerForm = new CustomerForm();
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)customerForm);
                    beanEditorDialog.open();
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    Customer customer = (Customer)customerForm.getBean();
                    MultipleCustomerSelectionView.this.b.addRow(customer);
                    MultipleCustomerSelectionView.this.b.setNumRows(MultipleCustomerSelectionView.this.b.getNumRows() + 1);
                    MultipleCustomerSelectionView.this.f();
                }
                catch (Throwable throwable) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new MigLayout("center,ins 0", "sg,fill", ""));
        return transparentPanel;
    }

    public void resizeColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth((Integer)this.h().get(i));
        }
    }

    private List h() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(70);
        arrayList.add(250);
        arrayList.add(70);
        return arrayList;
    }

    private void i() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                return;
            }
            n = this.a.convertRowIndexToModel(n);
            Customer customer = this.b.getRow(n);
            this.b.setRow(n, customer);
            CustomerForm customerForm = new CustomerForm();
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)customerForm);
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            this.a.repaint();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    public List<Customer> getSelectedCustomerList() {
        return new ArrayList<Customer>(this.l.values());
    }

    public void setCustomer(List<Customer> list) {
        if (list != null) {
            for (Customer customer : list) {
                this.l.put(customer.getId(), customer);
            }
        }
        this.c();
    }

    public void setParentCustomer(Customer customer) {
        this.d = customer;
    }

    private void j() {
        this.b.setCurrentRowIndex(this.b.getNextRowIndex());
        this.c();
    }

    private void k() {
        this.b.setCurrentRowIndex(this.b.getPreviousRowIndex());
        this.c();
    }

    public void setSelectedCustomerGroup(Object object) {
        this.g = object instanceof CustomerGroup ? (CustomerGroup)object : null;
        this.c();
    }

    private void l() {
        if (this.a.getSelectedRow() < 0) {
            return;
        }
        if (this.o) {
            return;
        }
        int n = this.a.getSelectedRow();
        n = this.a.convertRowIndexToModel(n);
        Customer customer = this.b.getRow(n);
        if (this.d != null && this.d.getId() != null && this.d.getId().equals(customer.getId())) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Parent item cannot be selected");
            return;
        }
        customer.setSelected(customer.isSelected() == false);
        if (customer.isSelected().booleanValue()) {
            this.l.put(customer.getId(), customer);
        } else {
            this.l.remove(customer.getId());
        }
        this.m.setText("Show Selected (" + this.l.values().size() + ")");
        this.a.repaint();
    }

    private void m() {
    }

    public BeanTableModel<Customer> getModel() {
        return this.b;
    }

    public int getSelectedRow() {
        int n = this.a.getSelectedRow();
        if (n < 0) {
            return -1;
        }
        return this.a.convertRowIndexToModel(n);
    }

    public void repaintTable() {
        this.a.repaint();
    }

    public void setSingleSelectionEnable(boolean bl) {
        this.o = bl;
        if (bl) {
            this.m.setVisible(false);
            this.n.setVisible(false);
            this.h.setVisible(false);
            this.e.setVisible(false);
            this.f.setVisible(false);
            TableColumnModelExt tableColumnModelExt = (TableColumnModelExt)this.a.getColumnModel();
            tableColumnModelExt.getColumnExt(0).setVisible(false);
            this.c();
        }
    }

    public void setSelectedGroup(CustomerGroup customerGroup) {
        if (this.g != null && this.g.getId().equals(customerGroup.getId())) {
            return;
        }
        this.g = customerGroup;
        this.c();
    }
}

