/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.IconFactory;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.main.Application;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PriceTable;
import com.floreantpos.model.PriceTableItem;
import com.floreantpos.model.dao.PriceTableItemDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthDocument;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class PriceTableForm
extends BeanEditor<PriceTable>
implements ActionListener {
    private JTable a;
    private PriceTableItemExplorerTableModel b;
    private FixedLengthTextField c = new FixedLengthTextField();
    private JTextArea d = new JTextArea();
    private JButton e;
    private JButton f;
    private boolean g;
    private JLabel h = new JLabel();
    private PosButton i;
    private PosButton j;
    protected PaginatedListModel dataModel = new PaginatedListModel();
    private boolean k = false;

    public PriceTableForm(PriceTable priceTable) {
        this.a();
        this.b = new PriceTableItemExplorerTableModel();
        this.a.setModel(this.b);
        this.setBean(priceTable);
        this.g();
        this.a.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "startEditing");
        DoubleTextField doubleTextField = new DoubleTextField();
        doubleTextField.setAllowNegativeValue(true);
        doubleTextField.setHorizontalAlignment(4);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(doubleTextField);
        defaultCellEditor.setClickCountToStart(1);
        this.a.setDefaultEditor(this.a.getColumnClass(4), defaultCellEditor);
    }

    private void a() {
        this.setLayout((LayoutManager)new MigLayout("fill", "[][grow]", ""));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.a = new JTable(){

            @Override
            public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
                super.changeSelection(n, n2, bl, bl2);
                if (n2 != 4) {
                    return;
                }
                PriceTableForm.this.a.editCellAt(n, n2);
                PriceTableForm.this.a.transferFocus();
                DefaultCellEditor defaultCellEditor = (DefaultCellEditor)PriceTableForm.this.a.getCellEditor(n, n2);
                if (n2 == 4) {
                    DoubleTextField doubleTextField = (DoubleTextField)defaultCellEditor.getComponent();
                    doubleTextField.requestFocus();
                    doubleTextField.selectAll();
                    PriceTableForm.this.k = true;
                }
            }
        };
        this.a.setRowHeight(PosUIManager.getSize(30));
        this.c.setLength(30);
        this.add(new JLabel("Name"));
        this.add((Component)this.c, "growx,wrap");
        this.d.setLineWrap(true);
        this.d.setDocument(new FixedLengthDocument(255));
        this.add((Component)new JLabel("Description"), "growx,aligny top");
        JScrollPane jScrollPane = new JScrollPane(this.d);
        this.add((Component)jScrollPane, "growx,h 70!,top,wrap");
        this.add((Component)new JScrollPane(this.a), "span,grow");
        this.f();
    }

    private void b() {
        PriceTable priceTable = (PriceTable)this.getBean();
        if (this.k) {
            PriceTableItemDAO.getInstance().saveOrUpdateItems(priceTable, this.dataModel.getDataList());
            this.k = false;
        }
        this.dataModel.setCurrentRowIndex(this.dataModel.getNextRowIndex());
        this.c();
    }

    private void c() {
        PriceTable priceTable = (PriceTable)this.getBean();
        this.dataModel.setNumRows(PriceTableItemDAO.getInstance().rowCount(priceTable));
        PriceTableItemDAO.getInstance().loadItems(priceTable, this.dataModel);
        this.b.setItems(this.dataModel.getDataList());
        this.e();
        this.a.revalidate();
        this.a.repaint();
    }

    private void d() {
        PriceTable priceTable = (PriceTable)this.getBean();
        if (this.k) {
            PriceTableItemDAO.getInstance().saveOrUpdateItems(priceTable, this.dataModel.getDataList());
            this.k = false;
        }
        this.dataModel.setCurrentRowIndex(this.dataModel.getPreviousRowIndex());
        this.c();
    }

    private void e() {
        int n;
        int n2 = this.dataModel.getCurrentRowIndex() + 1;
        int n3 = this.dataModel.getNextRowIndex();
        if (n3 > (n = this.dataModel.getNumRows())) {
            n3 = n;
        }
        this.h.setText(String.format("Showing %s to %s of %s", n2, n3, n));
        this.j.setEnabled(this.dataModel.hasPrevious());
        this.i.setEnabled(this.dataModel.hasNext());
    }

    private void f() {
        this.e = new JButton("Add Item");
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (!PriceTableForm.this.updateModel()) {
                        return;
                    }
                    MenuItemSelectionDialog menuItemSelectionDialog = new MenuItemSelectionDialog(new ArrayList<MenuItem>());
                    menuItemSelectionDialog.setSelectionMode(1);
                    menuItemSelectionDialog.setSize(PosUIManager.getSize(600, 515));
                    menuItemSelectionDialog.open();
                    if (menuItemSelectionDialog.isCanceled()) {
                        return;
                    }
                    ArrayList<PriceTableItem> arrayList = new ArrayList<PriceTableItem>();
                    PriceTable priceTable = (PriceTable)PriceTableForm.this.getBean();
                    List<MenuItem> list = menuItemSelectionDialog.getSelectedItems();
                    for (MenuItem menuItem : list) {
                        PriceTableItem priceTableItem = null;
                        if (priceTable.getId() != null) {
                            priceTableItem = PriceTableItemDAO.getInstance().getItem(priceTable, menuItem);
                        }
                        if (priceTableItem != null) continue;
                        PriceTableItem priceTableItem2 = new PriceTableItem();
                        priceTableItem2.setMenuItem(menuItem);
                        priceTableItem2.setMenuItemId(menuItem.getId());
                        priceTableItem2.setItemBarcode(menuItem.getBarcode());
                        priceTableItem2.setPrice(menuItem.getPrice());
                        arrayList.add(priceTableItem2);
                    }
                    PriceTableItemDAO.getInstance().saveOrUpdateItems(priceTable, arrayList);
                    PriceTableForm.this.dataModel.setNumRows(PriceTableItemDAO.getInstance().rowCount(priceTable));
                    PriceTableForm.this.dataModel.setCurrentRowIndex(0);
                    PriceTableItemDAO.getInstance().loadItems(priceTable, PriceTableForm.this.dataModel);
                    PriceTableForm.this.e();
                    PriceTableForm.this.b.setItems(PriceTableForm.this.dataModel.getDataList());
                    PriceTableForm.this.a.revalidate();
                    PriceTableForm.this.a.repaint();
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        this.f = new JButton(POSConstants.DELETE);
        this.f.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = PriceTableForm.this.a.getSelectedRow();
                    if (n < 0) {
                        return;
                    }
                    n = PriceTableForm.this.a.convertRowIndexToModel(n);
                    PriceTableItem priceTableItem = PriceTableForm.this.b.getPriceTableItem(n);
                    PriceTableItemDAO.getInstance().delete(priceTableItem);
                    PriceTableForm.this.dataModel.setNumRows(PriceTableForm.this.dataModel.getNumRows() - 1);
                    PriceTableForm.this.dataModel.removeElement(priceTableItem);
                    PriceTableForm.this.b.deleteItem(priceTableItem, n);
                    PriceTableForm.this.e();
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        this.dataModel.setPageSize(20);
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("ins 5 0 0 0,fillx", "[left,grow][]", ""));
        jPanel.add((Component)this.e, "split 2,top");
        jPanel.add((Component)this.f, "top");
        jPanel.add((Component)this.h, "split 3,span");
        this.j = new PosButton();
        this.j.setIcon(IconFactory.getIcon("/ui_icons/", "previous.png"));
        jPanel.add((Component)this.j, "center");
        this.i = new PosButton();
        this.i.setIcon(IconFactory.getIcon("/ui_icons/", "next.png"));
        jPanel.add(this.i);
        this.add((Component)jPanel, "growx,span 2");
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object = actionEvent.getSource();
                    if (object == PriceTableForm.this.j) {
                        PriceTableForm.this.d();
                    } else if (object == PriceTableForm.this.i) {
                        PriceTableForm.this.b();
                    }
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
                }
            }
        };
        this.j.addActionListener(actionListener);
        this.i.addActionListener(actionListener);
        this.i.setEnabled(false);
        this.j.setEnabled(false);
    }

    private void g() {
        this.a.setAutoResizeMode(4);
        this.a(0, PosUIManager.getSize(100));
        this.a(1, PosUIManager.getSize(100));
        this.a(3, PosUIManager.getSize(100));
        this.a(4, PosUIManager.getSize(100));
    }

    private void a(int n, int n2) {
        TableColumn tableColumn = this.a.getColumnModel().getColumn(n);
        tableColumn.setPreferredWidth(n2);
        tableColumn.setMaxWidth(n2);
        tableColumn.setMinWidth(n2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (POSConstants.DELETE.equals(string)) {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                BOMessageDialog.showError(POSConstants.SELECT_ITEM_TO_DELETE);
                return;
            }
            PriceTableItem priceTableItem = this.b.getPriceTableItem(n);
            this.a(n, priceTableItem);
        }
    }

    private void a(int n, PriceTableItem priceTableItem) {
        try {
            if (ConfirmDeleteDialog.showMessage(this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                this.b.deleteItem(priceTableItem, n);
            }
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            PriceTable priceTable = (PriceTable)this.getBean();
            PriceTableItemDAO.getInstance().saveOrUpdateItems(priceTable, this.dataModel.getDataList());
            return true;
        }
        catch (IllegalModelStateException illegalModelStateException) {
            illegalModelStateException.printStackTrace();
            return false;
        }
    }

    @Override
    protected void updateView() {
        PriceTable priceTable = (PriceTable)this.getBean();
        this.c.setText(priceTable.getName());
        this.d.setText(priceTable.getDescription());
        if (priceTable.getId() == null) {
            return;
        }
        this.dataModel.setCurrentRowIndex(0);
        this.c();
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        PriceTable priceTable = (PriceTable)this.getBean();
        String string = this.c.getText();
        if (StringUtils.isEmpty((String)string)) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Name cannot be empty.");
            return false;
        }
        priceTable.setName(string);
        priceTable.setDescription(this.d.getText());
        priceTable.setLastUpdateTime(new Date());
        priceTable.setLastUpdatedBy(Application.getCurrentUser().getId());
        return true;
    }

    @Override
    public String getDisplayText() {
        if (this.g) {
            return "Price List";
        }
        if (((PriceTable)this.getBean()).getId() == null) {
            return "New Price List";
        }
        return "Edit Price List";
    }

    public void setEditable(boolean bl) {
        boolean bl2 = this.g = !bl;
        if (this.g) {
            this.e.setVisible(false);
            this.f.setVisible(false);
            this.d.setEnabled(false);
            this.c.setEnabled(false);
            this.a.setEnabled(false);
        }
    }

    private class PriceTableItemExplorerTableModel
    extends ListTableModel<PriceTableItem> {
        String[] a = new String[]{"ID", "BARCODE", "NAME", "DEFAULT PRICE", "NEW PRICE"};
        List<PriceTableItem> b = new ArrayList<PriceTableItem>();

        public void setItems(List<PriceTableItem> list) {
            if (list == null) {
                return;
            }
            this.b.clear();
            this.b.addAll(list);
        }

        public List<PriceTableItem> getItems() {
            return this.b;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 4;
        }

        @Override
        public int getRowCount() {
            if (this.b == null) {
                return 0;
            }
            return this.b.size();
        }

        @Override
        public int getColumnCount() {
            return this.a.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.a[n];
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 4 || n == 3) {
                return Double.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.b == null) {
                return "";
            }
            PriceTableItem priceTableItem = this.b.get(n);
            if (priceTableItem == null) {
                return "";
            }
            switch (n2) {
                case 0: {
                    return priceTableItem.getMenuItem().getId();
                }
                case 1: {
                    return priceTableItem.getMenuItem().getBarcode();
                }
                case 2: {
                    return priceTableItem.getMenuItem().getDisplayName();
                }
                case 3: {
                    return priceTableItem.getMenuItem().getPrice();
                }
                case 4: {
                    return priceTableItem.getPrice();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            PriceTableItem priceTableItem = this.b.get(n);
            if (priceTableItem == null) {
                return;
            }
            if (n2 == 4) {
                String string = (String)object;
                if (string.isEmpty()) {
                    return;
                }
                double d = Double.parseDouble(string);
                priceTableItem.setPrice(d);
            } else {
                super.setValueAt(object, n, n2);
            }
        }

        public void deleteItem(PriceTableItem priceTableItem, int n) {
            Iterator<PriceTableItem> iterator = this.b.iterator();
            while (iterator.hasNext()) {
                PriceTableItem priceTableItem2 = iterator.next();
                if (priceTableItem != priceTableItem2) continue;
                iterator.remove();
            }
            this.fireTableRowsDeleted(n, n);
        }

        public PriceTableItem getPriceTableItem(int n) {
            return this.b.get(n);
        }
    }
}

