/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.Department;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class SalesAreaEntryForm
extends BeanEditor<SalesArea> {
    private SalesArea c;
    private FixedLengthTextField d;
    JLabel a = new JLabel("Department");
    JComboBox b = new JComboBox();

    public SalesAreaEntryForm(SalesArea salesArea) {
        this.c = salesArea;
        DepartmentDAO departmentDAO = new DepartmentDAO();
        List<Department> list = departmentDAO.findAll();
        this.b.setModel(new ComboBoxModel(list));
        this.initComponents();
        this.setBean(salesArea);
    }

    public void initComponents() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fill,alignx center", "[][]", ""));
        JLabel jLabel = new JLabel("Name");
        this.d = new FixedLengthTextField(20);
        jPanel.add(jLabel);
        jPanel.add((Component)this.d, "wrap");
        jPanel.add(this.a);
        jPanel.add((Component)this.b, "grow");
        this.add(jPanel);
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            SalesArea salesArea = (SalesArea)this.getBean();
            SalesAreaDAO salesAreaDAO = new SalesAreaDAO();
            salesAreaDAO.saveOrUpdate(salesArea);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
            return false;
        }
        catch (Exception exception) {
            MessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
            return false;
        }
        return true;
    }

    @Override
    protected void updateView() {
        SalesArea salesArea = (SalesArea)this.getBean();
        this.d.setText(salesArea.getName());
        this.b.setSelectedItem(salesArea.getDepartment());
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        SalesArea salesArea = (SalesArea)this.getBean();
        if (salesArea == null) {
            return false;
        }
        String string = this.d.getText();
        GenericDAO.getInstance().checkIdOrNameExists(salesArea.getId(), string, SalesArea.class);
        this.c.setName(string);
        salesArea.setDepartment((Department)this.b.getSelectedItem());
        return true;
    }

    @Override
    public String getDisplayText() {
        SalesArea salesArea = (SalesArea)this.getBean();
        if (salesArea.getId() == null) {
            return "Add New Sales Area";
        }
        return "Edit Sales Area";
    }
}

