/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.GlobalIdGenerator;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class UserRoleForm
extends BeanEditor {
    private JComboBox a;
    private DoubleTextField b;
    private JCheckBox c;
    private JCheckBox d;
    private JCheckBox e;
    private JCheckBox f;
    private JCheckBox g;
    private JCheckBox h;

    public UserRoleForm(User user) {
        this.a();
        UserTypeDAO userTypeDAO = new UserTypeDAO();
        List<UserType> list = userTypeDAO.findAll();
        this.a.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        this.setBean(user);
    }

    private void a() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        this.b = new DoubleTextField(10);
        this.a = new JComboBox();
        jPanel.add(new JLabel("User Role"));
        jPanel.add((Component)this.a, "wrap,grow");
        this.a.setSelectedItem(null);
        jPanel.add(new JLabel("Cost per hour"));
        jPanel.add((Component)this.b, "wrap");
        this.c = new JCheckBox("Can receive tips");
        jPanel.add((Component)this.c, "skip 1,newline,grow");
        this.d = new JCheckBox("User is driver");
        jPanel.add((Component)this.d, "skip 1,newline,grow");
        this.e = new JCheckBox("Staff Bank");
        jPanel.add((Component)this.e, "skip 1,newline,grow");
        this.f = new JCheckBox("Auto start staff bank");
        jPanel.add((Component)this.f, "skip 1,newline,grow");
        this.g = new JCheckBox("Blind Accountable Amount");
        jPanel.add((Component)this.g, "skip 1,newline,grow");
        this.h = new JCheckBox("Active");
        jPanel.add((Component)this.h, "skip 1,newline,grow");
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserRoleForm.this.f.setEnabled(UserRoleForm.this.e.isSelected());
                UserRoleForm.this.g.setEnabled(UserRoleForm.this.e.isSelected());
            }
        });
        this.add(jPanel);
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            User user = (User)this.getBean();
            UserDAO userDAO = new UserDAO();
            userDAO.saveOrUpdate(user);
            return true;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
            return false;
        }
    }

    @Override
    protected void updateView() {
        User user = (User)this.getBean();
        this.b.setText(String.valueOf(user.getCostPerHour()));
        this.c.setSelected(user.isAllowReceiveTips());
        this.a.setSelectedItem(user.getType());
        this.e.setSelected(user.isStaffBank());
        this.f.setSelected(user.isAutoStartStaffBank());
        this.g.setSelected(user.isBlindAccountableAmount());
        this.d.setSelected(user.isDriver());
        this.f.setEnabled(this.e.isSelected());
        this.g.setEnabled(this.e.isSelected());
        this.h.setSelected(user.isActive());
    }

    @Override
    protected boolean updateModel() {
        User user = (User)this.getBean();
        UserType userType = (UserType)this.a.getSelectedItem();
        if (userType == null) {
            return false;
        }
        double d = this.b.getDouble();
        if (user.getId() == null) {
            user.setId(GlobalIdGenerator.generateGlobalId().toString());
        }
        user.setCostPerHour(d);
        user.setAllowReceiveTips(this.c.isSelected());
        user.setType(userType);
        user.setStaffBank(this.e.isSelected());
        user.setActive(this.h.isSelected());
        if (this.e.isSelected()) {
            user.setAutoStartStaffBank(this.f.isSelected());
            user.setBlindAccountableAmount(this.g.isSelected());
        } else {
            user.setAutoStartStaffBank(false);
            user.setBlindAccountableAmount(false);
        }
        user.setDriver(this.d.isSelected());
        User user2 = user.getParentUser();
        user.setFirstName(user2.getFirstName());
        user.setLastName(user2.getLastName());
        user.setActive(user2.isActive());
        user.setPhoneNo(user2.getPhoneNo());
        user.setAvailableForDelivery(user2.isAvailableForDelivery());
        user.setImageId(user2.getImageId());
        user.setSsn(user2.getSsn());
        user.setPassword(null);
        user.setLinkedUser(null);
        user.setRoot(false);
        List<User> list = user2.getLinkedUser();
        if (list != null) {
            for (User user3 : list) {
                if (user.getId() != null || !user3.getType().getName().equals(userType.getName())) continue;
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "This role already exists.");
                return false;
            }
        }
        return true;
    }

    @Override
    public String getDisplayText() {
        return "User role";
    }
}

