/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.order;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.PaginatedTableModel;
import java.util.Date;

public class TicketListTableModel
extends PaginatedTableModel {
    public TicketListTableModel() {
        super(new String[]{POSConstants.TICKET_LIST_COLUMN_ID, "TOKEN", POSConstants.TICKET_LIST_COLUMN_TABLE, POSConstants.TICKET_LIST_COLUMN_SERVER, POSConstants.TICKET_LIST_COLUMN_CREATE_DATE, POSConstants.TICKET_LIST_COLUMN_CUSTOMER, POSConstants.TICKET_LIST_COLUMN_DELIVERY_ADDRESS, POSConstants.TICKET_LIST_COLUMN_DELIVERY_DATE, POSConstants.TICKET_LIST_COLUMN_TICKET_TYPE, POSConstants.TICKET_LIST_COLUMN_STATUS, POSConstants.TICKET_LIST_COLUMN_TOTAL, POSConstants.TICKET_LIST_COLUMN_DUE});
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Ticket ticket = (Ticket)this.rows.get(n);
        Terminal terminal = Application.getInstance().getTerminal();
        switch (n2) {
            case 0: {
                return ticket.getId();
            }
            case 1: {
                return ticket.getTokenNo();
            }
            case 2: {
                if (!terminal.isShowTableNumber()) {
                    return ticket.getTableNames();
                }
                return ticket.getTableNumbers();
            }
            case 3: {
                User user = ticket.getOwner();
                if (user == null) {
                    return "";
                }
                return user.getFirstName() + " " + user.getLastName();
            }
            case 4: {
                Date date = ticket.getCreateDate();
                if (date == null) {
                    return "";
                }
                if (DateUtil.isToday(date)) {
                    return DateUtil.formatAsTodayDate(date);
                }
                return DateUtil.formatFullDateAndTimeAsString(date);
            }
            case 5: {
                if (ticket.getCustomerId() != null) {
                    String string = ticket.getProperty("CUSTOMER_NAME");
                    String string2 = ticket.getProperty("CUSTOMER_LAST_NAME");
                    String string3 = "<html><body>" + string + " " + string2 + "</body></html>";
                    return string3;
                }
                String string = ticket.getProperty("CUSTOMER_MOBILE");
                if (string != null) {
                    return string;
                }
                return Messages.getString("TicketListView.6");
            }
            case 6: {
                return ticket.getDeliveryAddress();
            }
            case 7: {
                Date date = ticket.getDeliveryDate();
                if (date == null) {
                    return "";
                }
                if (DateUtil.isToday(date)) {
                    return DateUtil.formatAsTodayDate(date);
                }
                return date;
            }
            case 8: {
                return ticket.getOrderType();
            }
            case 9: {
                String string = "";
                string = ticket.isPaid() != false ? Messages.getString("TicketListView.8") : Messages.getString("TicketListView.9");
                if (ticket.isVoided().booleanValue()) {
                    string = Messages.getString("TicketListView.12");
                } else if (ticket.isClosed().booleanValue()) {
                    string = Messages.getString("TicketListView.13");
                }
                return string;
            }
            case 10: {
                return ticket.getTotalAmountWithTips();
            }
            case 11: {
                return ticket.getDueAmount();
            }
        }
        return null;
    }
}

