/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.actions.CloseDialogAction;
import com.floreantpos.actions.PosAction;
import com.floreantpos.config.GiftCardConfig;
import com.floreantpos.extension.GiftCardPaymentPlugin;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.UserPermission;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.GiftCardInfo;
import com.floreantpos.ui.dialog.GlobalInputDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.GiftCardActivateView;
import com.floreantpos.ui.views.GiftCardAddBalanceView;
import com.floreantpos.ui.views.GiftCardEditPinNumberView;
import com.floreantpos.ui.views.GiftCardTransactionInfoView;
import com.floreantpos.ui.views.payment.GiftCardProcessor;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class GiftCardManagementView
extends POSDialog {
    private PosButton a;
    private PosButton b;
    private PosButton c;
    private PosButton d;
    private PosButton e;
    private PosButton f;
    private PosButton g;
    private GiftCardProcessor h;

    public GiftCardManagementView() {
        super((Frame)POSUtil.getBackOfficeWindow(), "");
        this.b();
        this.a();
    }

    private void a() {
        GiftCardPaymentPlugin giftCardPaymentPlugin = GiftCardConfig.getPaymentGateway();
        this.h = giftCardPaymentPlugin.getProcessor();
        if (giftCardPaymentPlugin != null) {
            if (!this.h.supportActivation()) {
                this.a.setEnabled(false);
            }
            if (!this.h.supportDeActivation()) {
                this.b.setEnabled(false);
            }
            if (!this.h.supportDisable()) {
                this.d.setEnabled(false);
            }
            if (!this.h.supportPinNumberChange()) {
                this.f.setEnabled(false);
            }
            if (!this.h.supportShowTransaction()) {
                this.g.setEnabled(false);
            }
        }
    }

    public GiftCardManagementView(JFrame jFrame) {
        this.b();
        this.a();
    }

    private void b() {
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("GiftCardManagementView.0"));
        this.add((Component)titlePanel, "North");
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx,aligny center", "[]20px[]", ""));
        jPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        GiftCardProcessAction giftCardProcessAction = new GiftCardProcessAction();
        this.a = new PosButton(Messages.getString("GiftCardManagementView.4"), giftCardProcessAction);
        this.b = new PosButton(Messages.getString("GiftCardManagementView.5"), giftCardProcessAction);
        this.c = new PosButton(Messages.getString("GiftCardManagementView.6"), giftCardProcessAction);
        this.d = new PosButton(Messages.getString("GiftCardManagementView.7"), giftCardProcessAction);
        this.e = new PosButton(Messages.getString("GiftCardManagementView.8"), giftCardProcessAction);
        this.f = new PosButton(Messages.getString("GiftCardManagementView.9"), giftCardProcessAction);
        this.g = new PosButton(Messages.getString("GiftCardManagementView.10"), giftCardProcessAction);
        jPanel.add((Component)this.a, "cell 0 0, growx");
        jPanel.add((Component)this.c, "cell 1 0, growx");
        jPanel.add((Component)this.b, "cell 0 1, growx");
        jPanel.add((Component)this.d, "cell 1 1, growx");
        jPanel.add((Component)this.e, "cell 0 2, growx");
        jPanel.add((Component)this.f, "cell 1 2, growx");
        jPanel.add((Component)this.g, "cell 0 3, growx");
        this.add((Component)jPanel, "Center");
        PosButton posButton = new PosButton(new CloseDialogAction(this, Messages.getString("GiftCardManagementView.18")));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("fill"));
        jPanel2.add((Component)posButton, "alignx center");
        this.add((Component)jPanel2, "South");
        this.a.setAction(giftCardProcessAction);
        this.c.setAction(giftCardProcessAction);
        this.b.setAction(giftCardProcessAction);
        this.d.setAction(giftCardProcessAction);
        this.e.setAction(giftCardProcessAction);
        this.f.setAction(giftCardProcessAction);
        this.g.setAction(giftCardProcessAction);
    }

    private void c() {
        GiftCardActivateView giftCardActivateView = new GiftCardActivateView(this.h);
        giftCardActivateView.setTitle(Messages.getString("GiftCardManagementView.28"));
        giftCardActivateView.setDefaultCloseOperation(2);
        giftCardActivateView.setSize(PosUIManager.getSize(600, 400));
        giftCardActivateView.setLocationRelativeTo(POSUtil.getFocusedWindow());
        giftCardActivateView.setVisible(true);
    }

    private void d() {
        GiftCardEditPinNumberView giftCardEditPinNumberView = new GiftCardEditPinNumberView(this.h);
        giftCardEditPinNumberView.setTitle(Messages.getString("GiftCardManagementView.29"));
        giftCardEditPinNumberView.setDefaultCloseOperation(2);
        giftCardEditPinNumberView.setSize(PosUIManager.getSize(600, 400));
        giftCardEditPinNumberView.setLocationRelativeTo(POSUtil.getFocusedWindow());
        giftCardEditPinNumberView.setVisible(true);
    }

    private void e() {
        try {
            GiftCard giftCard = this.i();
            if (giftCard == null) {
                return;
            }
            GiftCardInfo giftCardInfo = new GiftCardInfo(giftCard);
            giftCardInfo.setDefaultCloseOperation(2);
            giftCardInfo.setSize(PosUIManager.getSize(470, 400));
            giftCardInfo.setLocationRelativeTo(POSUtil.getFocusedWindow());
            giftCardInfo.setVisible(true);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void f() {
        try {
            GiftCard giftCard = this.i();
            if (giftCard == null) {
                return;
            }
            int n = POSMessageDialog.showYesNoQuestionDialog(this, Messages.getString("GiftCardDisableView.13"), Messages.getString("GiftCardDisableView.14"));
            if (n == 0) {
                if (giftCard.isDisable().booleanValue()) {
                    POSMessageDialog.showMessage(this, Messages.getString("GiftCardDisableView.15"));
                    return;
                }
                giftCard.setDisable(true);
                giftCard.setActive(false);
                giftCard.setDeActivationDate(new Date());
                this.h.disable(giftCard);
                POSMessageDialog.showMessage(this, Messages.getString("GiftCardDisableView.16"));
                this.dispose();
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void g() {
        GiftCardAddBalanceView giftCardAddBalanceView = new GiftCardAddBalanceView(this.h);
        giftCardAddBalanceView.setTitle(Messages.getString("GiftCardManagementView.32"));
        giftCardAddBalanceView.setDefaultCloseOperation(2);
        giftCardAddBalanceView.setSize(PosUIManager.getSize(600, 400));
        giftCardAddBalanceView.setLocationRelativeTo(POSUtil.getFocusedWindow());
        giftCardAddBalanceView.setVisible(true);
    }

    private void h() {
        try {
            GiftCard giftCard = this.i();
            if (giftCard == null) {
                return;
            }
            int n = POSMessageDialog.showYesNoQuestionDialog(this, Messages.getString("GiftCardDeActiveView.14"), Messages.getString("GiftCardDeActiveView.15"));
            if (n == 0) {
                if (!giftCard.isActive().booleanValue()) {
                    POSMessageDialog.showMessage(this, Messages.getString("GiftCardDeActiveView.16"));
                    return;
                }
                giftCard.setActive(false);
                giftCard.setDeActivationDate(new Date());
                this.h.deactivate(giftCard);
                POSMessageDialog.showMessage(this, Messages.getString("GiftCardDeActiveView.17"));
                this.dispose();
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private GiftCard i() {
        String string = this.k();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        GiftCard giftCard = this.h.getCard(string);
        if (giftCard == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GiftCardDeActiveView.12"));
            return null;
        }
        if (StringUtils.isEmpty((String)string)) {
            MessageDialog.showError(Messages.getString("GiftCardDeActiveView.13"));
            return null;
        }
        return giftCard;
    }

    private void j() {
        try {
            GiftCard giftCard = this.i();
            if (giftCard == null) {
                return;
            }
            GiftCardTransactionInfoView giftCardTransactionInfoView = new GiftCardTransactionInfoView(giftCard, this.h);
            giftCardTransactionInfoView.setTitle(Messages.getString("GiftCardTransactionDialog.16"));
            giftCardTransactionInfoView.setDefaultCloseOperation(2);
            giftCardTransactionInfoView.setSize(PosUIManager.getSize(900, 600));
            giftCardTransactionInfoView.setLocationRelativeTo(POSUtil.getFocusedWindow());
            giftCardTransactionInfoView.setVisible(true);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private String k() {
        GlobalInputDialog globalInputDialog = new GlobalInputDialog();
        globalInputDialog.setCaption(Messages.getString("GiftCardManagementView.1"));
        globalInputDialog.open();
        if (globalInputDialog.isCanceled()) {
            return null;
        }
        String string = globalInputDialog.getInput();
        return string;
    }

    private class GiftCardProcessAction
    extends PosAction {
        public GiftCardProcessAction() {
            super.setRequiredPermission(UserPermission.MANAGE_GIFT_CARD);
        }

        @Override
        public void execute() {
            ActionEvent actionEvent = super.getActionEvent();
            String string = actionEvent.getActionCommand();
            if (string.equals(Messages.getString("GiftCardManagementView.4"))) {
                GiftCardManagementView.this.c();
            } else if (string.equals(Messages.getString("GiftCardManagementView.5"))) {
                GiftCardManagementView.this.h();
            } else if (string.equals(Messages.getString("GiftCardManagementView.6"))) {
                if (!POSUtil.checkDrawerAssignment()) {
                    return;
                }
                GiftCardManagementView.this.g();
            } else if (string.equals(Messages.getString("GiftCardManagementView.7"))) {
                GiftCardManagementView.this.f();
            } else if (string.equals(Messages.getString("GiftCardManagementView.9"))) {
                GiftCardManagementView.this.d();
            } else if (string.equals(Messages.getString("GiftCardManagementView.8"))) {
                GiftCardManagementView.this.e();
            } else if (string.equals(Messages.getString("GiftCardManagementView.34"))) {
                GiftCardManagementView.this.j();
            }
        }
    }
}

