/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.MenuPageItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuPageDAO;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ScrollableFlowPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.SelectionView;
import com.floreantpos.ui.views.order.actions.ItemSelectionListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import org.hibernate.exception.JDBCConnectionException;

public class MenuItemView
extends SelectionView {
    public static final String VIEW_NAME = "ITEM_VIEW";
    private Vector<ItemSelectionListener> a = new Vector();
    private MenuGroup b;

    public MenuItemView() {
        super(POSConstants.ITEMS, new FlowLayout(), PosUIManager.getSize(TerminalConfig.getMenuItemButtonWidth()), PosUIManager.getSize(TerminalConfig.getMenuItemButtonHeight()));
        this.dataModel = new PaginatedListModel();
        this.btnPrev.setText("<< PREVIOUS");
        this.btnNext.setText("NEXT >>");
    }

    public MenuGroup getMenuGroup() {
        return this.b;
    }

    public void setMenuGroup(MenuGroup menuGroup) {
        this.b = menuGroup;
        this.reset();
        if (menuGroup == null) {
            return;
        }
        try {
            Terminal terminal = Application.getInstance().getTerminal();
            OrderType orderType = OrderView.getInstance().getCurrentTicket().getOrderType();
            this.dataModel.setPageSize(1);
            this.dataModel.setCurrentRowIndex(0);
            this.dataModel.setNumRows(MenuPageDAO.getInstance().getRowCount(terminal, menuGroup, (Object)orderType));
            MenuPageDAO.getInstance().loadItems(terminal, menuGroup, orderType, null, this.dataModel);
            this.setDataModel(this.dataModel);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    @Override
    protected void renderItems() {
        this.reset();
        if (this.dataModel.getSize() == 0) {
            this.setTitle(POSConstants.ITEMS);
            this.revalidate();
            this.repaint();
            return;
        }
        this.btnPrev.setText("<< " + POSConstants.CAPITAL_PREV);
        MenuPage menuPage = (MenuPage)this.dataModel.getElementAt(0);
        this.setTitle(menuPage.getName());
        int n = menuPage.getRows();
        int n2 = menuPage.getCols();
        double d = 100.0 / (double)n;
        double d2 = 100.0 / (double)n2;
        MigLayout migLayout = new MigLayout("hidemode 0, center,wrap " + n2);
        if (menuPage.isFlixibleButtonSize().booleanValue()) {
            migLayout.setLayoutConstraints((Object)"fill");
            migLayout.setColumnConstraints((Object)"fill,grow");
            migLayout.setRowConstraints((Object)"fill,grow");
        }
        this.selectionButtonsPanel.setLayout((LayoutManager)migLayout);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                String string = String.format("cell %s %s", j, i);
                string = menuPage.isFlixibleButtonSize() != false ? string + String.format(", w %s, h %s", d, d2) : string + String.format(", w %s!, h %s!", menuPage.getButtonWidth(), menuPage.getButtonHeight());
                MenuPageItem menuPageItem = menuPage.getItemForCell(j, i);
                if (menuPageItem == null) {
                    this.selectionButtonsPanel.add((Component)new JLabel(), string);
                    continue;
                }
                if (!menuPageItem.isVisible().booleanValue()) continue;
                AbstractButton abstractButton = this.createItemButton(menuPageItem);
                this.selectionButtonsPanel.add((Component)abstractButton, string);
            }
        }
        this.revalidate();
        this.repaint();
        this.btnNext.setVisible(this.dataModel.hasNext());
        this.btnPrev.setVisible(this.dataModel.hasPrevious());
    }

    public void rendererVariants(MenuItem menuItem) {
        List<MenuItem> list = menuItem.getVariants();
        this.reset();
        ScrollableFlowPanel scrollableFlowPanel = new ScrollableFlowPanel();
        this.selectionButtonsPanel.setLayout((LayoutManager)new MigLayout("fill"));
        for (MenuItem menuItem2 : list) {
            AbstractButton abstractButton = this.createItemButton(menuItem2);
            if (abstractButton == null) continue;
            scrollableFlowPanel.add(abstractButton);
        }
        PosScrollPane posScrollPane = new PosScrollPane(scrollableFlowPanel);
        posScrollPane.setBorder(null);
        this.selectionButtonsPanel.add((Component)posScrollPane, "span,grow");
        this.revalidate();
        this.repaint();
        this.btnNext.setVisible(false);
        this.btnPrev.setVisible(true);
        this.btnPrev.setText(Messages.getString("MenuItemView.10"));
        this.setTitle(menuItem.getName());
    }

    @Override
    protected AbstractButton createItemButton(Object object) {
        if (object instanceof MenuPageItem) {
            return new PageItemButton((MenuPageItem)object);
        }
        if (object instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)object;
            if (!menuItem.isVisible().booleanValue()) {
                return null;
            }
            menuItem.setMenuGroup(this.b);
            ItemButton itemButton = new ItemButton(menuItem);
            return itemButton;
        }
        return null;
    }

    public void addItemSelectionListener(ItemSelectionListener itemSelectionListener) {
        this.a.add(itemSelectionListener);
    }

    public void removeItemSelectionListener(ItemSelectionListener itemSelectionListener) {
        this.a.remove(itemSelectionListener);
    }

    private void a(MenuItem menuItem) {
        for (ItemSelectionListener itemSelectionListener : this.a) {
            itemSelectionListener.itemSelected(menuItem);
        }
    }

    @Override
    protected void scrollDown() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getNextRowIndex());
        OrderType orderType = OrderView.getInstance().getCurrentTicket().getOrderType();
        MenuPageDAO.getInstance().loadItems(Application.getInstance().getTerminal(), this.b, orderType, (Boolean)false, this.dataModel);
        this.setDataModel(this.dataModel);
    }

    @Override
    protected void scrollUp() {
        if (this.btnPrev.getText().equals(Messages.getString("MenuItemView.10"))) {
            this.renderItems();
            return;
        }
        this.dataModel.setCurrentRowIndex(this.dataModel.getPreviousRowIndex());
        OrderType orderType = OrderView.getInstance().getCurrentTicket().getOrderType();
        MenuPageDAO.getInstance().loadItems(Application.getInstance().getTerminal(), this.b, orderType, (Boolean)false, this.dataModel);
        this.setDataModel(this.dataModel);
    }

    private class PageItemButton
    extends PosButton
    implements ActionListener,
    MouseListener {
        MenuItem a;
        MenuPageItem b;

        PageItemButton(MenuPageItem menuPageItem) {
            Color color;
            this.b = menuPageItem;
            if (menuPageItem == null) {
                this.setVisible(false);
                return;
            }
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            this.setPreferredSize(MenuItemView.this.getButtonSize());
            ImageIcon imageIcon = menuPageItem.getImage(MenuItemView.this.getButtonSize().width, menuPageItem.isShowImageOnly() != false ? MenuItemView.this.getButtonSize().height : 100);
            String string = "<html><body><center>" + menuPageItem.getMenuItemName() + "</center></body></html>";
            if (imageIcon != null) {
                if (menuPageItem.isShowImageOnly().booleanValue()) {
                    this.setIcon(imageIcon);
                } else {
                    this.setIcon(imageIcon);
                    this.setText(string);
                }
            } else {
                this.setText(string);
            }
            Color color2 = menuPageItem.getButtonColor();
            if (color2 != null) {
                this.setBackground(color2);
            }
            if ((color = menuPageItem.getTextColor()) != null) {
                this.setForeground(color);
            }
            this.addActionListener(this);
            this.addMouseListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (OrderView.getInstance().is_86Mode()) {
                return;
            }
            try {
                if (this.a == null) {
                    this.a = new MenuItem(this.b.getMenuItemId());
                }
                MenuItemView.this.a(this.a);
            }
            catch (JDBCConnectionException jDBCConnectionException) {
                POSMessageDialog.showError(Messages.getString("MenuItemView.12"));
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (OrderView.getInstance().is_86Mode()) {
                MenuItem menuItem;
                menuItem.setEnable((menuItem = this.b.getMenuItem()).isEnable() == false);
                this.setEnabled(menuItem.isEnable());
                MenuItemDAO.getInstance().update(menuItem);
                return;
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }

    private class ItemButton
    extends PosButton
    implements ActionListener,
    MouseListener {
        MenuItem a;

        ItemButton(MenuItem menuItem) {
            Color color;
            this.a = menuItem;
            if (menuItem == null) {
                this.setVisible(false);
                return;
            }
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            this.setPreferredSize(MenuItemView.this.getButtonSize());
            ImageIcon imageIcon = menuItem.getImage(MenuItemView.this.getButtonSize().width, menuItem.isShowImageOnly() != false ? MenuItemView.this.getButtonSize().height : 100);
            String string = "<html><body><center>" + menuItem.getDisplayName() + "</center></body></html>";
            if (imageIcon != null) {
                if (menuItem.isShowImageOnly().booleanValue()) {
                    this.setIcon(imageIcon);
                } else {
                    this.setIcon(imageIcon);
                    this.setText(string);
                }
            } else {
                this.setText(string);
            }
            Color color2 = menuItem.getButtonColor();
            if (color2 != null) {
                this.setBackground(color2);
            }
            if ((color = menuItem.getTextColor()) != null) {
                this.setForeground(color);
            }
            this.addActionListener(this);
            this.addMouseListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (OrderView.getInstance().is_86Mode()) {
                return;
            }
            try {
                MenuItemView.this.a(this.a);
            }
            catch (JDBCConnectionException jDBCConnectionException) {
                POSMessageDialog.showError(Messages.getString("MenuItemView.12"));
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (OrderView.getInstance().is_86Mode()) {
                this.a.setEnable(this.a.isEnable() == false);
                this.setEnabled(this.a.isEnable());
                MenuItemDAO.getInstance().update(this.a);
                return;
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

