/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.actions.SettleTicketAction;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.ActionHistory;
import com.floreantpos.model.ComboItem;
import com.floreantpos.model.ComboTicketItem;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BaseMenuItem;
import com.floreantpos.model.base.BaseTicketItemModifier;
import com.floreantpos.model.base.BaseTicketItemSeat;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.AutomatedWeightInputDialog;
import com.floreantpos.ui.dialog.ComboTicketItemSelectionDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.GroupView;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.order.TicketView;
import com.floreantpos.ui.views.order.actions.CategorySelectionListener;
import com.floreantpos.ui.views.order.actions.GroupSelectionListener;
import com.floreantpos.ui.views.order.actions.ItemSelectionListener;
import com.floreantpos.ui.views.order.actions.OrderListener;
import com.floreantpos.ui.views.order.actions.TicketEditListener;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionDialog;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionModel;
import com.floreantpos.ui.views.order.multipart.PizzaModifierSelectionDialog;
import com.floreantpos.ui.views.voidticket.VoidInfoInputDialog;
import com.floreantpos.webservice.CloudDataUploader;
import java.awt.Dialog;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;

public class OrderController
implements CategorySelectionListener,
GroupSelectionListener,
ItemSelectionListener,
OrderListener {
    protected OrderView orderView;
    List<TicketEditListener> a;

    public OrderController(OrderView orderView) {
        this.orderView = orderView;
        orderView.getCategoryView().addCategorySelectionListener(this);
        orderView.getGroupView().addGroupSelectionListener(this);
        orderView.getItemView().addItemSelectionListener(this);
        orderView.getTicketView().addOrderListener(this);
        this.a = new ArrayList<TicketEditListener>();
    }

    @Override
    public void categorySelected(MenuCategory menuCategory) {
        try {
            this.orderView.showView("GROUP_VIEW");
            this.orderView.getGroupView().setMenuCategory(menuCategory);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    @Override
    public void groupSelected(MenuGroup menuGroup) {
        try {
            this.orderView.showView("ITEM_VIEW");
            this.orderView.getItemView().setMenuGroup(menuGroup);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void itemSelected(MenuItem menuItem) {
        try (Session session = null;){
            Serializable serializable;
            Object object;
            Serializable serializable2;
            session = MenuItemDAO.getInstance().createNewSession();
            if (menuItem.getId() != null) {
                menuItem = (MenuItem)session.get(MenuItem.class, (Serializable)((Object)menuItem.getId()));
            }
            if (!this.a(menuItem, 1.0)) {
                return;
            }
            if (menuItem.isVariant().booleanValue()) {
                serializable2 = MenuItemDAO.getInstance().get(menuItem.getParentMenuItemId(), session);
                menuItem.setParentMenuItem((MenuItem)serializable2);
            }
            if (menuItem.isHasVariant().booleanValue() && menuItem.getVariants() != null && menuItem.getVariants().size() > 0) {
                this.orderView.getItemView().rendererVariants(menuItem);
                return;
            }
            serializable2 = this.orderView.getTicketView();
            Ticket ticket = this.orderView.getCurrentTicket();
            double d = 1.0;
            if (menuItem.isFractionalUnit().booleanValue()) {
                d = TerminalConfig.getScaleActivationValue().equals("cas10") ? AutomatedWeightInputDialog.takeDoubleInput(menuItem.getName(), 1.0) : NumberSelectionDialog2.takeDoubleInput(Messages.getString("OrderController.2"), 1.0);
                if (d <= -1.0) {
                    return;
                }
                if (d == 0.0) {
                    POSMessageDialog.showError(Messages.getString("OrderController.3"));
                    return;
                }
            }
            double d2 = 0.0;
            if (menuItem.isEditablePrice().booleanValue()) {
                d2 = NumberSelectionDialog2.takeDoubleInput(Messages.getString("OrderController.5"), menuItem.getPrice());
                if (d2 <= -1.0) {
                    return;
                }
                menuItem.setPrice(d2);
            }
            TicketItem ticketItem = menuItem.convertToTicketItem(ticket, d);
            if (this.orderView.isReturnMode()) {
                object = new VoidInfoInputDialog(ticketItem);
                ((Window)object).setSize(PosUIManager.getSize(400, 600));
                ((POSDialog)object).open();
                if (((POSDialog)object).isCanceled()) {
                    return;
                }
                ticketItem.markVoided(((VoidInfoInputDialog)object).getVoidReason(), ((VoidInfoInputDialog)object).isItemWasted(), ((VoidInfoInputDialog)object).getVoidQuantity());
            }
            if (menuItem.isVariant().booleanValue()) {
                menuItem = menuItem.getParentMenuItem();
            }
            if (menuItem.isComboItem().booleanValue() && !this.a(menuItem, ticketItem)) {
                return;
            }
            ticketItem.setTicket(ticket);
            object = this.orderView.getSelectedSeatNumber();
            if (object instanceof Integer) {
                ticketItem.setSeatNumber((Integer)object);
            } else if (object instanceof TicketItemSeat) {
                serializable = (TicketItemSeat)object;
                ticketItem.setSeat((TicketItemSeat)serializable);
                ticketItem.setSeatNumber(((BaseTicketItemSeat)serializable).getSeatNumber());
            }
            if (menuItem.isPizzaType().booleanValue()) {
                serializable = new PizzaModifierSelectionDialog(ticket, ticketItem, menuItem, false);
                ((Dialog)serializable).setResizable(false);
                if (TerminalConfig.isKioskMode()) {
                    ((POSDialog)serializable).openUndecoratedFullScreen();
                } else {
                    ((POSDialog)serializable).openFullScreen();
                }
                if (((POSDialog)serializable).isCanceled()) {
                    return;
                }
                this.a(ticket, ticketItem);
            } else if (menuItem.hasMandatoryModifiers()) {
                serializable = new ModifierSelectionDialog(new ModifierSelectionModel(ticket, ticketItem, menuItem));
                ((POSDialog)serializable).open();
                if (!((POSDialog)serializable).isCanceled()) {
                    ((TicketView)serializable2).addTicketItem(ticketItem);
                    this.a(ticket, ticketItem);
                }
            } else {
                ((TicketView)serializable2).addTicketItem(ticketItem);
                this.a(ticket, ticketItem);
            }
        }
    }

    private boolean a(MenuItem menuItem, double d) {
        List<TicketItem> list;
        if (menuItem == null || !menuItem.isDisableWhenStockAmountIsZero().booleanValue() || menuItem.isHasVariant().booleanValue()) {
            return true;
        }
        Ticket ticket = this.orderView.getCurrentTicket();
        double d2 = 0.0;
        if (ticket != null && (list = ticket.getTicketItems()) != null) {
            for (TicketItem ticketItem : list) {
                if (!ticketItem.getMenuItemId().equals(menuItem.getId())) continue;
                d2 += ticketItem.getQuantity() - ticketItem.getInventoryAdjustQty();
            }
        }
        d2 += d;
        return !(menuItem.getAvailableUnit() < d2) || POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), Messages.getString("OrderController.6"), Messages.getString("OrderController.7"), Messages.getString("OrderController.8"), Messages.getString("OrderController.9")) == 0;
    }

    public void doEditTicketItemQuantity(Object object) {
        TicketItem ticketItem = (TicketItem)object;
        double d = 0.0;
        d = ticketItem.isFractionalUnit() != false ? NumberSelectionDialog2.takeDoubleInput(Messages.getString("OrderController.10"), Math.abs(ticketItem.getQuantity())) : (double)NumberSelectionDialog2.takeIntInput(Messages.getString("OrderController.10"), Math.abs(ticketItem.getQuantity()));
        if (d < 1.0) {
            return;
        }
        MenuItem menuItem = ticketItem.getMenuItem();
        if (d > ticketItem.getQuantity() && !this.a(menuItem, d - ticketItem.getQuantity())) {
            return;
        }
        if (this.orderView.isReturnMode()) {
            ticketItem.markVoided(Messages.getString("OrderController.12"), false, ticketItem.getQuantity());
        } else {
            if (menuItem != null && menuItem.isComboItem().booleanValue()) {
                this.updateComboTicketItemQuantity(ticketItem, d);
            }
            ticketItem.setQuantity(d);
        }
    }

    public void updateComboTicketItemQuantity(TicketItem ticketItem, double d) {
        List<TicketItem> list = ticketItem.getComboItems();
        double d2 = ticketItem.getQuantity();
        double d3 = d - d2;
        if (list != null) {
            for (TicketItem ticketItem2 : list) {
                ticketItem2.setQuantity(ticketItem2.getQuantity() + d3 * ticketItem2.getQuantity() / d2);
            }
        }
    }

    private boolean a(MenuItem menuItem, TicketItem ticketItem) {
        Serializable serializable;
        ComboTicketItem comboTicketItem = (ComboTicketItem)ticketItem;
        if (menuItem.getComboItems() != null && !menuItem.getComboItems().isEmpty()) {
            serializable = this.orderView.getCurrentTicket();
            for (ComboItem comboItem : menuItem.getComboItems()) {
                POSDialog pOSDialog;
                if (comboItem.getQuantity() == 0.0) continue;
                MenuItem menuItem2 = comboItem.getMenuItem();
                TicketItem ticketItem2 = menuItem2.convertToTicketItem((Ticket)serializable, comboItem.getQuantity());
                ticketItem2.setMenuItem(menuItem2);
                if (menuItem2.hasMandatoryModifiers()) {
                    pOSDialog = new ModifierSelectionDialog(new ModifierSelectionModel((Ticket)serializable, ticketItem2, menuItem2));
                    pOSDialog.open();
                    if (pOSDialog.isCanceled()) {
                        return false;
                    }
                } else if (menuItem.isPizzaType().booleanValue()) {
                    pOSDialog = new PizzaModifierSelectionDialog((Ticket)serializable, ticketItem2, menuItem2, false);
                    pOSDialog.openFullScreen();
                    if (pOSDialog.isCanceled()) {
                        return false;
                    }
                }
                ticketItem2.setMenuItemId(menuItem2.getId());
                ticketItem2.setName(menuItem2.getName());
                ticketItem2.setQuantity(comboItem.getQuantity());
                ticketItem2.setParentTicketItem(comboTicketItem);
                ticketItem2.setTicket(null);
                ticketItem2.setGroupId(null);
                comboTicketItem.addTocomboItems(ticketItem2);
            }
        }
        if (menuItem.getComboGroups() != null && !menuItem.getComboGroups().isEmpty()) {
            serializable = new ComboTicketItemSelectionDialog(menuItem, comboTicketItem);
            ((Dialog)serializable).setTitle(Messages.getString("OrderController.13"));
            ((Window)serializable).setSize(PosUIManager.getSize(1024, 700));
            ((POSDialog)serializable).open();
            if (((POSDialog)serializable).isCanceled()) {
                return false;
            }
        }
        return true;
    }

    public void itemSelectionFinished(MenuGroup menuGroup) {
        GroupView groupView;
        MenuCategory menuCategory = menuGroup.getParent();
        if (!menuCategory.equals((groupView = this.orderView.getGroupView()).getMenuCategory())) {
            groupView.setMenuCategory(menuCategory);
        }
        this.orderView.showView("GROUP_VIEW");
    }

    @Override
    public void payOrderSelected(Ticket ticket) {
        try {
            if (!new SettleTicketAction(ticket).performSettle()) {
                return;
            }
            RootView.getInstance().showDefaultView();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    public static void openModifierDialog(ITicketItem iTicketItem) {
        try {
            ArrayList arrayList;
            List<TicketItemModifier> list;
            Comparable comparable;
            Ticket ticket = OrderView.getInstance().getCurrentTicket();
            TicketItem ticketItem = null;
            if (iTicketItem instanceof TicketItem) {
                ticketItem = (TicketItem)iTicketItem;
            } else if (iTicketItem instanceof TicketItemModifier && (ticketItem = ((BaseTicketItemModifier)(comparable = (TicketItemModifier)iTicketItem)).getTicketItem()) == null) {
                ticketItem = ((BaseTicketItemModifier)comparable).getTicketItem();
            }
            comparable = ticketItem.getMenuItem();
            MenuItemDAO.getInstance().initialize((MenuItem)comparable);
            if (((BaseMenuItem)comparable).isVariant().booleanValue()) {
                comparable = ((MenuItem)comparable).getParentMenuItem();
            }
            if ((list = ticketItem.getTicketItemModifiers()) == null) {
                list = new ArrayList<TicketItemModifier>();
            }
            TicketItem ticketItem2 = ticketItem.clone();
            boolean bl = ticketItem.isPizzaType();
            if (bl) {
                arrayList = new PizzaModifierSelectionDialog(ticket, ticketItem2, (MenuItem)comparable, true);
                ((POSDialog)((Object)arrayList)).openFullScreen();
                if (((POSDialog)((Object)arrayList)).isCanceled()) {
                    return;
                }
                TicketItemModifier ticketItemModifier = ticketItem2.getSizeModifier();
                ticketItemModifier.setTicketItem(ticketItem);
                ticketItem.setSizeModifier(ticketItemModifier);
                ticketItem.setQuantity(ticketItem2.getQuantity());
                ticketItem.setUnitPrice(ticketItem2.getUnitPrice());
            } else {
                arrayList = new ModifierSelectionDialog(new ModifierSelectionModel(ticket, ticketItem2, (MenuItem)comparable));
                ((POSDialog)((Object)arrayList)).open();
                if (((POSDialog)((Object)arrayList)).isCanceled()) {
                    return;
                }
            }
            arrayList = ticketItem2.getTicketItemModifiers();
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            list.clear();
            for (TicketItemModifier ticketItemModifier : arrayList) {
                ticketItemModifier.setTicketItem(ticketItem);
                ticketItem.addToticketItemModifiers(ticketItemModifier);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
        OrderView.getInstance().getTicketView().getTicketViewerTable().updateView();
    }

    public static synchronized void saveOrder(Ticket ticket) {
        if (ticket == null) {
            return;
        }
        TicketDAO.getInstance().saveOrUpdate(ticket);
        CloudDataUploader cloudDataUploader = CloudDataUploader.get();
        cloudDataUploader.sendTicketWithTransactions(ticket.getId());
        boolean bl = ticket.getId() == null;
        ActionHistoryDAO actionHistoryDAO = ActionHistoryDAO.getInstance();
        User user = Application.getCurrentUser();
        if (bl) {
            actionHistoryDAO.saveHistory(user, ActionHistory.NEW_CHECK, POSConstants.RECEIPT_REPORT_TICKET_NO_LABEL + ":" + ticket.getId());
        } else {
            actionHistoryDAO.saveHistory(user, ActionHistory.EDIT_CHECK, POSConstants.RECEIPT_REPORT_TICKET_NO_LABEL + ":" + ticket.getId());
        }
    }

    public static synchronized void closeOrder(Ticket ticket) {
        if (ticket.getOrderType().isCloseOnPaid().booleanValue() || ticket.isPaid().booleanValue()) {
            ticket.setClosed(true);
            ticket.setClosingDate(StoreDAO.getServerTimestamp());
        }
        TicketDAO ticketDAO = new TicketDAO();
        ticketDAO.saveOrUpdate(ticket);
        User user = ticket.getAssignedDriver();
        if (user != null) {
            user.setAvailableForDelivery(true);
            UserDAO.getInstance().saveOrUpdate(user);
        }
    }

    public void addTicketUpdateListener(TicketEditListener ticketEditListener) {
        this.a.add(ticketEditListener);
    }

    public void removeTicketUpdateListener(TicketEditListener ticketEditListener) {
        this.a.remove(ticketEditListener);
    }

    private void a(Ticket ticket, TicketItem ticketItem) {
        for (TicketEditListener ticketEditListener : this.a) {
            ticketEditListener.itemAdded(ticket, ticketItem);
        }
    }

    public void fireTicketEditingStart(Ticket ticket) {
        for (TicketEditListener ticketEditListener : this.a) {
            ticketEditListener.ticketEditingStart(ticket);
        }
    }

    public void fireTicketEditingFinish(Ticket ticket) {
        for (TicketEditListener ticketEditListener : this.a) {
            ticketEditListener.ticketEditingFinish(ticket);
        }
    }
}

