/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order.modifier;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.dao.MenuItemModifierPageDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.SelectionView;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionDialog;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionListener;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionModel;
import com.floreantpos.util.POSUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;

public class ModifierView
extends SelectionView {
    private Vector<ModifierSelectionListener> a = new Vector();
    private ModifierSelectionModel b;
    private MenuItemModifierSpec c;
    private PosButton d = new PosButton(POSConstants.CLEAR);
    private PosButton e = new PosButton(POSConstants.GROUP.toUpperCase() + " DONE");
    private PosButton f = new PosButton(POSConstants.CANCEL);
    private Multiplier g;
    private MultiplierButton h;

    public ModifierView(ModifierSelectionModel modifierSelectionModel) {
        super(POSConstants.MODIFIERS, new FlowLayout(), PosUIManager.getSize(120), PosUIManager.getSize(80));
        this.b = modifierSelectionModel;
        this.dataModel = new PaginatedListModel();
        this.actionButtonPanel.add((Component)this.btnPrev, "grow,split 2,span");
        this.actionButtonPanel.add((Component)this.btnNext, "grow");
        this.a();
        this.b();
    }

    private void a() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("ins 0,fillx,center"));
        List<Multiplier> list = DataProvider.get().getMultiplierList();
        ButtonGroup buttonGroup = new ButtonGroup();
        if (list != null) {
            for (Multiplier multiplier : list) {
                MultiplierButton multiplierButton = new MultiplierButton(multiplier);
                if (multiplier.isDefaultMultiplier().booleanValue()) {
                    this.g = multiplier;
                    this.h = multiplierButton;
                    multiplierButton.setSelected(true);
                }
                jPanel.add((Component)multiplierButton, "grow");
                buttonGroup.add(multiplierButton);
            }
        }
        this.actionButtonPanel.add((Component)jPanel, "newline,span");
    }

    private void b() {
        this.actionButtonPanel.add((Component)this.d, "newline,grow");
        this.actionButtonPanel.add((Component)this.e, "grow");
        this.actionButtonPanel.add((Component)this.f, "grow");
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (ModifierSelectionListener modifierSelectionListener : ModifierView.this.a) {
                    modifierSelectionListener.finishModifierSelection();
                }
            }
        });
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (ModifierSelectionListener modifierSelectionListener : ModifierView.this.a) {
                    modifierSelectionListener.clearModifiers(ModifierView.this.c);
                }
            }
        });
        this.f.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModifierView.this.a(true);
            }
        });
    }

    private void a(boolean bl) {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window instanceof POSDialog) {
            ((POSDialog)window).setCanceled(bl);
            window.dispose();
        }
    }

    public void setModifierGroup(MenuItemModifierSpec menuItemModifierSpec) {
        this.c = menuItemModifierSpec;
        if (menuItemModifierSpec == null) {
            return;
        }
        this.c();
        try {
            this.dataModel.setPageSize(1);
            this.dataModel.setCurrentRowIndex(0);
            this.dataModel.setNumRows(MenuItemModifierPageDAO.getInstance().getRowCount(menuItemModifierSpec.getId()));
            MenuItemModifierPageDAO.getInstance().loadItems(menuItemModifierSpec, this.dataModel);
            this.setDataModel(this.dataModel);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, posException);
        }
    }

    @Override
    public void setDataModel(PaginatedListModel paginatedListModel) {
        this.populateItems();
        super.setDataModel(paginatedListModel);
        this.updateButton();
    }

    @Override
    protected void renderItems() {
        this.updateView();
    }

    protected void populateItems() {
        this.reset();
        if (this.dataModel.getSize() == 0) {
            return;
        }
        MenuItemModifierPage menuItemModifierPage = (MenuItemModifierPage)this.dataModel.getElementAt(0);
        MenuItemModifierPageDAO.getInstance().initializeItems(menuItemModifierPage);
        this.setButtonSize(new Dimension(menuItemModifierPage.getButtonWidth(), menuItemModifierPage.getButtonHeight()));
        Integer n = menuItemModifierPage.getCols();
        MigLayout migLayout = new MigLayout("center,wrap " + n);
        if (menuItemModifierPage.isFlixibleButtonSize().booleanValue()) {
            migLayout.setLayoutConstraints((Object)"fill");
            migLayout.setColumnConstraints((Object)"fill,grow");
            migLayout.setRowConstraints((Object)"fill,grow");
        }
        this.selectionButtonsPanel.setLayout((LayoutManager)migLayout);
        for (int i = 0; i < menuItemModifierPage.getRows(); ++i) {
            for (int j = 0; j < menuItemModifierPage.getCols(); ++j) {
                MenuItemModifierPageItem menuItemModifierPageItem;
                String string = String.format("cell %s %s", j, i);
                if (!menuItemModifierPage.isFlixibleButtonSize().booleanValue()) {
                    string = string + String.format(", w %s!, h %s!", menuItemModifierPage.getButtonWidth(), menuItemModifierPage.getButtonHeight());
                }
                if ((menuItemModifierPageItem = menuItemModifierPage.getItemForCell(j, i)) == null) {
                    this.selectionButtonsPanel.add((Component)new JLabel(), string);
                    continue;
                }
                AbstractButton abstractButton = this.createItemButton(menuItemModifierPageItem);
                if (abstractButton == null) continue;
                this.selectionButtonsPanel.add((Component)abstractButton, string);
            }
        }
        this.revalidate();
        this.repaint();
        this.btnNext.setVisible(this.dataModel.hasNext());
        this.btnPrev.setVisible(this.dataModel.hasPrevious());
    }

    private void c() {
        String string = this.c.getName();
        String string2 = this.c.getInstruction();
        int n = this.c.getMinQuantity();
        int n2 = this.c.getMaxQuantity();
        this.setTitle(string + Messages.getString("ModifierView.2") + n + Messages.getString("ModifierView.3") + n2 + (string2 == null ? "" : " " + string2));
    }

    @Override
    protected AbstractButton createItemButton(Object object) {
        MenuItemModifierPageItem menuItemModifierPageItem = (MenuItemModifierPageItem)object;
        ModifierButton modifierButton = new ModifierButton(menuItemModifierPageItem);
        return modifierButton;
    }

    public void addModifierSelectionListener(ModifierSelectionListener modifierSelectionListener) {
        this.a.add(modifierSelectionListener);
    }

    public void removeModifierSelectionListener(ModifierSelectionListener modifierSelectionListener) {
        this.a.remove(modifierSelectionListener);
    }

    public void updateView() {
        Component[] componentArray = this.selectionButtonsPanel.getComponents();
        if (componentArray == null || componentArray.length == 0) {
            return;
        }
        TicketItem ticketItem = this.b.getTicketItem();
        HashMap<String, TicketItemModifier> hashMap = new HashMap<String, TicketItemModifier>();
        if (ticketItem.getTicketItemModifiers() != null && ticketItem.getTicketItemModifiers().size() > 0) {
            for (TicketItemModifier ticketItemModifier : ticketItem.getTicketItemModifiers()) {
                hashMap.put(ticketItemModifier.getItemId(), ticketItemModifier);
            }
        }
        for (Component component : componentArray) {
            if (component instanceof JLabel) continue;
            ModifierButton modifierButton = (ModifierButton)component;
            MenuItemModifierPageItem menuItemModifierPageItem = modifierButton.e;
            TicketItemModifier ticketItemModifier = (TicketItemModifier)hashMap.get(menuItemModifierPageItem.getMenuModifierId());
            if (ticketItemModifier != null) {
                modifierButton.setText("<html><center>" + menuItemModifierPageItem.getMenuModifierName() + "<br/><span style='color:green;'>(" + ticketItemModifier.getItemQuantity() + ")</span></center></html>");
            } else {
                modifierButton.setText("<html><center>" + menuItemModifierPageItem.getMenuModifierName() + "</center></html>");
            }
            if (ModifierSelectionDialog.isRequiredModifiersAdded(ticketItem, this.c)) {
                this.e.setBackground(Color.green);
                continue;
            }
            this.e.setBackground(UIManager.getColor("Control"));
        }
    }

    @Override
    protected void scrollDown() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getNextRowIndex());
        MenuItemModifierPageDAO.getInstance().loadItems(this.c, this.dataModel);
        this.setDataModel(this.dataModel);
    }

    @Override
    protected void scrollUp() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getPreviousRowIndex());
        MenuItemModifierPageDAO.getInstance().loadItems(this.c, this.dataModel);
        this.setDataModel(this.dataModel);
    }

    private class MultiplierButton
    extends POSToggleButton
    implements ActionListener {
        private Multiplier b;

        public MultiplierButton(Multiplier multiplier) {
            Integer n;
            this.b = multiplier;
            this.setText(multiplier.getId());
            Integer n2 = multiplier.getButtonColor();
            if (n2 != null) {
                this.setBackground(new Color(n2));
            }
            if ((n = multiplier.getTextColor()) != null) {
                this.setForeground(new Color(n));
            }
            this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModifierView.this.g = this.b;
        }

        public Multiplier getMultiplier() {
            return this.b;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.isSelected()) {
                this.setBorder(BorderFactory.createLineBorder(new Color(255, 128, 0), 1));
            } else {
                this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
            }
        }
    }

    private class ModifierButton
    extends PosButton
    implements ActionListener {
        private int b = 100;
        private MenuItemModifierPageItem e;

        public ModifierButton(MenuItemModifierPageItem menuItemModifierPageItem) {
            this.e = menuItemModifierPageItem;
            this.setFocusable(true);
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            this.b = PosUIManager.getSize(100);
            this.setText("<html><center>" + menuItemModifierPageItem.getMenuModifierName() + "</center></html>");
            if (menuItemModifierPageItem.getImage() != null) {
                int n = this.b - PosUIManager.getSize(0);
                int n2 = this.b - PosUIManager.getSize(0);
                if (menuItemModifierPageItem.isShowImageOnly().booleanValue()) {
                    this.setIcon(new ImageIcon(menuItemModifierPageItem.getImage().getImage().getScaledInstance(n, n2, 0)));
                } else {
                    n = PosUIManager.getSize(80);
                    n2 = PosUIManager.getSize(40);
                    this.setIcon(new ImageIcon(menuItemModifierPageItem.getImage().getImage().getScaledInstance(n, n2, 0)));
                    this.setText("<html><body><center>" + menuItemModifierPageItem.getMenuModifierName() + "</center></body></html>");
                }
            } else {
                this.setText("<html><body><center>" + menuItemModifierPageItem.getMenuModifierName() + "</center></body></html>");
            }
            if (menuItemModifierPageItem.getTextColor() != null) {
                this.setForeground(menuItemModifierPageItem.getTextColor());
            }
            if (menuItemModifierPageItem.getButtonColor() != null) {
                this.setBackground(menuItemModifierPageItem.getButtonColor());
            }
            this.setPreferredSize(new Dimension(this.b, this.b));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                for (ModifierSelectionListener modifierSelectionListener : ModifierView.this.a) {
                    String string = this.e.getMenuModifierId();
                    MenuModifier menuModifier = MenuModifierDAO.getInstance().get(string);
                    MenuModifierDAO.getInstance().initialize(menuModifier);
                    menuModifier.setMenuItemModifierGroup(ModifierView.this.c);
                    modifierSelectionListener.modifierSelected(menuModifier, ModifierView.this.g);
                }
                if (ModifierView.this.h != null) {
                    ModifierView.this.h.setSelected(true);
                    ModifierView.this.g = ModifierView.this.h.getMultiplier();
                }
            }
            catch (Exception exception) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
            }
        }
    }
}

