/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.config.CardConfig;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.ui.views.payment.CardProcessor;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import net.authorize.DeviceType;
import net.authorize.Environment;
import net.authorize.MarketType;
import net.authorize.Merchant;
import net.authorize.ResponseReasonCode;
import net.authorize.TransactionType;
import net.authorize.aim.Transaction;
import net.authorize.aim.cardpresent.Result;
import net.authorize.api.contract.v1.CreateTransactionRequest;
import net.authorize.api.contract.v1.CreateTransactionResponse;
import net.authorize.api.contract.v1.CreditCardType;
import net.authorize.api.contract.v1.MerchantAuthenticationType;
import net.authorize.api.contract.v1.MessageTypeEnum;
import net.authorize.api.contract.v1.MessagesType;
import net.authorize.api.contract.v1.PaymentType;
import net.authorize.api.contract.v1.TransactionRequestType;
import net.authorize.api.contract.v1.TransactionResponse;
import net.authorize.api.contract.v1.TransactionTypeEnum;
import net.authorize.api.controller.CreateTransactionController;
import net.authorize.api.controller.base.ApiOperationBase;
import net.authorize.data.creditcard.CardType;
import net.authorize.data.creditcard.CreditCard;
import org.apache.commons.lang.StringUtils;
import us.fatehi.magnetictrack.bankcard.BankCardMagneticTrack;

public class AuthorizeDotNetProcessor
implements CardProcessor {
    private static final String a = "authorize.net.trans.key";
    private static final String b = "authorize.net.login.id";

    @Override
    public void preAuth(PosTransaction posTransaction) throws Exception {
        Environment environment = this.a();
        Merchant merchant = this.a(environment, posTransaction);
        CreditCard creditCard = this.a(posTransaction);
        Transaction transaction = merchant.createAIMTransaction(TransactionType.AUTH_ONLY, new BigDecimal(posTransaction.calculateAuthorizeAmount()));
        transaction.setCreditCard(creditCard);
        Result result = (Result)merchant.postTransaction((net.authorize.Transaction)transaction);
        if (!result.isApproved()) {
            if (result.isDeclined()) {
                throw new Exception(Messages.getString("AuthorizeDotNetProcessor.2") + ((ResponseReasonCode)result.getResponseReasonCodes().get(0)).getReasonText());
            }
            throw new Exception(Messages.getString("AuthorizeDotNetProcessor.3") + ((ResponseReasonCode)result.getResponseReasonCodes().get(0)).getReasonText());
        }
        posTransaction.setCardTransactionId(result.getTransId());
        posTransaction.setCardAuthCode(result.getAuthCode());
        this.a(posTransaction, (Result<Transaction>)result);
    }

    @Override
    public void chargeAmount(PosTransaction posTransaction) throws Exception {
        Environment environment = this.a();
        Merchant merchant = this.a(environment, posTransaction);
        CreditCard creditCard = this.a(posTransaction);
        Transaction transaction = merchant.createAIMTransaction(TransactionType.AUTH_CAPTURE, new BigDecimal(posTransaction.getAmount()));
        transaction.setCreditCard(creditCard);
        Result result = (Result)merchant.postTransaction((net.authorize.Transaction)transaction);
        if (!result.isApproved()) {
            if (result.isDeclined()) {
                throw new Exception(Messages.getString("AuthorizeDotNetProcessor.2") + ((ResponseReasonCode)result.getResponseReasonCodes().get(0)).getReasonText());
            }
            throw new Exception(Messages.getString("AuthorizeDotNetProcessor.3") + ((ResponseReasonCode)result.getResponseReasonCodes().get(0)).getReasonText());
        }
        posTransaction.setCaptured(true);
        posTransaction.setAuthorizable(false);
        posTransaction.setCardTransactionId(result.getTransId());
        posTransaction.setCardAuthCode(result.getAuthCode());
        this.a(posTransaction, (Result<Transaction>)result);
    }

    @Override
    public void captureAuthAmount(PosTransaction posTransaction) throws Exception {
        Environment environment = this.a();
        Merchant merchant = this.a(environment, posTransaction);
        Transaction transaction = merchant.createAIMTransaction(TransactionType.PRIOR_AUTH_CAPTURE, new BigDecimal(posTransaction.getAmount()));
        transaction.setTransactionId(posTransaction.getCardTransactionId());
        Result result = (Result)merchant.postTransaction((net.authorize.Transaction)transaction);
        if (!result.isApproved()) {
            if (result.isDeclined()) {
                throw new Exception(Messages.getString("AuthorizeDotNetProcessor.6") + ((ResponseReasonCode)result.getResponseReasonCodes().get(0)).getReasonText());
            }
            throw new Exception(Messages.getString("AuthorizeDotNetProcessor.7") + ((ResponseReasonCode)result.getResponseReasonCodes().get(0)).getReasonText());
        }
        posTransaction.setCardTransactionId(result.getTransId());
        posTransaction.setCardAuthCode(result.getAuthCode());
        this.a(posTransaction, (Result<Transaction>)result);
    }

    public void captureNewAmount(PosTransaction posTransaction) throws Exception {
        Environment environment = this.a();
        Merchant merchant = this.a(environment, posTransaction);
        CreditCard creditCard = this.a(posTransaction);
        Transaction transaction = merchant.createAIMTransaction(TransactionType.AUTH_CAPTURE, new BigDecimal(posTransaction.getAmount()));
        transaction.setCreditCard(creditCard);
        Result result = (Result)merchant.postTransaction((net.authorize.Transaction)transaction);
        if (!result.isApproved()) {
            if (result.isDeclined()) {
                throw new Exception(Messages.getString("AuthorizeDotNetProcessor.8") + ((ResponseReasonCode)result.getResponseReasonCodes().get(0)).getReasonText());
            }
            throw new Exception(Messages.getString("AuthorizeDotNetProcessor.9") + ((ResponseReasonCode)result.getResponseReasonCodes().get(0)).getReasonText());
        }
        posTransaction.setCardTransactionId(result.getTransId());
        posTransaction.setCardAuthCode(result.getAuthCode());
        this.a(posTransaction, (Result<Transaction>)result);
    }

    public void voidAmount(PosTransaction posTransaction) throws Exception {
        Environment environment = this.a();
        Merchant merchant = this.a(environment, posTransaction);
        Transaction transaction = merchant.createAIMTransaction(TransactionType.VOID, new BigDecimal(posTransaction.getAmount()));
        transaction.setTransactionId(posTransaction.getCardTransactionId());
        Result result = (Result)merchant.postTransaction((net.authorize.Transaction)transaction);
        if (!result.isApproved()) {
            if (result.isDeclined()) {
                throw new Exception(Messages.getString("AuthorizeDotNetProcessor.10") + ((ResponseReasonCode)result.getResponseReasonCodes().get(0)).getReasonText());
            }
            throw new Exception(Messages.getString("AuthorizeDotNetProcessor.11") + ((ResponseReasonCode)result.getResponseReasonCodes().get(0)).getReasonText());
        }
        posTransaction.setCardTransactionId(result.getTransId());
        posTransaction.setCardAuthCode(result.getAuthCode());
        this.a(posTransaction, (Result<Transaction>)result);
    }

    private CreditCard a(PosTransaction posTransaction) {
        CreditCard creditCard = CreditCard.createCreditCard();
        String string = posTransaction.getCardType();
        creditCard.setCardType(CardType.findByValue((String)string));
        if (StringUtils.isNotEmpty((String)posTransaction.getCardTrack())) {
            return this.a(posTransaction.getCardTrack(), string);
        }
        String string2 = posTransaction.getCardNumber();
        String string3 = posTransaction.getCardExpMonth();
        String string4 = posTransaction.getCardExpYear();
        this.a(string2, string3, string4);
        return this.a(string2, string3, string4, string);
    }

    private void a(String string, String string2, String string3) {
        List<String> list = Arrays.asList(string, string2, string3);
        for (String string4 : list) {
            if (!StringUtils.isEmpty((String)string4)) continue;
            throw new PosException(Messages.getString("AuthorizeDotNetProcessor.16"));
        }
    }

    private CreditCard a(String string, String string2) {
        CreditCard creditCard = CreditCard.createCreditCard();
        creditCard.setCardType(CardType.findByValue((String)string2));
        String[] stringArray = string.split(";");
        creditCard.setTrack1(stringArray[0]);
        if (stringArray.length > 1) {
            creditCard.setTrack2(";" + stringArray[1]);
        }
        return creditCard;
    }

    private CreditCard a(String string, String string2, String string3, String string4) {
        CreditCard creditCard = CreditCard.createCreditCard();
        creditCard.setCardType(CardType.findByValue((String)string4));
        creditCard.setExpirationYear(string3);
        creditCard.setExpirationMonth(string2);
        creditCard.setCreditCardNumber(string);
        return creditCard;
    }

    private Merchant a(Environment environment, PosTransaction posTransaction) throws Exception {
        String string = posTransaction.getProperty(b, CardConfig.getMerchantAccount());
        String string2 = posTransaction.getProperty(a, CardConfig.getMerchantPass());
        Merchant merchant = Merchant.createMerchant((Environment)environment, (String)string, (String)string2);
        merchant.setDeviceType(DeviceType.VIRTUAL_TERMINAL);
        merchant.setMarketType(MarketType.RETAIL);
        posTransaction.addProperty(b, string);
        posTransaction.addProperty(a, string2);
        ApiOperationBase.setEnvironment((Environment)environment);
        MerchantAuthenticationType merchantAuthenticationType = new MerchantAuthenticationType();
        merchantAuthenticationType.setName(string);
        merchantAuthenticationType.setTransactionKey(string2);
        ApiOperationBase.setMerchantAuthentication((MerchantAuthenticationType)merchantAuthenticationType);
        return merchant;
    }

    private Environment a() {
        Environment environment = Environment.PRODUCTION;
        if (CardConfig.isSandboxMode()) {
            environment = Environment.SANDBOX;
        }
        return environment;
    }

    public static void main(String[] stringArray) throws Exception {
        BankCardMagneticTrack bankCardMagneticTrack = BankCardMagneticTrack.from((String)"%B4111111111111111^SHAH/RIAR^1803101000000000020000831000000?;4111111111111111=1803101000020000831?");
    }

    @Override
    public void voidTransaction(PosTransaction posTransaction) throws Exception {
        Environment environment = this.a();
        Merchant merchant = this.a(environment, posTransaction);
        Transaction transaction = merchant.createAIMTransaction(TransactionType.VOID, new BigDecimal(posTransaction.getAmount()));
        transaction.setTransactionId(posTransaction.getCardTransactionId());
        Result result = (Result)merchant.postTransaction((net.authorize.Transaction)transaction);
        if (!result.isApproved()) {
            if (result.isDeclined()) {
                throw new Exception(Messages.getString("AuthorizeDotNetProcessor.10") + ((ResponseReasonCode)result.getResponseReasonCodes().get(0)).getReasonText());
            }
            throw new Exception(Messages.getString("AuthorizeDotNetProcessor.11") + ((ResponseReasonCode)result.getResponseReasonCodes().get(0)).getReasonText());
        }
        posTransaction.setCardTransactionId(result.getTransId());
        posTransaction.setCardAuthCode(result.getAuthCode());
        posTransaction.setVoided(true);
        this.a(posTransaction, (Result<Transaction>)result);
    }

    @Override
    public String getCardInformationForReceipt(PosTransaction posTransaction) {
        return null;
    }

    private void a(PosTransaction posTransaction, Result<Transaction> result) {
        CreditCard creditCard;
        if (result.getTarget() != null && (creditCard = ((Transaction)result.getTarget()).getCreditCard()) != null) {
            posTransaction.setCardType(creditCard.getCardType().name());
            posTransaction.setCardNumber(creditCard.getCreditCardNumber());
            if (StringUtils.isNotEmpty((String)creditCard.getTrack1())) {
                String string = "%" + creditCard.getTrack1() + "?;" + creditCard.getTrack2() + "?";
                BankCardMagneticTrack bankCardMagneticTrack = BankCardMagneticTrack.from((String)string);
                posTransaction.setCardHolderName(bankCardMagneticTrack.getTrack1().getName().toString());
                posTransaction.setCardExpYear(creditCard.getExpirationYear());
                posTransaction.setCardExpMonth(creditCard.getExpirationMonth());
            }
        }
    }

    @Override
    public void cancelTransaction() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void refundTransaction(PosTransaction posTransaction, double d) throws Exception {
        this.a(this.a(), posTransaction);
        PaymentType paymentType = new PaymentType();
        CreditCardType creditCardType = new CreditCardType();
        creditCardType.setCardNumber(posTransaction.getCardNumber().replaceAll("X", ""));
        creditCardType.setExpirationDate("XXXX");
        paymentType.setCreditCard(creditCardType);
        TransactionRequestType transactionRequestType = new TransactionRequestType();
        transactionRequestType.setTransactionType(TransactionTypeEnum.REFUND_TRANSACTION.value());
        transactionRequestType.setRefTransId(posTransaction.getCardTransactionId());
        transactionRequestType.setAmount(new BigDecimal(String.valueOf(d)));
        transactionRequestType.setPayment(paymentType);
        CreateTransactionRequest createTransactionRequest = new CreateTransactionRequest();
        createTransactionRequest.setTransactionRequest(transactionRequestType);
        CreateTransactionController createTransactionController = new CreateTransactionController(createTransactionRequest);
        createTransactionController.execute();
        CreateTransactionResponse createTransactionResponse = (CreateTransactionResponse)createTransactionController.getApiResponse();
        if (createTransactionResponse == null) throw new Exception(Messages.getString("AuthorizeDotNetProcessor.11") + Messages.getString("AuthorizeDotNetProcessor.38"));
        String string = "";
        if (createTransactionResponse.getMessages().getResultCode() == MessageTypeEnum.OK) {
            TransactionResponse transactionResponse = createTransactionResponse.getTransactionResponse();
            if (transactionResponse.getMessages() != null) {
                posTransaction.setRefunded(true);
                PosLog.info(this.getClass(), "Successfully created transaction with Transaction ID: " + transactionResponse.getTransId());
                PosLog.info(this.getClass(), "Response Code: " + transactionResponse.getResponseCode());
                PosLog.info(this.getClass(), "Message Code: " + ((TransactionResponse.Messages.Message)transactionResponse.getMessages().getMessage().get(0)).getCode());
                PosLog.info(this.getClass(), "Description: " + ((TransactionResponse.Messages.Message)transactionResponse.getMessages().getMessage().get(0)).getDescription());
                PosLog.info(this.getClass(), "Auth Code: " + transactionResponse.getAuthCode());
                return;
            }
            PosLog.info(this.getClass(), "Failed Transaction.");
            if (createTransactionResponse.getTransactionResponse().getErrors() == null) return;
            PosLog.info(this.getClass(), "Error Code: " + ((TransactionResponse.Errors.Error)createTransactionResponse.getTransactionResponse().getErrors().getError().get(0)).getErrorCode());
            string = ((TransactionResponse.Errors.Error)createTransactionResponse.getTransactionResponse().getErrors().getError().get(0)).getErrorText();
            PosLog.info(this.getClass(), "Error message: " + string);
            throw new Exception(Messages.getString("AuthorizeDotNetProcessor.11") + string);
        }
        PosLog.info(this.getClass(), "Failed Transaction.");
        if (createTransactionResponse.getTransactionResponse() != null && createTransactionResponse.getTransactionResponse().getErrors() != null) {
            string = ((TransactionResponse.Errors.Error)createTransactionResponse.getTransactionResponse().getErrors().getError().get(0)).getErrorText();
            PosLog.info(this.getClass(), "Error Code: " + ((TransactionResponse.Errors.Error)createTransactionResponse.getTransactionResponse().getErrors().getError().get(0)).getErrorCode());
            PosLog.info(this.getClass(), "Error message: " + string);
            throw new Exception(Messages.getString("AuthorizeDotNetProcessor.11") + string);
        }
        string = ((MessagesType.Message)createTransactionResponse.getMessages().getMessage().get(0)).getText();
        PosLog.info(this.getClass(), "Error Code: " + ((MessagesType.Message)createTransactionResponse.getMessages().getMessage().get(0)).getCode());
        PosLog.info(this.getClass(), "Error message: " + string);
        throw new Exception(Messages.getString("AuthorizeDotNetProcessor.11") + string);
    }
}

