/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.main.Application;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PasswordEntryDialog;
import com.floreantpos.ui.kitchendisplay.LineDisplayWindow;
import com.floreantpos.util.NumberUtil;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;
import javax.sql.rowset.serial.SerialBlob;
import javax.swing.FocusManager;
import org.apache.commons.lang.StringUtils;

public class POSUtil {
    public static Window getFocusedWindow() {
        return FocusManager.getCurrentManager().getFocusedWindow();
    }

    public static Frame getFocusedFrame() {
        return (Frame)FocusManager.getCurrentManager().getFocusedWindow();
    }

    public static Image getScaledImage(Image image, int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(image, 0, 0, n, n2, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static BackOfficeWindow getBackOfficeWindow() {
        return BackOfficeWindow.getInstance();
    }

    public static LineDisplayWindow getLineDisplayWindow() {
        Window[] windowArray;
        for (Window window : windowArray = Window.getWindows()) {
            if (!(window instanceof LineDisplayWindow)) continue;
            return (LineDisplayWindow)window;
        }
        return null;
    }

    public static boolean isBlankOrNull(String string) {
        if (string == null) {
            return true;
        }
        return string.trim().equals("");
    }

    public static String escapePropertyKey(String string) {
        return string.replaceAll("\\s+", "_");
    }

    public static boolean getBoolean(String string) {
        if (string == null) {
            return false;
        }
        return Boolean.valueOf(string);
    }

    public static boolean getBoolean(Boolean bl) {
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public static boolean getBoolean(Boolean bl, boolean bl2) {
        if (bl == null) {
            return bl2;
        }
        return bl;
    }

    public static double getDouble(Double d) {
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    public static Integer getInteger(Object object) {
        if (object != null && object instanceof Number) {
            return ((Number)object).intValue();
        }
        return 0;
    }

    public static double getDoubleAmount(Object object) {
        if (object != null && object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return 0.0;
    }

    public static double getRoundedDouble(Object object) {
        if (object != null && object instanceof Number) {
            return NumberUtil.round(((Number)object).doubleValue());
        }
        return 0.0;
    }

    public static int getInteger(Integer n) {
        if (n == null) {
            return 0;
        }
        return n;
    }

    public static int parseInteger(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static int parseInteger(String string, String string2) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw new PosException(string2);
        }
    }

    public static double parseDouble(String string) {
        try {
            return Double.parseDouble(string);
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public static double parseDouble(String string, String string2, boolean bl) {
        try {
            return Double.parseDouble(string);
        }
        catch (Exception exception) {
            if (bl) {
                throw new PosException(string2);
            }
            return 0.0;
        }
    }

    public static String encodeURLString(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static boolean isValidPassword(char[] cArray) {
        for (char c : cArray) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkDrawerAssignment() {
        Terminal terminal = Application.getInstance().getTerminal();
        User user = Application.getCurrentUser();
        return POSUtil.checkDrawerAssignment(terminal, user);
    }

    public static boolean checkDrawerAssignment(Terminal terminal, User user) {
        if (TerminalDAO.getInstance().isDrawerAssigned(terminal)) {
            return true;
        }
        if (user.isStaffBank().booleanValue() && user.isStaffBankStarted().booleanValue()) {
            return true;
        }
        POSUtil.a();
        return false;
    }

    private static void a() {
        POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("SwitchboardView.18"));
    }

    public static Blob convertImageToBlob(File file) throws Exception {
        int n;
        if (file == null) {
            return null;
        }
        BufferedImage bufferedImage = ImageIO.read(file);
        if (bufferedImage.getWidth() > 400 || bufferedImage.getHeight() > 400) {
            int n2 = bufferedImage.getType() == 0 ? 2 : bufferedImage.getType();
            bufferedImage = POSUtil.a(bufferedImage, 400, 400, n2);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(50000);
        String string = file.getName();
        String string2 = string.substring((n = string.lastIndexOf(".")) + 1);
        if (string2.equals("jpg")) {
            ImageIO.write((RenderedImage)bufferedImage, "jpg", byteArrayOutputStream);
        } else if (string2.equals("jpeg")) {
            ImageIO.write((RenderedImage)bufferedImage, "jpeg", byteArrayOutputStream);
        } else if (string2.equals("png")) {
            ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        } else {
            ImageIO.write((RenderedImage)bufferedImage, "gif", byteArrayOutputStream);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (byArray.length > 500000) {
            throw new RuntimeException(Messages.getString("POSUtil.0"));
        }
        return new SerialBlob(byArray);
    }

    public static Blob convertImageToBlob(BufferedImage bufferedImage, String string) throws Exception {
        if (bufferedImage == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(50000);
        if (string.equals("jpg")) {
            ImageIO.write((RenderedImage)bufferedImage, "jpg", byteArrayOutputStream);
        } else if (string.equals("jpeg")) {
            ImageIO.write((RenderedImage)bufferedImage, "jpeg", byteArrayOutputStream);
        } else if (string.equals("png")) {
            ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        } else {
            ImageIO.write((RenderedImage)bufferedImage, "gif", byteArrayOutputStream);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (byArray.length > 500000) {
            throw new RuntimeException(Messages.getString("POSUtil.0"));
        }
        return new SerialBlob(byArray);
    }

    public static Blob convertScaledImageToBlob(File file) throws Exception {
        int n;
        if (file == null) {
            return null;
        }
        int n2 = 120;
        int n3 = 120;
        BufferedImage bufferedImage = ImageIO.read(file);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(50000);
        int n4 = bufferedImage.getType() == 0 ? 2 : bufferedImage.getType();
        BufferedImage bufferedImage2 = POSUtil.a(bufferedImage, n2, n3, n4);
        String string = file.getName();
        String string2 = string.substring((n = string.lastIndexOf(".")) + 1);
        if (string2.equals("jpg")) {
            ImageIO.write((RenderedImage)bufferedImage2, "jpg", byteArrayOutputStream);
        } else if (string2.equals("jpeg")) {
            ImageIO.write((RenderedImage)bufferedImage2, "jpeg", byteArrayOutputStream);
        } else if (string2.equals("png")) {
            ImageIO.write((RenderedImage)bufferedImage2, "png", byteArrayOutputStream);
        } else {
            ImageIO.write((RenderedImage)bufferedImage2, "gif", byteArrayOutputStream);
        }
        return new SerialBlob(byteArrayOutputStream.toByteArray());
    }

    private static BufferedImage a(BufferedImage bufferedImage, int n, int n2, int n3) {
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, n3);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(bufferedImage, 0, 0, n, n2, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static User getUserWithPermission(UserPermission userPermission) {
        String string = PasswordEntryDialog.show(Application.getPosWindow(), Messages.getString("PosAction.0"));
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        User user = UserDAO.getInstance().findUserBySecretKey(string);
        if (user == null) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("PosAction.1"));
            return null;
        }
        if (!user.hasPermission(userPermission)) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("PosAction.2"));
            return null;
        }
        return user;
    }

    public static void storeLongProperty(Map<String, String> map, String string, String string2, int n) {
        block4: {
            String string3;
            String string42;
            Set<String> set = map.keySet();
            HashSet<String> hashSet = new HashSet<String>();
            for (String string42 : set) {
                if (!string42.startsWith(string)) continue;
                hashSet.add(string42);
            }
            for (String string42 : hashSet) {
                map.remove(string42);
            }
            if (string2.length() <= n) {
                map.put(string + "1", string2);
                return;
            }
            int n2 = 1;
            string42 = "";
            do {
                string42 = string2.substring(0, n);
                string2 = string2.substring(n);
                string3 = string + n2++;
                map.put(string3, string42);
            } while (string2.length() >= n);
            if (!StringUtils.isNotEmpty((String)string2)) break block4;
            string3 = string + n2++;
            map.put(string3, string2);
        }
    }

    public static String readLongProperty(Map<String, String> map, String string) {
        String string2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        StringBuilder stringBuilder = new StringBuilder();
        Set<String> set = map.keySet();
        for (String object : set) {
            if (!object.startsWith(string)) continue;
            string2 = object.replaceAll(string, "");
            try {
                arrayList.add(Integer.parseInt(string2));
            }
            catch (Exception exception) {}
        }
        Collections.sort(arrayList);
        for (Integer n : arrayList) {
            string2 = map.get(string + n);
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public static void removeLongProperty(Map<String, String> map, String string) {
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            if (!entry.getKey().startsWith(string)) continue;
            iterator.remove();
        }
    }

    public static Set copySelectedValues(Set linkedHashSet, Set set) {
        if (linkedHashSet == null) {
            linkedHashSet = new LinkedHashSet();
            linkedHashSet.addAll(set);
            return linkedHashSet;
        }
        Iterator iterator = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (set.contains(e)) continue;
            iterator.remove();
        }
        linkedHashSet.addAll(set);
        return linkedHashSet;
    }

    public static List copySelectedValues(List arrayList, List list) {
        if (arrayList == null) {
            arrayList = new ArrayList();
            arrayList.addAll(list);
            return arrayList;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (list.contains(e)) continue;
            iterator.remove();
        }
        arrayList.addAll(list);
        return arrayList;
    }

    public static byte[] compress(String string) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length());
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        gZIPOutputStream.write(string.getBytes());
        gZIPOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return byArray;
    }

    public static String decompress(byte[] byArray) throws IOException {
        String string;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)gZIPInputStream, "UTF-8"));
        StringBuilder stringBuilder = new StringBuilder();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string);
        }
        bufferedReader.close();
        gZIPInputStream.close();
        byteArrayInputStream.close();
        return stringBuilder.toString();
    }
}

