/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.rest.service.mqtt;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.config.AppConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.Store;
import com.floreantpos.util.POSUtil;
import com.orocube.rest.service.mqtt.OroMqttMessageReceiver;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public class OroMqttClient
extends OroMqttMessageReceiver {
    private MqttClient oroMqttClient;
    private int qos = 0;
    private static OroMqttClient instance;
    private String storeUniqueId;
    private String deviceId;

    private OroMqttClient() {
    }

    public static OroMqttClient getInstance() {
        if (instance == null) {
            instance = new OroMqttClient();
        }
        return instance;
    }

    public MqttClient getMqttClient() {
        return OroMqttClient.getInstance().oroMqttClient;
    }

    public boolean isConnectedToServer() {
        return this.oroMqttClient.isConnected();
    }

    public void initMqttClient(String string) throws Exception {
        if (Application.getInstance().isDevelopmentMode()) {
            this.initMqttClient(string, new DebugCallbackHandler());
        } else {
            this.initMqttClient(string, null);
        }
    }

    public void initMqttClient(String string, MqttCallback mqttCallback) throws Exception {
        this.deviceId = string;
        String string2 = "tcp://siiopa.com:1883";
        this.oroMqttClient = new MqttClient(string2, this.deviceId, (MqttClientPersistence)new MemoryPersistence());
        MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
        mqttConnectOptions.setCleanSession(true);
        mqttConnectOptions.setConnectionTimeout(2000);
        mqttConnectOptions.setAutomaticReconnect(true);
        mqttConnectOptions.setKeepAliveInterval(120);
        this.oroMqttClient.setCallback(mqttCallback);
        this.oroMqttClient.connect(mqttConnectOptions);
        this.subscribe();
    }

    public void subscribe() throws Exception {
        Application application = Application.getInstance();
        String string = "";
        Store store = application.getStore();
        if (application != null && store != null) {
            string = store.getUuid();
        }
        this.storeUniqueId = AppConfig.getString("store_uuid", string) + "/";
        this.oroMqttClient.subscribe(this.storeUniqueId + "public", this.qos, (IMqttMessageListener)this);
    }

    public void subscribeToStore(String string, int n, IMqttMessageListener iMqttMessageListener) throws Exception {
        this.subscribe(this.storeUniqueId + string, n, iMqttMessageListener);
    }

    public void subscribe(String string, int n, IMqttMessageListener iMqttMessageListener) throws Exception {
        if (!this.oroMqttClient.isConnected()) {
            throw new PosException(Messages.getString("OroMqttClient.4"));
        }
        PosLog.debug(this.getClass(), "subscribing to topic: " + string);
        this.oroMqttClient.subscribe(string, n, iMqttMessageListener);
    }

    protected void showMqttNotification(String string) {
        PosLog.info(this.getClass(), string);
    }

    public void publishOnThread(String string, String string2) {
        this.publishData(string, string2);
    }

    public void publishData(String string, String string2) {
        this.publishData(string, string2, false);
    }

    public void publishData(String string, String string2, boolean bl) {
        try {
            if (!this.isConnectedToServer()) {
                return;
            }
            PosLog.debug(this.getClass(), "publishing to topic: " + this.storeUniqueId + string);
            this.oroMqttClient.publish(this.storeUniqueId + string, bl ? POSUtil.compress(string2) : string2.getBytes(), this.qos, false);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), "Notification service error. " + exception.getMessage());
        }
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    protected void debug(String string) {
        PosLog.debug(OroMqttClient.class, string);
    }

    class DebugCallbackHandler
    implements MqttCallback {
        DebugCallbackHandler() {
        }

        public void connectionLost(Throwable throwable) {
            PosLog.debug(this.getClass(), "mqtt connection lost");
        }

        public void deliveryComplete(IMqttDeliveryToken iMqttDeliveryToken) {
            PosLog.debug(this.getClass(), "mqtt delivery complete");
        }

        public void messageArrived(String string, MqttMessage mqttMessage) throws Exception {
            PosLog.debug(this.getClass(), "message arrived. topic: " + string + ", message: " + mqttMessage);
        }
    }
}

