/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.base.BaseTicketItem;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.ReorderDialog;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;
import java.awt.Dialog;
import java.awt.Window;
import java.util.List;
import javax.swing.JDialog;

public class ReorderTicketAction
extends PosAction {
    private Ticket a;

    public ReorderTicketAction(Ticket ticket) {
        this.a = ticket;
    }

    public ReorderTicketAction(DataChangeListener dataChangeListener) {
        super(Messages.getString("ReorderTicketAction.0"), dataChangeListener);
    }

    @Override
    public void execute() {
        try {
            List<TicketItem> list;
            Object object;
            if (this.listener != null) {
                object = this.getSelectedObject();
                if (object == null) {
                    return;
                }
                if (object instanceof Ticket) {
                    this.a = (Ticket)object;
                }
            }
            this.a = TicketDAO.getInstance().loadFullTicket(this.a.getId());
            object = this.a.clone(this.a);
            List<TicketItem> list2 = ((Ticket)object).getTicketItems();
            Object object2 = list2.iterator();
            while (object2.hasNext()) {
                list = object2.next();
                if (((BaseTicketItem)((Object)list)).isPrintedToKitchen().booleanValue()) continue;
                object2.remove();
            }
            if (((Ticket)object).getTicketItems().size() == 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ReorderTicketAction.1"));
                return;
            }
            object2 = new ReorderDialog((Ticket)object);
            ((Dialog)object2).setTitle(Messages.getString("ReorderTicketAction.2"));
            ((JDialog)object2).setDefaultCloseOperation(2);
            ((Window)object2).setSize(PosUIManager.getSize(1024, 650));
            ((POSDialog)object2).open();
            if (((POSDialog)object2).isCanceled()) {
                return;
            }
            list = ((ReorderDialog)object2).getTicketItems();
            if (list == null) {
                return;
            }
            for (TicketItem ticketItem : list) {
                ticketItem.setTicket(this.a);
                this.a.addToticketItems(ticketItem);
            }
            this.a.calculatePrice();
            OrderController.saveOrder(this.a);
            if (this.a.getOrderType().isShouldPrintToKitchen().booleanValue() && this.a.needsKitchenPrint()) {
                ReceiptPrintService.printToKitchen(this.a);
                POSMessageDialog.showMessage(Messages.getString("OrderView.8"));
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }
}

