/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.services.TicketService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;

public class SendToKitchenAction
extends PosAction {
    public SendToKitchenAction() {
        super(Messages.getString("SendToKitchenAction.0"));
    }

    public SendToKitchenAction(DataChangeListener dataChangeListener) {
        super(Messages.getString("SendToKitchenAction.1"), dataChangeListener);
    }

    @Override
    public void execute() {
        try {
            Object object = this.getSelectedObject();
            if (object == null) {
                return;
            }
            Ticket ticket = null;
            ticket = object instanceof Ticket ? (Ticket)object : TicketService.getTicket((String)object);
            if (!ticket.getOrderType().isShouldPrintToKitchen().booleanValue()) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SendToKitchenAction.2"));
                return;
            }
            if (ticket.isVoided().booleanValue()) {
                POSMessageDialog.showMessage(Application.getPosWindow(), POSConstants.TICKET_IS_VOIDED);
                return;
            }
            PosPrinters posPrinters = DataProvider.get().getPrinters();
            if (posPrinters.getKitchenPrinters().size() == 0 && posPrinters.getStickerPrinters().size() == 0 && !posPrinters.isPrintToKds()) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SendToKitchenAction.3"));
                return;
            }
            Ticket ticket2 = TicketDAO.getInstance().loadFullTicket(ticket.getId());
            this.a(ticket2);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private void a(Ticket ticket) {
        OrderController.saveOrder(ticket);
        if (ticket.getOrderType().isShouldPrintToKitchen().booleanValue()) {
            if (ticket.needsKitchenPrint()) {
                ReceiptPrintService.printToKitchen(ticket, true);
                POSMessageDialog.showMessage(Messages.getString("TicketView.32"));
            } else {
                POSMessageDialog.showMessage(Messages.getString("TicketView.33"));
            }
        }
    }
}

