/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.report.DailySummaryReportView;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class DailySummaryReportAction
extends AbstractAction {
    public DailySummaryReportAction() {
        super(POSConstants.DAILY_SUMMARY_REPORT);
    }

    public DailySummaryReportAction(String string) {
        super(string);
    }

    public DailySummaryReportAction(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            DailySummaryReportView dailySummaryReportView = null;
            int n = jTabbedPane.indexOfTab(POSConstants.DAILY_SUMMARY_REPORT);
            if (n == -1) {
                dailySummaryReportView = new DailySummaryReportView();
                jTabbedPane.addTab(POSConstants.DAILY_SUMMARY_REPORT, dailySummaryReportView);
            } else {
                dailySummaryReportView = (DailySummaryReportView)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(dailySummaryReportView);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

