/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.report.OpenTicketSummaryReport;
import com.floreantpos.report.ReportViewer;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class OpenTicketSummaryReportAction
extends AbstractAction {
    public OpenTicketSummaryReportAction() {
        super(POSConstants.OPEN_TICKET_SUMMARY);
    }

    public OpenTicketSummaryReportAction(String string) {
        super(string);
    }

    public OpenTicketSummaryReportAction(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            ReportViewer reportViewer = null;
            int n = jTabbedPane.indexOfTab(POSConstants.OPEN_TICKET_SUMMARY);
            if (n == -1) {
                reportViewer = new ReportViewer(new OpenTicketSummaryReport());
                jTabbedPane.addTab(POSConstants.OPEN_TICKET_SUMMARY_REPORT, reportViewer);
            } else {
                reportViewer = (ReportViewer)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(reportViewer);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

