/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config;

import com.floreantpos.PosLog;
import com.floreantpos.config.AppConfig;
import com.floreantpos.extension.AuthorizeNetGatewayPlugin;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.extension.PaymentGatewayPlugin;
import com.floreantpos.model.CardReader;
import com.floreantpos.util.AESencrp;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class CardConfig {
    private static final String a = "MerchantPass";
    private static final String b = "MerchantAccount";
    private static final String c = "CARD_READER";

    public static boolean isSwipeCardSupported() {
        return AppConfig.getBoolean("support-swipe-card", true);
    }

    public static void setSwipeCardSupported(boolean bl) {
        AppConfig.put("support-swipe-card", bl);
    }

    public static boolean isManualEntrySupported() {
        return AppConfig.getBoolean("support-card-manual-entry", true);
    }

    public static void setManualEntrySupported(boolean bl) {
        AppConfig.put("support-card-manual-entry", bl);
    }

    public static boolean isExtTerminalSupported() {
        return AppConfig.getBoolean("support-ext-terminal", true);
    }

    public static void setExtTerminalSupported(boolean bl) {
        AppConfig.put("support-ext-terminal", bl);
    }

    public static void setCardReader(CardReader cardReader) {
        if (cardReader == null) {
            AppConfig.put(c, "");
            return;
        }
        AppConfig.put(c, cardReader.name());
    }

    public static CardReader getCardReader() {
        String string = AppConfig.getString(c, "SWIPE");
        return CardReader.fromString(string);
    }

    public static void setMerchantAccount(String string) {
        AppConfig.put(b, string);
    }

    public static String getMerchantAccount() {
        return AppConfig.getString(b, null);
    }

    public static void setMerchantPass(String string) {
        try {
            if (StringUtils.isEmpty((String)string)) {
                AppConfig.put(a, "");
                return;
            }
            AppConfig.put(a, AESencrp.encrypt(string));
        }
        catch (Exception exception) {
            PosLog.error(CardConfig.class, exception);
        }
    }

    public static String getMerchantPass() throws Exception {
        String string = AppConfig.getString(a);
        try {
            if (StringUtils.isNotEmpty((String)string)) {
                return AESencrp.decrypt(string);
            }
        }
        catch (Exception exception) {
            return string;
        }
        return string;
    }

    public static boolean isSandboxMode() {
        return AppConfig.getBoolean("sandboxMode", true);
    }

    public static void setSandboxMode(boolean bl) {
        AppConfig.put("sandboxMode", bl);
    }

    public static boolean isPreAuthBartab() {
        return AppConfig.getBoolean("preAuthBarTabLimit", true);
    }

    public static void setPreAuthBartab(boolean bl) {
        AppConfig.put("preAuthBarTabLimit", bl);
    }

    public static double getBartabLimit() {
        try {
            return Double.parseDouble(AppConfig.getString("bartablimit", "25"));
        }
        catch (Exception exception) {
            return 25.0;
        }
    }

    public static void setBartabLimit(double d) {
        AppConfig.put("bartablimit", String.valueOf(d));
    }

    public static double getAdvanceTipsPercentage() {
        try {
            return Double.parseDouble(AppConfig.getString("advanceTipsPercentage"));
        }
        catch (Exception exception) {
            return 20.0;
        }
    }

    public static void setAdvanceTipsPercentage(double d) {
        AppConfig.put("advanceTipsPercentage", String.valueOf(d));
    }

    public static void setPaymentGateway(PaymentGatewayPlugin paymentGatewayPlugin) {
        AppConfig.put("payment-gateway-id", paymentGatewayPlugin.getId());
    }

    public static PaymentGatewayPlugin getPaymentGateway() {
        String string = AppConfig.getString("payment-gateway-id", AuthorizeNetGatewayPlugin.ID);
        List<FloreantPlugin> list = ExtensionManager.getPlugins(PaymentGatewayPlugin.class);
        for (FloreantPlugin floreantPlugin : list) {
            if (!string.equals(floreantPlugin.getId())) continue;
            return (PaymentGatewayPlugin)floreantPlugin;
        }
        return new AuthorizeNetGatewayPlugin();
    }

    public static PaymentGatewayPlugin getPaymentGatewayByName(String string) {
        List<FloreantPlugin> list = ExtensionManager.getPlugins(PaymentGatewayPlugin.class);
        for (FloreantPlugin floreantPlugin : list) {
            PaymentGatewayPlugin paymentGatewayPlugin = (PaymentGatewayPlugin)floreantPlugin;
            if (!string.equals(paymentGatewayPlugin.getProductName())) continue;
            return (PaymentGatewayPlugin)floreantPlugin;
        }
        return null;
    }
}

