/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.main.Application;
import com.floreantpos.model.CardReader;
import com.floreantpos.model.Course;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Department;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.ModifiableTicketItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Printer;
import com.floreantpos.model.ReceiptParam;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemCookingInstruction;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.VirtualPrinter;
import com.floreantpos.model.base.BaseCourse;
import com.floreantpos.model.base.BaseModifiableTicketItem;
import com.floreantpos.model.base.BaseTicketItem;
import com.floreantpos.model.base.BaseTicketItemCookingInstruction;
import com.floreantpos.model.base.BaseTicketItemModifier;
import com.floreantpos.model.base.BaseTicketItemSeat;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.ext.CardTypeEnum;
import com.floreantpos.model.ext.ReciptPaperSize;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.ListModel;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.OrderInfoView;
import com.floreantpos.ui.views.TicketReceiptView;
import com.floreantpos.util.GlobalIdGenerator;
import com.floreantpos.util.NumericGlobalIdGenerator;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.ReceiptUtil;
import com.floreantpos.util.ShiftUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.commons.lang.StringUtils;

public class ReceiptConfigurationView
extends JPanel {
    private boolean a = false;
    private JTextPane b;
    private JTextPane c;
    private JTextPane d;
    private JTextPane e;
    private JTextPane f;
    private JList<ReceiptParam> g;
    private OrderType h;
    private Store i;
    private ButtonGroup j;
    private boolean k;
    private OrderInfoView l;
    private KitchenReceiptView m;
    private JCheckBox n = new JCheckBox(Messages.getString("ReceiptConfigurationView.0"));
    private JComboBox o = new JComboBox();
    private JComboBox p = new JComboBox();
    private JComboBox q = new JComboBox();
    private JComboBox r = new JComboBox();
    private JComboBox s = new JComboBox();
    private JComboBox t = new JComboBox();
    private String[] u;
    private JComboBox v = new JComboBox();
    private JCheckBox w = new JCheckBox(Messages.getString("ReceiptConfigurationView.1"));
    private JCheckBox x = new JCheckBox(Messages.getString("ReceiptConfigurationView.2"));
    private JCheckBox y = new JCheckBox(Messages.getString("ReceiptConfigurationView.3"));
    private POSToggleButton z;
    private POSToggleButton A;
    private JComboBox<ReciptPaperSize> B;

    public ReceiptConfigurationView() {
        this(false);
    }

    public ReceiptConfigurationView(boolean bl) {
        this.k = bl;
        this.a();
    }

    public void initialize() throws Exception {
        if (this.a) {
            this.m();
            return;
        }
        DataProvider.get().refreshStore();
        this.i = DataProvider.get().getStore();
        ReceiptParam[] receiptParamArray = ReceiptParam.values();
        this.g.setModel(new ListModel<ReceiptParam>(Arrays.asList(receiptParamArray)));
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        String string = terminal.getProperty("main.recipt.paper_size", ReciptPaperSize.Eighty.name());
        String string2 = terminal.getProperty("kitchen.recipt.paper_size", ReciptPaperSize.Eighty.name());
        if (!this.k) {
            ReciptPaperSize reciptPaperSize = ReciptPaperSize.fromName(string);
            this.B.setSelectedItem((Object)reciptPaperSize);
        } else {
            ReciptPaperSize reciptPaperSize = ReciptPaperSize.fromName(string2);
            this.B.setSelectedItem((Object)reciptPaperSize);
        }
        if (this.k) {
            this.i();
        } else {
            this.g();
        }
        this.h();
        this.a = true;
    }

    private String a(Object object) {
        String string = "#000000";
        Color color = Color.black;
        if (object != null) {
            color = ((SimpleColor)((Object)object)).a;
        }
        try {
            string = "#" + Integer.toHexString(color.getRGB()).substring(2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public boolean save(boolean bl) throws Exception {
        DataProvider.get().refreshStore();
        this.i = DataProvider.get().getStore();
        this.b.getDocument().putProperty("__EndOfLine__", "<br>");
        this.e.getDocument().putProperty("__EndOfLine__", "<br>");
        this.f.getDocument().putProperty("__EndOfLine__", "<br>");
        this.c.getDocument().putProperty("__EndOfLine__", "<br>");
        this.d.getDocument().putProperty("__EndOfLine__", "<br>");
        String string = this.b.getText();
        String string2 = this.e.getText();
        String string3 = this.f.getText();
        String string4 = this.c.getText();
        String string5 = this.d.getText();
        if (string.replaceAll("<br>", "").isEmpty()) {
            string = "";
        }
        if (string2.replaceAll("<br>", "").isEmpty()) {
            string2 = "";
        }
        if (string3.replaceAll("<br>", "").isEmpty()) {
            string3 = "";
        }
        if (string4.replaceAll("<br>", "").isEmpty()) {
            string4 = "";
        }
        if (string5.replaceAll("<br>", "").isEmpty()) {
            string5 = "";
        }
        String string6 = "";
        if (this.h != null && bl) {
            string6 = this.h.getId() + ".";
        }
        Map<String, String> map = this.i.getProperties();
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        ReciptPaperSize reciptPaperSize = (ReciptPaperSize)((Object)this.B.getSelectedItem());
        if (!this.k) {
            POSUtil.storeLongProperty(map, string6 + "ticket.header", string, 255);
            POSUtil.storeLongProperty(map, string6 + "ticket.order.info", string2, 255);
            POSUtil.storeLongProperty(map, string6 + "ticket.order.extrainfo1", string3, 255);
            POSUtil.storeLongProperty(map, string6 + "ticket.footer", string4, 255);
            POSUtil.storeLongProperty(map, string6 + "ticket.bottom", string5, 255);
            this.i.addProperty(string6 + "ticket.modifier.color", this.a(this.o.getSelectedItem()));
            this.i.addProperty(string6 + "ticket.seat.color", this.a(this.p.getSelectedItem()));
            this.i.addProperty(string6 + "ticket.instruction.color", this.a(this.v.getSelectedItem()));
            this.i.addProperty(string6 + "receipt.show_tips_suggestion", String.valueOf(this.n.isSelected()));
            this.i.addProperty(string6 + "receipt.show_tips_block", String.valueOf(this.x.isSelected()));
            this.i.addProperty(string6 + "receipt.show_tax_breakdown", String.valueOf(this.y.isSelected()));
            boolean bl2 = this.w.isSelected();
            this.i.addProperty("showModifierPrice", String.valueOf(bl2));
            terminal.addProperty("main.recipt.paper_size", reciptPaperSize.name());
        } else {
            POSUtil.storeLongProperty(map, string6 + "kitchen.header", string, 255);
            POSUtil.storeLongProperty(map, string6 + "kitchen.order.info", string2, 255);
            POSUtil.storeLongProperty(map, string6 + "kitchen.order.extrainfo1", string3, 255);
            POSUtil.storeLongProperty(map, string6 + "kitchen.footer", string4, 255);
            POSUtil.storeLongProperty(map, string6 + "ticket.bottom", string5, 255);
            this.i.addProperty(string6 + "kitchen_ticket.modifier.color", this.a(this.o.getSelectedItem()));
            this.i.addProperty(string6 + "kitchen_ticket.seat.color", this.a(this.p.getSelectedItem()));
            this.i.addProperty(string6 + "kitchen_ticket.instruction.color", this.a(this.v.getSelectedItem()));
            terminal.addProperty("kitchen.recipt.paper_size", reciptPaperSize.name());
        }
        String string7 = ReceiptParam.STORE_LOGO.getParamName();
        if (string.contains(string7) || string3.contains(string7) || string2.contains(string7) || string4.contains(string7) || string5.contains(string7)) {
            POSUtil.storeLongProperty(map, this.k ? string6 + "kitchen.header.logo.show" : string6 + "ticket.header.logo.show", "true", 255);
        } else {
            POSUtil.storeLongProperty(map, this.k ? string6 + "kitchen.header.logo.show" : string6 + "ticket.header.logo.show", "false", 255);
        }
        TerminalDAO.getInstance().update(terminal);
        StoreDAO.getInstance().saveOrUpdate(this.i);
        Application.getInstance().refreshStore();
        return true;
    }

    private void a() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        int n = Application.getPosWindow().getSize().width / 3 + 80;
        int n2 = PosUIManager.getSize(n);
        int n3 = PosUIManager.getSize(125);
        int n4 = PosUIManager.getDefaultFontSize();
        jPanel.setLayout((LayoutManager)new MigLayout("ins 0 5 0 5 ,wrap 1,filly", "[" + n2 + "]", "[" + n3 + "][grow," + n3 + "][grow," + n3 + "][grow," + n3 + "][" + n3 + "][]"));
        this.g = new JList();
        this.g.setFocusable(false);
        this.g.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ReceiptConfigurationView.this.l();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.g);
        jScrollPane.setBorder(BorderFactory.createTitledBorder("Params"));
        jScrollPane.setPreferredSize(PosUIManager.getSize(130, 200));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("fill"));
        jPanel3.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReceiptConfigurationView.33")));
        this.B = new JComboBox<ReciptPaperSize>(ReciptPaperSize.values());
        jPanel3.add(this.B, "grow");
        jPanel2.add((Component)jPanel3, "North");
        jPanel2.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel2, "West");
        this.b = new JTextPane();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setFontSize(simpleAttributeSet, n4);
        StyleConstants.setAlignment(simpleAttributeSet, 1);
        this.b.setParagraphAttributes(simpleAttributeSet, true);
        JScrollPane jScrollPane2 = new JScrollPane(this.b);
        jScrollPane2.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReceiptConfigurationView.26")));
        jPanel.add((Component)jScrollPane2, "grow");
        this.e = new JTextPane();
        this.e.setParagraphAttributes(simpleAttributeSet, true);
        JScrollPane jScrollPane3 = new JScrollPane(this.e);
        jScrollPane3.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReceiptConfigurationView.28")));
        jPanel.add((Component)jScrollPane3, "grow");
        this.f = new JTextPane();
        StyleConstants.setAlignment(simpleAttributeSet, 0);
        this.f.setParagraphAttributes(simpleAttributeSet, true);
        JScrollPane jScrollPane4 = new JScrollPane(this.f);
        jScrollPane4.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReceiptConfigurationView.30")));
        jPanel.add((Component)jScrollPane4, "grow");
        this.d = new JTextPane();
        StyleConstants.setAlignment(simpleAttributeSet, 0);
        this.d.setParagraphAttributes(simpleAttributeSet, true);
        JScrollPane jScrollPane5 = new JScrollPane(this.d);
        jScrollPane5.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReceiptConfigurationView.37")));
        jPanel.add((Component)jScrollPane5, "grow");
        this.c = new JTextPane();
        StyleConstants.setAlignment(simpleAttributeSet, 1);
        this.c.setParagraphAttributes(simpleAttributeSet, true);
        JScrollPane jScrollPane6 = new JScrollPane(this.c);
        jScrollPane6.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReceiptConfigurationView.32")));
        jPanel.add((Component)jScrollPane6, "grow");
        jPanel.add((Component)this.b(), "grow");
        jPanel.add((Component)this.d(), "grow");
        JScrollPane jScrollPane7 = new JScrollPane(jPanel);
        jScrollPane7.setBorder(null);
        this.add(jScrollPane7);
        JPanel jPanel4 = new JPanel((LayoutManager)new MigLayout("fillx,ins 3 0 3 0"));
        jPanel4.add((Component)new JSeparator(), "span,growx");
        JButton jButton = new JButton(POSConstants.RESTORE_DEFAULTS);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("ReceiptConfigurationView.35"), POSConstants.CONFIRM) == 1) {
                    return;
                }
                ReceiptConfigurationView.this.e();
            }
        });
        jPanel4.add((Component)jButton, "split 2,center, gapbottom 0");
        JButton jButton2 = new JButton(POSConstants.SAVE);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ReceiptConfigurationView.this.save(true);
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ReceiptConfigurationView.36"));
                    if (ReceiptConfigurationView.this.k) {
                        ReceiptConfigurationView.this.b(false);
                    } else {
                        ReceiptConfigurationView.this.a(false);
                    }
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(exception.getMessage());
                }
            }
        });
        jPanel4.add(jButton2);
        this.add((Component)jPanel4, "South");
    }

    private JPanel b() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        jPanel.add(this.n);
        jPanel.add(this.w);
        jPanel.add(this.x);
        jPanel.add(this.y);
        return jPanel;
    }

    private JPanel c() {
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.u = graphicsEnvironment.getAvailableFontFamilyNames();
        this.q.setModel(new DefaultComboBoxModel<String>(this.u));
        this.s.setModel(new DefaultComboBoxModel<String>(this.u));
        Integer[] integerArray = new Integer[]{10, 12, 14, 16, 18, 20, 22, 24};
        this.r.setModel(new DefaultComboBoxModel<Integer>(integerArray));
        this.t.setModel(new DefaultComboBoxModel<Integer>(integerArray));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("ins 2,fillx", "[]10[]", ""));
        jPanel2.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReceiptConfigurationView.72")));
        jPanel2.add((Component)new JLabel(Messages.getString("ReceiptConfigurationView.73")), "split 2");
        jPanel2.add(this.q);
        jPanel2.add((Component)new JLabel(Messages.getString("ReceiptConfigurationView.74")), "split 2");
        jPanel2.add(this.r);
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("ins 2,fillx", "[]10[]", ""));
        jPanel3.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReceiptConfigurationView.71")));
        jPanel3.add((Component)new JLabel(Messages.getString("ReceiptConfigurationView.73")), "split 2");
        jPanel3.add(this.s);
        jPanel3.add((Component)new JLabel(Messages.getString("ReceiptConfigurationView.74")), "split 2");
        jPanel3.add(this.t);
        jPanel.add((Component)jPanel2, "grow, wrap");
        jPanel.add((Component)jPanel3, "grow");
        return jPanel;
    }

    private JPanel d() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("ins 2,fillx"));
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReceiptConfigurationView.9")));
        this.o.setModel(new DefaultComboBoxModel<SimpleColor>(SimpleColor.values()));
        this.v.setModel(new DefaultComboBoxModel<SimpleColor>(SimpleColor.values()));
        this.p.setModel(new DefaultComboBoxModel<SimpleColor>(SimpleColor.values()));
        jPanel.add((Component)new JLabel(Messages.getString("ReceiptConfigurationView.10")), "split 2");
        jPanel.add((Component)this.o, "");
        jPanel.add(new JLabel(Messages.getString("ReceiptConfigurationView.13")));
        jPanel.add((Component)this.p, "");
        jPanel.add(new JLabel(Messages.getString("ReceiptConfigurationView.15")));
        jPanel.add((Component)this.v, "");
        return jPanel;
    }

    private void e() {
        try {
            this.m();
            if (this.k) {
                ReceiptUtil.populateDefaultKitchenReceiptProperties(this.i);
            } else {
                ReceiptUtil.populateDefaultTicketReceiptProperties(this.i);
            }
            this.f();
            this.a = false;
            this.initialize();
            this.save(false);
            if (this.k) {
                this.b(false);
            } else {
                this.a(false);
            }
        }
        catch (Exception exception) {
            BOMessageDialog.showError(exception.getMessage());
        }
    }

    private void f() {
        if (this.h == null) {
            return;
        }
        String string = this.h.getId();
        try {
            Map<String, String> map = this.i.getProperties();
            if (!this.k) {
                POSUtil.removeLongProperty(map, string + "." + "ticket.header");
                POSUtil.removeLongProperty(map, string + "." + "ticket.order.info");
                POSUtil.removeLongProperty(map, string + "." + "ticket.footer");
                POSUtil.removeLongProperty(map, string + "." + "ticket.order.extrainfo1");
                POSUtil.removeLongProperty(map, string + "." + "ticket.order.extrainfo2");
                POSUtil.removeLongProperty(map, string + "." + "ticket.modifier.color");
                POSUtil.removeLongProperty(map, string + "." + "ticket.seat.color");
                POSUtil.removeLongProperty(map, string + "." + "ticket.instruction.color");
                POSUtil.removeLongProperty(map, string + "." + "ticket.header.logo.show");
            } else {
                POSUtil.removeLongProperty(map, string + "." + "kitchen.header");
                POSUtil.removeLongProperty(map, string + "." + "kitchen.order.info");
                POSUtil.removeLongProperty(map, string + "." + "kitchen.footer");
                POSUtil.removeLongProperty(map, string + "." + "kitchen.order.extrainfo1");
                POSUtil.removeLongProperty(map, string + "." + "kitchen.order.extrainfo2");
                POSUtil.removeLongProperty(map, string + "." + "kitchen_ticket.modifier.color");
                POSUtil.removeLongProperty(map, string + "." + "kitchen_ticket.seat.color");
                POSUtil.removeLongProperty(map, string + "." + "kitchen_ticket.instruction.color");
                POSUtil.removeLongProperty(map, string + "." + "kitchen.header.logo.show");
            }
            StoreDAO.getInstance().saveOrUpdate(this.i);
            Application.getInstance().refreshStore();
        }
        catch (Exception exception) {
            PosLog.error(ReceiptConfigurationView.class, exception.getMessage(), exception);
        }
    }

    private void g() {
        ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
        try {
            this.l = new OrderInfoView(arrayList);
            this.l.setPreferredSize(PosUIManager.getSize(500, 0));
            this.l.setBorder(new EmptyBorder(8, 0, 5, 0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.add((Component)this.l, "East");
        this.l.add(this.k(), "South");
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("wrap 1,ins 0 3 0 3", "sg,fill", ""));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReceiptConfigurationView.this.a(actionEvent);
            }
        };
        ButtonGroup buttonGroup = new ButtonGroup();
        this.h = null;
        List<OrderType> list = OrderTypeDAO.getInstance().findAll();
        String string = "w " + PosUIManager.getSize(90);
        if (list == null || list.isEmpty()) {
            this.j();
            return;
        }
        for (OrderType orderType : list) {
            POSToggleButton pOSToggleButton = new POSToggleButton("<html><center>" + orderType.getName() + "</center></html>");
            buttonGroup.add(pOSToggleButton);
            jPanel.add((Component)pOSToggleButton, string);
            pOSToggleButton.putClientProperty("orderType", orderType);
            pOSToggleButton.addActionListener(actionListener);
            if (this.h != null) continue;
            this.h = orderType;
            pOSToggleButton.setSelected(true);
            arrayList.add(this.createNewTicket(orderType, null));
        }
        jPanel.add((Component)new JSeparator(), "gaptop 20");
        this.j = new ButtonGroup();
        this.z = new POSToggleButton("<html><center>Guest Check</center></html>");
        this.z.putClientProperty("guestCheck", "cash");
        this.z.addActionListener(actionListener);
        this.j.add(this.z);
        jPanel.add((Component)this.z, string);
        this.A = new POSToggleButton("<html><center>Guest Check (Credit Card)</center><html>");
        this.A.putClientProperty("guestCheck", "creditCard");
        this.A.addActionListener(actionListener);
        this.j.add(this.A);
        jPanel.add((Component)this.A, string);
        this.l.add((Component)jPanel, "East");
        this.a(false);
    }

    private String a(String string, String string2) {
        String string3;
        if (StringUtils.isNotEmpty((String)string)) {
            string = string + ".";
        }
        if (StringUtils.isEmpty((String)(string3 = this.i.getProperty(string + string2)))) {
            string3 = this.i.getProperty(string2);
        }
        return string3;
    }

    private void h() {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (this.h != null) {
            string5 = this.h.getId();
        }
        if (!this.k) {
            string = ReceiptUtil.getReceiptSection(this.i, "ticket.header", string5);
            string2 = ReceiptUtil.getReceiptSection(this.i, "ticket.order.info", string5);
            string3 = ReceiptUtil.getReceiptSection(this.i, "ticket.order.extrainfo1", string5);
            string4 = ReceiptUtil.getReceiptSection(this.i, "ticket.footer", string5);
            this.o.setSelectedItem((Object)SimpleColor.getColor(this.a(string5, "ticket.modifier.color")));
            this.p.setSelectedItem((Object)SimpleColor.getColor(this.a(string5, "ticket.seat.color")));
            this.v.setSelectedItem((Object)SimpleColor.getColor(this.a(string5, "ticket.instruction.color")));
            boolean bl = this.i.getProperty(string5 + "." + "receipt.show_tips_suggestion") == null ? false : Boolean.valueOf(this.i.getProperty(string5 + "." + "receipt.show_tips_suggestion"));
            this.n.setSelected(bl);
            boolean bl2 = this.i.getProperty("showModifierPrice") == null ? false : Boolean.valueOf(this.i.getProperty("showModifierPrice"));
            this.w.setSelected(bl2);
            boolean bl3 = this.i.getProperty(string5 + "." + "receipt.show_tips_block") == null ? false : Boolean.valueOf(this.i.getProperty(string5 + "." + "receipt.show_tips_block"));
            this.x.setSelected(bl3);
            boolean bl4 = this.i.getProperty(string5 + "." + "receipt.show_tax_breakdown") == null ? false : Boolean.valueOf(this.i.getProperty(string5 + "." + "receipt.show_tax_breakdown"));
            this.y.setSelected(bl4);
        } else {
            string = ReceiptUtil.getReceiptSection(this.i, "kitchen.header", string5);
            string2 = ReceiptUtil.getReceiptSection(this.i, "kitchen.order.info", string5);
            string3 = ReceiptUtil.getReceiptSection(this.i, "kitchen.order.extrainfo1", string5);
            string4 = ReceiptUtil.getReceiptSection(this.i, "kitchen.footer", string5);
            this.o.setSelectedItem((Object)SimpleColor.getColor(this.a(string5, "kitchen_ticket.modifier.color")));
            this.p.setSelectedItem((Object)SimpleColor.getColor(this.a(string5, "kitchen_ticket.seat.color")));
            this.v.setSelectedItem((Object)SimpleColor.getColor(this.a(string5, "kitchen_ticket.instruction.color")));
        }
        this.w.setVisible(!this.k);
        string = string.replaceAll("<br>", "\n");
        string2 = string2.replaceAll("<br>", "\n");
        string3 = string3.replaceAll("<br>", "\n");
        string4 = string4.replaceAll("<br>", "\n");
        this.b.setText(string);
        this.e.setText(string2);
        this.f.setText(string3);
        this.c.setText(string4);
    }

    private void i() {
        try {
            this.m = new KitchenReceiptView();
            this.m.setBorder(new EmptyBorder(8, 0, 5, 0));
            this.m.setPreferredSize(PosUIManager.getSize(500, 0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.add((Component)this.m, "East");
        this.m.add(this.k(), "South");
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("wrap 1,ins 0 3 0 3", "sg,fill", ""));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                POSToggleButton pOSToggleButton = (POSToggleButton)actionEvent.getSource();
                OrderType orderType = (OrderType)pOSToggleButton.getClientProperty("orderType");
                if (orderType != null) {
                    ReceiptConfigurationView.this.h = orderType;
                }
                ReceiptConfigurationView.this.h();
                ReceiptConfigurationView.this.b(true);
            }
        };
        ButtonGroup buttonGroup = new ButtonGroup();
        this.h = null;
        List<OrderType> list = OrderTypeDAO.getInstance().findAll();
        if (list == null || list.isEmpty()) {
            this.j();
            return;
        }
        for (OrderType orderType : list) {
            POSToggleButton pOSToggleButton = new POSToggleButton("<html><center>" + orderType.getName() + "</center></html>");
            buttonGroup.add(pOSToggleButton);
            String string = "w " + PosUIManager.getSize(90);
            jPanel.add((Component)pOSToggleButton, string);
            pOSToggleButton.putClientProperty("orderType", orderType);
            pOSToggleButton.addActionListener(actionListener);
            if (this.h != null) continue;
            this.h = orderType;
            pOSToggleButton.setSelected(true);
        }
        this.m.add((Component)jPanel, "East");
        this.b(false);
    }

    private void j() {
        POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ReceiptConfigurationView.66"));
        this.removeAll();
    }

    private Component k() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("ins 5 5 0 5"));
        JButton jButton = new JButton(Messages.getString("ReceiptConfigurationView.64"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ReceiptConfigurationView.this.k) {
                    ReceiptConfigurationView.this.b(true);
                } else {
                    ReceiptConfigurationView.this.a(true);
                }
            }
        });
        JButton jButton2 = new JButton(Messages.getString("ReceiptConfigurationView.65"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ReceiptConfigurationView.this.save(false);
                    if (ReceiptConfigurationView.this.k) {
                        ReceiptConfigurationView.this.m.print();
                    } else {
                        ReceiptConfigurationView.this.l.print();
                    }
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(exception.getMessage());
                }
            }
        });
        jPanel.add((Component)jButton, "gapleft 100!,split 2");
        jPanel.add(jButton2);
        return jPanel;
    }

    private void a(boolean bl) {
        try {
            block13: {
                if (bl) {
                    this.save(true);
                }
                if (this.A.isSelected() || this.z.isSelected()) {
                    String string = null;
                    if (this.z.isSelected()) {
                        string = (String)this.z.getClientProperty("guestCheck");
                    } else if (this.A.isSelected()) {
                        string = (String)this.A.getClientProperty("guestCheck");
                    }
                    ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
                    Ticket ticket = this.createNewTicket(this.h, string);
                    arrayList.add(ticket);
                    this.h();
                    this.l.setTickets(arrayList);
                    try {
                        this.l.getReportPanel().removeAll();
                        if (string == null) {
                            this.l.createReport();
                            break block13;
                        }
                        this.l.createReport(ticket.getTransactions().iterator().next());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
                    Ticket ticket = this.createNewTicket(this.h, null);
                    arrayList.add(ticket);
                    this.l.setTickets(arrayList);
                    try {
                        this.l.getReportPanel().removeAll();
                        this.l.createReport();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            this.l.revalidate();
            this.l.repaint();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    private void b(boolean bl) {
        try {
            if (bl) {
                this.save(true);
            }
            Ticket ticket = this.createNewTicket(this.h, null);
            try {
                this.m.getReportPanel().removeAll();
                this.m.createReport(ticket);
                this.m.revalidate();
                this.m.repaint();
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    public Ticket createNewTicket(OrderType orderType, String string) {
        Object object;
        Cloneable cloneable;
        SalesArea salesArea;
        int n = 4;
        Date date = null;
        boolean bl = false;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        Double d = 0.0;
        Customer customer = new Customer();
        customer.setFirstName("Firstname");
        customer.setLastName("Lastname");
        customer.setMobileNo("+02............");
        customer.setZipCode("565656");
        customer.setMemberId(Messages.getString("ReceiptConfigurationView.97"));
        customer.setSignatureImageId(Messages.getString("ReceiptConfigurationView.98"));
        if (orderType.isDelivery().booleanValue()) {
            date = new Date();
            string2 = "Customer address.....";
            string3 = Messages.getString("ReceiptConfigurationView.70");
            string4 = "Phone extension..";
            string5 = "Manager instructions..";
            bl = false;
            d = 0.0;
        }
        Application application = Application.getInstance();
        Ticket ticket = new Ticket(true);
        ticket.setTaxIncluded(Application.getInstance().isPriceIncludesTax());
        ticket.setOrderType(orderType);
        ticket.setNumberOfGuests(n);
        if (bl) {
            ticket.setCustomerWillPickup(true);
        } else {
            ticket.setDeliveryDate(date);
            ticket.setDeliveryAddress(string2);
            ticket.setExtraDeliveryInfo(string3);
            ticket.addProperty("PHONE_EXTENSION", string4);
            ticket.addProperty("MANAGER_INSTRUCTION", string5);
            ticket.setDeliveryCharge(d);
            ticket.setCustomerWillPickup(false);
        }
        if (customer != null) {
            ticket.setCustomer(customer);
        }
        Terminal terminal = application.getTerminal();
        ticket.setTerminal(terminal);
        Department department = terminal.getDepartment();
        if (department != null) {
            ticket.setDepartmentId(department.getId());
        }
        if ((salesArea = terminal.getSalesArea()) != null) {
            ticket.setSalesAreaId(salesArea.getId());
        }
        User user = Application.getCurrentUser();
        ticket.setOwner(user);
        ticket.setShift(ShiftUtil.getCurrentShift());
        if (this.h.isShowTableSelection().booleanValue()) {
            cloneable = new ArrayList();
            cloneable.add(1);
            cloneable.add(2);
            ticket.setTableNumbers((List<Integer>)((Object)cloneable));
        }
        cloneable = DateUtil.getServerTimeCalendar();
        ticket.setCreateDate(((Calendar)cloneable).getTime());
        ticket.setCreationHour(((Calendar)cloneable).get(11));
        ticket.setId(NumericGlobalIdGenerator.generateGlobalId());
        ticket.setTokenNo(1);
        TicketItemTax ticketItemTax = new TicketItemTax();
        ticketItemTax.setId(GlobalIdGenerator.generateGlobalId());
        ticketItemTax.setName(Messages.getString("ReceiptConfigurationView.99"));
        ticketItemTax.setRate(6.0);
        TicketItemTax ticketItemTax2 = new TicketItemTax();
        ticketItemTax2.setId(GlobalIdGenerator.generateGlobalId());
        ticketItemTax2.setName(Messages.getString("ReceiptConfigurationView.100"));
        ticketItemTax2.setRate(15.0);
        for (int i = 0; i < 5; ++i) {
            Comparable comparable;
            Comparable comparable2;
            object = new PreviewTicketItem();
            ((BaseTicketItem)object).setId(NumericGlobalIdGenerator.generateGlobalId());
            ((BaseTicketItem)object).setMenuItemId("0");
            ((BaseTicketItem)object).setName("Item " + (i + 1));
            ((BaseTicketItem)object).setQuantity((double)i + 1.0);
            ((BaseTicketItem)object).setUnitPrice(2.5);
            ((BaseTicketItem)object).setShouldPrintToKitchen(true);
            ((TicketItem)object).setTaxes(Arrays.asList(ticketItemTax, ticketItemTax2));
            if (orderType.isEnableCourse().booleanValue()) {
                comparable2 = new Course(Messages.getString("ReceiptConfigurationView.101") + (i + 1));
                ((BaseCourse)comparable2).setShortName(Messages.getString("ReceiptConfigurationView.101") + (i + 1));
                ((BaseTicketItem)object).setCourseName(Messages.getString("ReceiptConfigurationView.101") + (i + 1));
            }
            ticket.addToticketItems((TicketItem)object);
            if (i == 1) {
                for (int j = 0; j <= 1; ++j) {
                    comparable = new TicketItemModifier();
                    ((BaseTicketItemModifier)comparable).setId(NumericGlobalIdGenerator.generateGlobalId());
                    ((BaseTicketItemModifier)comparable).setItemId("0");
                    ((BaseTicketItemModifier)comparable).setGroupId("0");
                    ((BaseTicketItemModifier)comparable).setItemQuantity(2.0);
                    ((BaseTicketItemModifier)comparable).setName("Modifier " + (j + 1));
                    ((BaseTicketItemModifier)comparable).setUnitPrice(1.5);
                    ((BaseTicketItemModifier)comparable).setShouldPrintToKitchen(true);
                    ((BaseTicketItemModifier)comparable).setTicketItem((TicketItem)object);
                    ((BaseModifiableTicketItem)object).addToticketItemModifiers((TicketItemModifier)comparable);
                }
            } else if (i == 2) {
                comparable2 = new TicketItemCookingInstruction();
                ((BaseTicketItemCookingInstruction)comparable2).setDescription("Fry (Cooking Ins.)");
                ((TicketItem)object).addCookingInstruction((TicketItemCookingInstruction)comparable2);
            }
            if (i == 2) {
                TicketItem ticketItem = new TicketItem();
                comparable = new TicketItemSeat();
                ticketItem.setName("Seat** 1");
                ticketItem.setShouldPrintToKitchen(true);
                ticketItem.setTreatAsSeat(true);
                ticketItem.setSeatNumber(1);
                ticketItem.setPrintedToKitchen(false);
                ticketItem.setShouldPrintToKitchen(true);
                ticketItem.setSeat((TicketItemSeat)comparable);
                ((BaseTicketItemSeat)comparable).setSeatNumber(1);
                ticket.addToticketItems(ticketItem);
                continue;
            }
            if (i != 3) continue;
            TicketItem ticketItem = new TicketItem();
            comparable = new TicketItemSeat();
            ticketItem.setName("Seat** Shared");
            ticketItem.setShouldPrintToKitchen(true);
            ticketItem.setTreatAsSeat(true);
            ticketItem.setSeatNumber(null);
            ticketItem.setPrintedToKitchen(false);
            ticketItem.setShouldPrintToKitchen(true);
            ticketItem.setSeat((TicketItemSeat)comparable);
            ((BaseTicketItemSeat)comparable).setSeatNumber(1);
            ticket.addToticketItems(ticketItem);
        }
        ticket.calculatePrice();
        PosTransaction posTransaction = null;
        object = null;
        if (string != null && string.equals("creditCard")) {
            object = PaymentType.CREDIT_CARD;
            posTransaction = ((PaymentType)((Object)object)).createTransaction();
            posTransaction.setCaptured(false);
            posTransaction.setCardMerchantGateway("Payment gateway name..");
            posTransaction.setCardReader(CardReader.MANUAL.name());
            posTransaction.setCardHolderName("Card holder name");
            posTransaction.setCardNumber("4111111111111111");
            posTransaction.setCardExpMonth("12");
            posTransaction.setCardExpYear("2020");
            posTransaction.setCardType(CardTypeEnum.VISA.name());
            posTransaction.setCardAuthCode("00000");
            posTransaction.setTransactionType(TransactionType.CREDIT.name());
            ticket.setCashier(user);
        } else {
            object = PaymentType.CASH;
            posTransaction = ((PaymentType)((Object)object)).createTransaction();
        }
        posTransaction.setTenderAmount(ticket.getDueAmount());
        posTransaction.setAmount(ticket.getDueAmount());
        posTransaction.setTicket(ticket);
        ticket.addTotransactions(posTransaction);
        ticket.setVoided(false);
        ticket.setTerminal(terminal);
        ticket.setPaidAmount(ticket.getPaidAmount() + posTransaction.getAmount());
        if (ticket.isSourceOnline()) {
            ticket.setDueAmount(ticket.getTotalAmountWithTips() - ticket.getPaidAmount());
        } else {
            ticket.calculatePrice();
        }
        Date date2 = new Date();
        if (ticket.getDueAmount() == 0.0) {
            ticket.setPaid(true);
        } else {
            ticket.setPaid(false);
            ticket.setClosed(false);
        }
        posTransaction.setTerminal(terminal);
        posTransaction.setUser(user);
        posTransaction.setServer(user);
        posTransaction.setTransactionTime(date2);
        return ticket;
    }

    private void l() {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        JTextComponent jTextComponent = null;
        if (!(component instanceof JTextComponent)) {
            return;
        }
        jTextComponent = (JTextComponent)component;
        ReceiptParam receiptParam = this.g.getSelectedValue();
        if (receiptParam == null) {
            return;
        }
        String string = "<" + receiptParam.getParamName() + ">$" + receiptParam.getParamName() + "</" + receiptParam.getParamName() + ">";
        jTextComponent.replaceSelection(string);
    }

    private void m() {
        DataProvider.get().refreshStore();
        this.i = DataProvider.get().getStore();
    }

    private void a(ActionEvent actionEvent) {
        try {
            String string;
            POSToggleButton pOSToggleButton = (POSToggleButton)actionEvent.getSource();
            OrderType orderType = (OrderType)pOSToggleButton.getClientProperty("orderType");
            if (orderType != null) {
                this.h = orderType;
            }
            if (StringUtils.isEmpty((String)(string = (String)pOSToggleButton.getClientProperty("guestCheck")))) {
                string = null;
                this.j.clearSelection();
            }
            ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
            Ticket ticket = this.createNewTicket(this.h, string);
            arrayList.add(ticket);
            this.h();
            this.l.setTickets(arrayList);
            this.l.getReportPanel().removeAll();
            if (string == null) {
                this.l.createReport();
            } else {
                this.l.createReport(ticket.getTransactions().iterator().next());
            }
            this.l.revalidate();
            this.l.repaint();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    static class PreviewTicketItem
    extends ModifiableTicketItem {
        private static final long b = 1L;

        @Override
        public List<Printer> getPrinters(OrderType orderType) {
            ArrayList<Printer> arrayList = new ArrayList<Printer>();
            arrayList.add(VirtualPrinter.getKdsPrinter());
            return arrayList;
        }
    }

    static enum SimpleColor {
        black(Color.black),
        red(Color.red);

        final Color a;

        private SimpleColor(Color color) {
            this.a = color;
        }

        public static SimpleColor getColor(String string) {
            Color color = SimpleColor.getAwtColor(string);
            if (color != null) {
                for (SimpleColor simpleColor : SimpleColor.values()) {
                    if (simpleColor.a.getRGB() != color.getRGB()) continue;
                    return simpleColor;
                }
            }
            return black;
        }

        public static Color getAwtColor(String string) {
            try {
                return Color.decode(string);
            }
            catch (Exception exception) {
                return Color.black;
            }
        }

        static String[] a() {
            List<SimpleColor> list = Arrays.asList(SimpleColor.values());
            String string = list.toString().replaceAll(" ", "");
            return string.substring(1, string.length() - 1).split(",");
        }
    }

    public class KitchenReceiptView
    extends JPanel {
        private JPanel b;
        private Ticket c;

        public KitchenReceiptView() {
            this.createUI();
        }

        public void createUI() {
            this.b = new JPanel((LayoutManager)new MigLayout("wrap 1, ax 50%", "", ""));
            PosScrollPane posScrollPane = new PosScrollPane(this.b);
            posScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            this.setLayout(new BorderLayout());
            this.add(posScrollPane);
        }

        public void createReport(Ticket ticket) throws Exception {
            this.c = ticket;
            JasperPrint jasperPrint = this.getKitchenJasperPrint(ticket);
            TicketReceiptView ticketReceiptView = new TicketReceiptView(jasperPrint);
            this.b.add(ticketReceiptView.getReportPanel());
        }

        public JasperPrint getKitchenJasperPrint(Ticket ticket) {
            try {
                List<KitchenTicket> list = KitchenTicket.fromTicket(ticket, false);
                Iterator<KitchenTicket> iterator = list.iterator();
                if (iterator.hasNext()) {
                    KitchenTicket kitchenTicket = iterator.next();
                    kitchenTicket.setParentTicket(ticket);
                    JasperPrint jasperPrint = ReceiptPrintService.createKitchenPrint("", kitchenTicket, "", true);
                    jasperPrint.setName("FP_KitchenReceipt_" + ticket.getId() + "_" + kitchenTicket.getSequenceNumber());
                    return jasperPrint;
                }
            }
            catch (Exception exception) {
                POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
            }
            return null;
        }

        public void print() throws Exception {
            ReceiptPrintService.printToKitchen(this.c, false, false);
        }

        public JPanel getReportPanel() {
            return this.b;
        }
    }
}

